/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic;

import ic2.api.reactor.ISteamReactor;
import ic2.core.block.machine.logic.ReactorLogicBase;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class SteamReactorLogicBase
extends ReactorLogicBase
implements ISteamReactor {
    FluidTank waterTank = new FluidTank(2000);
    FluidTank steamTank = new FluidTank(20000);
    public long totalUsedWater = 0L;
    public long totalProducedSteam = 0L;

    public SteamReactorLogicBase(TileEntityReactorPlanner tile) {
        super(tile);
    }

    @Override
    public void clear() {
        super.clear();
        this.totalUsedWater = 0L;
        this.totalProducedSteam = 0L;
    }

    @Override
    public void reset() {
        this.totalUsedWater = 0L;
        this.totalProducedSteam = 0L;
    }

    @Override
    public void validate() {
        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE), true);
        this.steamTank.drain(Integer.MAX_VALUE, true);
        this.totalUsedWater = 0L;
        this.totalProducedSteam = 0L;
    }

    public void updateTanks() {
        this.totalUsedWater += (long)this.waterTank.fill(new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE), true);
        FluidStack steam = this.steamTank.drain(Integer.MAX_VALUE, true);
        if (steam != null) {
            this.totalProducedSteam += (long)steam.amount;
        }
    }

    @Override
    public boolean isSteamLogic() {
        return true;
    }

    @Override
    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    @Override
    public FluidTank getSteamTank() {
        return this.steamTank;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
        this.steamTank.readFromNBT(nbt.func_74775_l("SteamTank"));
        this.totalUsedWater = nbt.func_74763_f("TotalWater");
        this.totalProducedSteam = nbt.func_74763_f("TotalSteam");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.waterTank.writeToNBT(this.getTag(nbt, "WaterTank"));
        this.steamTank.writeToNBT(this.getTag(nbt, "SteamTank"));
        nbt.func_74772_a("TotalWater", this.totalUsedWater);
        nbt.func_74772_a("TotalSteam", this.totalProducedSteam);
    }

    @Override
    public void read(DataInput stream) {
        super.read(stream);
        try {
            this.totalUsedWater = stream.readLong();
            this.totalProducedSteam = stream.readLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(DataOutput stream) {
        super.write(stream);
        try {
            stream.writeLong(this.totalUsedWater);
            stream.writeLong(this.totalProducedSteam);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readStateFromNBT(NBTTagCompound nbt) {
        super.readStateFromNBT(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
        this.steamTank.readFromNBT(nbt.func_74775_l("SteamTank"));
        this.totalUsedWater = nbt.func_74763_f("TotalWater");
        this.totalProducedSteam = nbt.func_74763_f("TotalSteam");
    }

    @Override
    public void writeStateToNBT(NBTTagCompound nbt) {
        super.writeStateToNBT(nbt);
        this.waterTank.writeToNBT(this.getTag(nbt, "WaterTank"));
        this.steamTank.writeToNBT(this.getTag(nbt, "SteamTank"));
        nbt.func_74772_a("TotalWater", this.totalUsedWater);
        nbt.func_74772_a("TotalSteam", this.totalProducedSteam);
    }
}

