/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic.encoder;

import com.google.common.base.Strings;
import ic2.core.block.machine.logic.encoder.IEncoder;
import ic2.core.block.machine.logic.encoder.impl.OldNBTEncoder;
import ic2.core.block.machine.logic.encoder.impl.TalonEncoder;
import ic2.core.block.machine.logic.encoder.impl.V1Encoder;
import ic2.core.util.Tuple;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class EncoderRegistry {
    public static EncoderRegistry instance = new EncoderRegistry();
    protected Map<String, IEncoder> encoderMap = new LinkedHashMap<String, IEncoder>();
    protected Map<String, String> idToNameMap = new LinkedHashMap<String, String>();
    protected String defaultEncoder;

    public void init() {
        this.registerEncoder("OldNBT", new OldNBTEncoder());
        this.registerEncoder("Talon", new TalonEncoder());
        this.registerEncoder("V1", new V1Encoder());
        this.setDefaultEncoder("V1");
    }

    public void setDefaultEncoder(String id) {
        this.defaultEncoder = id;
    }

    public String getDefaultEncoderID() {
        return this.defaultEncoder;
    }

    public IEncoder getDefaultEncoder() {
        return this.encoderMap.get(this.getDefaultEncoderID());
    }

    public void registerEncoder(String id, IEncoder encoder) {
        if (encoder == null || id == null) {
            return;
        }
        this.encoderMap.put(id, encoder);
        this.idToNameMap.put(id, encoder.getName());
    }

    public IEncoder getEncoderFromID(String id) {
        return this.encoderMap.get(id);
    }

    public Tuple<String, NBTTagCompound> createDecodedMessage(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return null;
        }
        for (Map.Entry<String, IEncoder> entry : this.encoderMap.entrySet()) {
            IEncoder encoder = entry.getValue();
            NBTTagCompound nbt = encoder.createDecodedData(text);
            if (nbt == null) continue;
            return new Tuple<String, NBTTagCompound>(entry.getKey(), nbt);
        }
        return null;
    }

    public Tuple<String[], String[]> getChoiceList() {
        String[] key = new String[this.idToNameMap.size()];
        String[] value = new String[this.idToNameMap.size()];
        int id = 0;
        for (Map.Entry<String, String> entry : this.idToNameMap.entrySet()) {
            key[id] = entry.getKey();
            value[id] = entry.getValue();
            ++id;
        }
        return new Tuple<String[], String[]>(key, value);
    }
}

