/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic.encoder.impl;

import ic2.core.block.machine.logic.PlannerRegistry;
import ic2.core.block.machine.logic.ReactorLogicBase;
import ic2.core.block.machine.logic.encoder.IEncoder;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class OldNBTEncoder
implements IEncoder {
    @Override
    public NBTTagCompound createDecodedData(String data) {
        try {
            DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(new BigInteger(data, 36).toByteArray())));
            String exportedNBT = stream.readUTF();
            stream.close();
            if (exportedNBT.startsWith("{") && exportedNBT.endsWith("}")) {
                return (NBTTagCompound)JsonToNBT.func_150315_a((String)exportedNBT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void processData(NBTTagCompound decodedData, TileEntityReactorPlanner planner) {
        planner.isSteamReactor = decodedData.func_74767_n("SteamReactor");
        planner.reactorSize = 6;
        ReactorLogicBase base = planner.getReactorLogic();
        base.clear();
        NBTTagList list = decodedData.func_150295_c("Data", 10);
        boolean valid = false;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            short id = data.func_74765_d("ID");
            int[] array = data.func_74759_k("Slots");
            ItemStack item = PlannerRegistry.getComponentFromID(id);
            for (int z = 0; z < array.length; ++z) {
                int slot = array[z];
                if (slot == -1) continue;
                base.func_70299_a(slot, ItemStack.func_77944_b((ItemStack)item));
                valid = true;
            }
        }
        if (valid) {
            base.validate();
        }
    }

    @Override
    public String createEncodedData(TileEntityReactorPlanner planner) {
        ReactorLogicBase logic = planner.getReactorLogic();
        HashMap<Short, ArrayList<Integer>> amounts = new HashMap<Short, ArrayList<Integer>>();
        for (int i = 0; i < 54; ++i) {
            short s;
            ItemStack stack = logic.func_70301_a(i);
            if (stack == null || (s = PlannerRegistry.getID(stack)) == -1) continue;
            ArrayList<Integer> list = (ArrayList<Integer>)amounts.get(s);
            if (list == null) {
                list = new ArrayList<Integer>();
                amounts.put(s, list);
            }
            list.add(i);
        }
        NBTTagList dataList = new NBTTagList();
        for (Map.Entry entry : amounts.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("ID", ((Short)entry.getKey()).shortValue());
            List slots = (List)entry.getValue();
            if (slots.size() == 1) {
                slots.add(-1);
            }
            int[] slotArray = new int[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                slotArray[i] = (Integer)slots.get(i);
            }
            nbt.func_74783_a("Slots", slotArray);
            dataList.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Data", (NBTBase)dataList);
        nbt.func_74757_a("SteamReactor", planner.isSteamReactor);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(new GZIPOutputStream(byteArrayOutputStream));
            stream.writeUTF(nbt.toString());
            stream.close();
            return new BigInteger(byteArrayOutputStream.toByteArray()).toString(36);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "First (NBT)";
    }

    @Override
    public boolean hasBitLimit() {
        return false;
    }

    @Override
    public int getBitLimit() {
        return 0;
    }
}

