/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManagerExp;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCompressor
extends TileEntityElectricMachine {
    public TileEntityPump validPump;

    public TileEntityCompressor() {
        super(3, 2, 400, 32);
    }

    public static void init() {
        TileEntityCompressor.addRecipe(Ic2Items.plantBall, Ic2Items.compressedPlantBall, 0.2f);
        TileEntityCompressor.addRecipe(Ic2Items.hydratedCoalDust, Ic2Items.hydratedCoalClump, 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack(Blocks.field_150424_aL, 3), new ItemStack(Blocks.field_150385_bj), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150322_A), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack(Items.field_151126_ay), new ItemStack(Blocks.field_150432_aD), 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.waterCell, new ItemStack(Items.field_151126_ay), 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.mixedMetalIngot, Ic2Items.advancedAlloy, 0.3f);
        TileEntityCompressor.addRecipe(Ic2Items.carbonMesh, Ic2Items.carbonPlate, 0.3f);
        TileEntityCompressor.addRecipe(Ic2Items.coalBall, Ic2Items.compressedCoalBall, 0.2f);
        TileEntityCompressor.addRecipe(Ic2Items.coalChunk, Ic2Items.industrialDiamond, 1.0f);
        TileEntityCompressor.addRecipe(Ic2Items.constructionFoam, Ic2Items.constructionFoamPellet, 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.cell, Ic2Items.airCell, 0.1f);
        TileEntityCompressor.addRecipe(StackUtil.copyWithSize(Ic2Items.scrapMetal, 8), Ic2Items.scrapMetalChunk, 0.5f);
        TileEntityCompressor.addRecipe(new ItemStack(Items.field_151065_br, 5), new ItemStack(Items.field_151072_bj), 1.0f);
        TileEntityCompressor.addRecipe(Ic2Items.rawObsidianBlade, Ic2Items.obsidianBlade, 0.3f);
        TileEntityCompressor.addRecipe(StackUtil.copyWithSize(Ic2Items.cropmatron, 3), Ic2Items.cropHarvester);
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input), output);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input, stacksize), output);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output) {
        TileEntityCompressor.addRecipe(new RecipeInputOreDict(input, stacksize), output);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input), output, exp);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, float exp) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input, stacksize), output, exp);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, float exp) {
        TileEntityCompressor.addRecipe(new RecipeInputOreDict(input, stacksize), output, exp);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, float exp) {
        IMachineRecipeManager manager = Recipes.compressor;
        if (manager != null && manager instanceof IMachineRecipeManagerExp) {
            ((IMachineRecipeManagerExp)manager).addRecipe(input, null, exp, output);
        } else {
            TileEntityCompressor.addRecipe(input, output);
        }
    }

    public static void addRecipe(IRecipeInput input, ItemStack output) {
        Recipes.compressor.addRecipe(input, null, output);
    }

    @Override
    public RecipeOutput getResultFor(ItemStack itemStack, boolean adjustInput) {
        RecipeOutput output;
        RecipeOutput recipeOutput = output = itemStack == null ? null : Recipes.compressor.getOutputFor(itemStack, adjustInput);
        if (output == null) {
            if (this.getValidPump() != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("Pump", true);
                return new RecipeOutput(nbt, new ItemStack(Items.field_151126_ay));
            }
            return null;
        }
        return output;
    }

    @Override
    public boolean canWorkWithoutItems() {
        return true;
    }

    @Override
    public void operateOnce(RecipeOutput result, List<ItemStack> items) {
        super.operateOnce(result, items);
        ItemStack item = result.items.get(0);
        if (item != null && item.func_77973_b() == Items.field_151126_ay && result.metadata != null && result.metadata.func_74767_n("Pump")) {
            TileEntityPump pump = this.getValidPump();
            if (pump == null) {
                return;
            }
            pump.pumpCharge = 0;
            this.getNetwork().updateTileGuiField(pump, "pumpCharge");
            this.field_145850_b.func_147468_f(pump.field_145851_c, pump.field_145848_d - 1, pump.field_145849_e);
        }
    }

    public TileEntityPump getValidPump() {
        TileEntityPump pump;
        if (this.validPump != null && !this.validPump.func_145837_r() && this.validPump.isPumpReady() && this.validPump.isWaterBelow()) {
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        return null;
    }

    @Override
    public String func_145825_b() {
        return "Compressor";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiCompressor";
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/CompressorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        for (IRecipeInput input : Recipes.compressor.getRecipes().keySet()) {
            if (!input.matches(par1)) continue;
            return super.isValidInput(par1);
        }
        return false;
    }

    @Override
    public IMachineRecipeManager getRecipeList() {
        return Recipes.compressor;
    }
}

