/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.BlockCrop;
import ic2.core.block.inventory.IItemTransporter;
import ic2.core.block.inventory.TransporterManager;
import ic2.core.block.machine.container.ContainerCropHarvester;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.util.AabbUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCropHarvester
extends TileEntityElecMachine
implements IHasGui {
    public static AabbUtil.IBlockFilter filter = new CropFilter();
    public CustomInv inv = new CustomInv(this, 5);
    LinkedList<ItemStack> items = new LinkedList();
    LinkedList<ChunkPosition> todoList = new LinkedList();
    public int nextDelay = 10;
    public int delay = 0;
    public int radius = 1;
    IItemTransporter transporter = null;

    public TileEntityCropHarvester() {
        super(9, -1, 50000, 128);
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public String func_145825_b() {
        return "CropHarvester";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerCropHarvester(p0.field_71071_by, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiCropHarvester";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        this.todoList.clear();
        this.items.clear();
        NBTTagList list = nbt.func_150295_c("WorkList", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            int[] pos = list.func_150306_c(i);
            this.todoList.add(new ChunkPosition(pos[0], pos[1], pos[2]));
        }
        list = nbt.func_150295_c("ItemList", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
            if (stack == null) continue;
            this.items.add(stack);
        }
        this.inv.readFromNBT(nbt.func_74775_l("Upgrades"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (ChunkPosition pos : this.todoList) {
            list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.field_151329_a, pos.field_151327_b, pos.field_151328_c}));
        }
        nbt.func_74782_a("WorkList", (NBTBase)list);
        list = new NBTTagList();
        for (ItemStack item : this.items) {
            list.func_74742_a((NBTBase)item.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74782_a("ItemList", (NBTBase)list);
        nbt.func_74782_a("Upgrades", (NBTBase)this.inv.writeToNBT());
    }

    @Override
    public void func_145845_h() {
        this.addItemsToInventory();
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (!this.hasEnergy(100)) {
            this.delay += 20;
            return;
        }
        if (this.items.size() > 0) {
            this.delay += 20;
            return;
        }
        this.delay += this.nextDelay;
        if (this.todoList.isEmpty()) {
            this.todoList.addAll(AabbUtil.getTargets(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.radius, filter, ForgeDirection.VALID_DIRECTIONS));
            this.useEnergy(10);
        }
        if (this.todoList.isEmpty()) {
            this.delay += 120;
            return;
        }
        ChunkPosition target = this.todoList.remove();
        if (this.todoList.isEmpty()) {
            this.delay += 120;
        }
        TileEntity tile = this.func_145831_w().func_147438_o(target.field_151329_a, target.field_151327_b, target.field_151328_c);
        this.useEnergy(1);
        if (tile instanceof ICropTile) {
            this.delay += this.nextDelay;
            ICropTile crop = (ICropTile)tile;
            CropCard card = crop.getCrop();
            if (card == null) {
                return;
            }
            if (card.canBeHarvested(crop) && crop.getSize() >= card.getOptimalHavestSize(crop)) {
                ItemStack[] array = crop.harvest_automated(true);
                for (int i = 0; i < array.length; ++i) {
                    ItemStack stack = array[i];
                    if (stack == null) continue;
                    this.items.add(stack);
                }
                this.addItemsToInventory();
                this.useEnergy(20);
            }
        }
    }

    public void addItemsToInventory() {
        if (this.items.isEmpty()) {
            return;
        }
        if (this.transporter == null) {
            this.transporter = TransporterManager.manager.getTransporter(this);
            return;
        }
        ArrayList<ItemStack> left = new ArrayList<ItemStack>();
        while (this.items.size() > 0) {
            ItemStack added;
            ItemStack stack = this.items.remove();
            if (stack == null || (added = this.transporter.addItem(stack.func_77946_l(), ForgeDirection.UNKNOWN, true)) == null) continue;
            stack.field_77994_a -= added.field_77994_a;
            if (stack.field_77994_a <= 0) continue;
            left.add(stack);
        }
        this.items.addAll(left);
    }

    public void setOverclockerUpgrade() {
        int overclocker = 0;
        int newRange = 1;
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack == null) continue;
            if (StackUtil.isStackEqual(stack, Ic2Items.overclockerUpgrade)) {
                ++overclocker;
                continue;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.padUpgradeBasicFieldUpgrade)) {
                ++newRange;
                continue;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.padUpgradeFieldUpgrade)) {
                newRange += 2;
                continue;
            }
            if (!StackUtil.isStackEqual(stack, Ic2Items.padUpgradeAdvFieldUpgrade)) continue;
            newRange += 3;
        }
        if (newRange > 5) {
            newRange = 5;
        }
        if (newRange < this.radius) {
            this.todoList.clear();
        }
        this.radius = newRange;
        if (overclocker < 1) {
            this.nextDelay = 20;
        } else if (overclocker < 2) {
            this.nextDelay = 10;
        } else if (overclocker < 3) {
            this.nextDelay = 5;
        } else if (overclocker < 4) {
            this.nextDelay = 2;
        } else if (overclocker >= 4) {
            this.nextDelay = 0;
        }
    }

    public static class CropFilter
    implements AabbUtil.IBlockFilter {
        @Override
        public boolean isBlockValid(Block block, int meta) {
            return block instanceof BlockCrop;
        }

        @Override
        public boolean isBlockValid(World world, int x, int y, int z) {
            return world.func_147439_a(x, y, z) instanceof BlockCrop;
        }
    }

    public static class CustomInv
    implements IInventory {
        TileEntityCropHarvester harvest;
        ItemStack[] array;
        int size;

        public CustomInv(TileEntityCropHarvester tile, int slots) {
            this.size = slots;
            this.harvest = tile;
            this.array = new ItemStack[slots];
        }

        public int func_70302_i_() {
            return this.size;
        }

        public ItemStack func_70301_a(int slot) {
            return this.array[slot];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            if (this.array[slot] != null) {
                if (this.array[slot].field_77994_a > amount) {
                    return this.array[slot].func_77979_a(amount);
                }
                return this.func_70304_b(slot);
            }
            return null;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack result = this.array[slot];
            this.array[slot] = null;
            return result;
        }

        public void func_70299_a(int slot, ItemStack item) {
            this.array[slot] = item;
        }

        public String func_145825_b() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
            this.harvest.setOverclockerUpgrade();
        }

        public boolean func_70300_a(EntityPlayer p_70300_1_) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
            return true;
        }

        public void readFromNBT(NBTTagCompound nbttagcompound) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
            this.array = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound2.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.array.length) continue;
                this.array[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
            }
        }

        public NBTTagCompound writeToNBT() {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == null) continue;
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74774_a("Slot", (byte)i);
                this.array[i].func_77955_b(nbttagcompound2);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
            return nbttagcompound;
        }
    }
}

