/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.container.ContainerCropScanner;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.item.ItemCropSeed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class TileEntityCropScanner
extends TileEntityElecMachine
implements IHasGui {
    public int[] progresses = new int[]{1, 9, 90, 900};
    public int progress;

    public TileEntityCropScanner() {
        super(3, 0, 10000, 32, 1);
        this.addGuiFields("progress");
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{1, 2};
    }

    @Override
    public String func_145825_b() {
        return "Crop Scanner";
    }

    public int getMaxProgress() {
        if (this.inventory[1] == null) {
            return 0;
        }
        byte scanLevel = ItemCropSeed.getScannedFromStack(this.inventory[1]);
        if (scanLevel <= -1 || scanLevel >= 4) {
            return 0;
        }
        return this.progresses[scanLevel];
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 1 && itemstack != null && itemstack.func_77973_b() instanceof ItemCropSeed;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.inventory[1] == null || !(this.inventory[1].func_77973_b() instanceof ItemCropSeed) || this.inventory[2] != null) {
            if (this.progress > 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField(this, "progress");
            }
            return;
        }
        byte scanLevel = ItemCropSeed.getScannedFromStack(this.inventory[1]);
        if (scanLevel >= 4 || scanLevel == -1) {
            if (this.progress > 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField(this, "progress");
            }
            return;
        }
        int maxProgress = this.progresses[scanLevel];
        ++this.progress;
        if (this.progress >= maxProgress) {
            this.progress = 0;
            ItemStack item = this.inventory[1].func_77946_l();
            this.inventory[1] = null;
            ItemCropSeed.incrementScannedOfStack(item);
            scanLevel = ItemCropSeed.getScannedFromStack(item);
            int newSlot = scanLevel >= 4 || scanLevel == -1 ? 2 : 1;
            this.inventory[newSlot] = item.func_77946_l();
        }
        this.getNetwork().updateTileGuiField(this, "progress");
    }

    public float getChargeLevel() {
        return (float)this.energy / (float)this.maxEnergy;
    }

    public float getProgress() {
        return (float)this.progress / (float)this.getMaxProgress();
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerCropScanner(p0.field_71071_by, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiCropScanner";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public int getEnergyUsage() {
        return 10;
    }
}

