/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityElecMachine
extends TileEntityMachine
implements IEnergySink,
IEnergyContainer {
    public int energy = 0;
    public int fuelslot;
    public int maxEnergy;
    public int maxInput;
    public int tier = 0;
    public int baseTier;
    public boolean addedToEnergyNet = false;
    public boolean redstone;

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.baseTier = this.tier = EnergyNet.instance.getTierFromPower(maxinput);
        this.addGuiFields("energy", "maxEnergy");
    }

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput, int tier) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = tier;
        this.baseTier = tier;
        this.addGuiFields("energy", "maxEnergy");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean provideEnergy() {
        boolean ret = false;
        if (this.inventory[this.fuelslot] == null) {
            return false;
        }
        Item item = this.inventory[this.fuelslot].func_77973_b();
        if (item instanceof IElectricItem) {
            if (!((IElectricItem)item).canProvideEnergy(this.inventory[this.fuelslot])) {
                return false;
            }
            int transfer = (int)ElectricItem.manager.discharge(this.inventory[this.fuelslot], this.maxEnergy - this.energy, this.tier, false, true, false);
            this.energy += transfer;
            if (transfer > 0) {
                this.getNetwork().updateTileGuiField(this, "energy");
            }
            return ret || transfer > 0;
        }
        if (item == Items.field_151137_ax) {
            this.energy += this.maxEnergy;
            ItemStack itemStack = this.inventory[this.fuelslot];
            --itemStack.field_77994_a;
            if (this.inventory[this.fuelslot].field_77994_a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            this.getNetwork().updateTileGuiField(this, "energy");
            return true;
        }
        if (item == Ic2Items.suBattery.func_77973_b()) {
            this.energy += 1000;
            ItemStack itemStack2 = this.inventory[this.fuelslot];
            --itemStack2.field_77994_a;
            if (this.inventory[this.fuelslot].field_77994_a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            this.getNetwork().updateTileGuiField(this, "energy");
            return true;
        }
        return ret;
    }

    public void useEnergy(int amount) {
        this.energy -= amount;
        if (this.energy < 0) {
            this.energy = 0;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    public boolean hasEnergy(int amount) {
        return this.energy >= amount;
    }

    public void setMaxEnergy(int amount) {
        this.maxEnergy = amount;
        this.getNetwork().updateTileGuiField(this, "maxEnergy");
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount > (double)this.maxInput) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        IC2.network.get().updateTileGuiField(this, "energy");
        return re;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public void handleRedstone() {
        this.redstone = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isRedstonePowered() {
        return this.redstone;
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return this.maxInput;
    }
}

