/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.item.IElectricTool;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.container.ContainerElectricEnchanter;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityElectricEnchanter
extends TileEntityElecMachine
implements INetworkClientTileEntityEventListener,
IHasGui {
    public int progress;
    public int exp;
    public int neededExp;
    public final int anvilTime = 100;
    public final int enchantTime = 1000;
    public int mode = 0;
    public boolean isDefined = false;
    public boolean started = false;
    public float serverProgress = 0.0f;
    public float serverChargeLevel = 0.0f;

    public TileEntityElectricEnchanter() {
        super(6, 0, 1000000, 512, 3);
        this.addGuiFields("progress", "exp", "neededExp");
    }

    public int[] func_94128_d(int side) {
        return new int[]{4, 5};
    }

    @Override
    public String func_145825_b() {
        return "Electric Enchanter";
    }

    @Override
    public void func_145845_h() {
        boolean dirty = false;
        if (this.energy < this.maxEnergy) {
            dirty = this.provideEnergy();
        }
        if (this.inventory[5] != null) {
            this.setActive(false);
            return;
        }
        if (!this.isDefined && this.isExtrasValid() && this.isItemValidToEnchant(this.inventory[4])) {
            this.calculate();
        }
        if (!this.isDefined) {
            this.setActive(false);
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.updateCost();
        }
        if (this.neededExp <= 0) {
            this.setActive(false);
            return;
        }
        if (!this.started) {
            this.setActive(false);
            return;
        }
        if (this.isItemValidToEnchant(this.inventory[4]) && this.isExtrasValid()) {
            if (this.energy >= 500) {
                this.setActive(true);
                ++this.progress;
                this.useEnergy(500);
                if (this.progress == this.getProgressTime() - 1) {
                    this.updateCost();
                }
                if (this.progress >= this.getProgressTime()) {
                    switch (this.mode) {
                        case 0: {
                            this.enchantItem();
                            break;
                        }
                        case 1: {
                            this.anvilItem();
                        }
                    }
                    this.exp -= this.neededExp;
                    this.neededExp = 0;
                    this.isDefined = false;
                    this.started = false;
                    this.progress = 0;
                    dirty = true;
                    this.getNetwork().updateTileGuiField(this, "neededExp");
                    this.getNetwork().updateTileGuiField(this, "exp");
                }
                this.getNetwork().updateTileGuiField(this, "progress");
            } else {
                this.setActive(false);
            }
        } else {
            this.progress = 0;
            this.started = false;
            this.setActive(false);
            this.getNetwork().updateTileGuiField(this, "neededExp");
            this.getNetwork().updateTileGuiField(this, "progress");
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public void updateCost() {
        int newExp;
        int n = newExp = this.mode == 0 ? this.getBookCount() : this.getAnvilCost();
        if (newExp != this.neededExp) {
            this.progress = 0;
            this.started = false;
        }
        this.neededExp = newExp;
        this.getNetwork().updateTileGuiField(this, "neededExp");
        this.getNetwork().updateTileGuiField(this, "progress");
    }

    public void enchantItem() {
        boolean flag;
        int count = 0;
        for (int i = 1; i < 4; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null || item.func_77973_b() != Items.field_151122_aG && item.func_77973_b() != Items.field_151134_bR) continue;
            ++count;
        }
        HashMap<Integer, Integer> enchs = new HashMap<Integer, Integer>();
        List<EnchantmentData> data = this.getPossibleItemEnchantments(count);
        data.addAll(this.getItemEnchantments());
        for (EnchantmentData key : data) {
            int level;
            int enchID = key.field_76302_b.field_77352_x;
            if (enchs.containsKey(enchID) && (level = ((Integer)enchs.get(enchID)).intValue()) >= key.field_76303_c) continue;
            enchs.put(enchID, key.field_76303_c);
        }
        boolean bl = flag = this.inventory[4].func_77973_b() == Items.field_151122_aG;
        if (flag) {
            ItemStack item = new ItemStack((Item)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a(enchs, (ItemStack)item);
            this.inventory[5] = item;
            --this.inventory[4].field_77994_a;
            if (this.inventory[4].field_77994_a <= 0) {
                this.inventory[4] = null;
            }
        } else {
            EnchantmentHelper.func_82782_a(enchs, (ItemStack)this.inventory[4]);
            this.inventory[5] = this.inventory[4];
            this.inventory[4] = null;
        }
        for (int i = 1; i < 4; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null) continue;
            --item.field_77994_a;
            if (item.field_77994_a > 0) continue;
            this.inventory[i] = null;
        }
    }

    public void anvilItem() {
        HashMap<Integer, Integer> ench = new HashMap<Integer, Integer>();
        ench.putAll(EnchantmentHelper.func_82781_a((ItemStack)this.inventory[4]));
        List<EnchantmentData> data = this.getItemEnchantments();
        for (EnchantmentData key : data) {
            if (this.inventory[4].func_77973_b() instanceof IElectricTool && !this.validEnchantment(((IElectricTool)this.inventory[4].func_77973_b()).getType(this.inventory[4]), key.field_76302_b, this.inventory[4])) continue;
            int id = key.field_76302_b.field_77352_x;
            if (ench.containsKey(id)) {
                if (!this.combineable(ench.keySet(), id)) continue;
                int lvl = (Integer)ench.get(id);
                if (lvl < key.field_76303_c) {
                    ench.put(id, key.field_76303_c);
                    continue;
                }
                if (lvl != key.field_76303_c || key.field_76302_b.func_77325_b() <= lvl) continue;
                ench.put(id, key.field_76303_c + 1);
                continue;
            }
            ench.put(id, key.field_76303_c);
        }
        EnchantmentHelper.func_82782_a(ench, (ItemStack)this.inventory[4]);
        this.inventory[4].func_82841_c(this.inventory[4].func_82838_A() + this.field_145850_b.field_73012_v.nextInt(ench.size()));
        this.inventory[5] = this.inventory[4];
        this.inventory[4] = null;
        for (int i = 1; i < 4; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null) continue;
            --item.field_77994_a;
            if (item.field_77994_a > 0) continue;
            this.inventory[i] = null;
        }
    }

    public boolean combineable(Set<Integer> intigrated, int toAdd) {
        boolean result = true;
        Enchantment requested = Enchantment.field_77331_b[toAdd];
        if (requested == null) {
            return false;
        }
        for (Integer toCheck : intigrated) {
            Enchantment target = Enchantment.field_77331_b[toCheck];
            if (target == requested || target.func_77326_a(requested) || requested.func_77326_a(target)) continue;
            result = false;
            break;
        }
        return result;
    }

    public List<EnchantmentData> getPossibleItemEnchantments(int max) {
        float f;
        HashMap<Integer, EnchantmentData> data = new HashMap<Integer, EnchantmentData>();
        Enchantment[] ench = Enchantment.field_77331_b;
        int j = ench.length;
        int ability = this.inventory[4].func_77973_b().getItemEnchantability(this.inventory[4]);
        ability /= 2;
        int combo = (ability = 1 + this.field_145850_b.field_73012_v.nextInt((ability >> 1) + 1) + this.field_145850_b.field_73012_v.nextInt((ability >> 1) + 1)) + this.neededExp;
        int needed = (int)((float)combo * (1.0f + (f = (this.field_145850_b.field_73012_v.nextFloat() + this.field_145850_b.field_73012_v.nextFloat() - 1.0f) * 0.15f)) + 0.5f);
        if (needed < 1) {
            needed = 1;
        }
        for (int k = 0; k < j; ++k) {
            Enchantment enchantment = ench[k];
            if (enchantment == null || (!(this.inventory[4].func_77973_b() instanceof IElectricTool) || !this.validEnchantment(((IElectricTool)this.inventory[4].func_77973_b()).getType(this.inventory[4]), enchantment, this.inventory[4])) && !enchantment.canApplyAtEnchantingTable(this.inventory[4])) continue;
            for (int l = enchantment.func_77319_d(); l <= enchantment.func_77325_b(); ++l) {
                if (needed < enchantment.func_77321_a(l) || needed > enchantment.func_77317_b(l)) continue;
                data.put(enchantment.field_77352_x, new EnchantmentData(enchantment, l));
            }
        }
        ArrayList<EnchantmentData> result = new ArrayList<EnchantmentData>();
        ArrayList posseblities = new ArrayList();
        posseblities.addAll(data.values());
        Collections.shuffle(posseblities);
        for (EnchantmentData current : posseblities) {
            boolean can = this.combineable(result, current);
            if (!can) continue;
            result.add(current);
        }
        Collections.shuffle(result);
        return result.subList(0, Math.min(max, result.size()));
    }

    public boolean combineable(List<EnchantmentData> data, EnchantmentData toAdd) {
        boolean result = true;
        for (EnchantmentData ench : data) {
            if (ench.field_76302_b == toAdd.field_76302_b || ench.field_76302_b.func_77326_a(toAdd.field_76302_b) || toAdd.field_76302_b.func_77326_a(ench.field_76302_b)) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean validEnchantment(EnumEnchantmentType type, Enchantment ench, ItemStack item) {
        IElectricTool tool;
        block9: {
            block8: {
                tool = (IElectricTool)item.func_77973_b();
                if (tool.isExcluded(item, ench)) {
                    return false;
                }
                if (type == EnumEnchantmentType.all) {
                    return true;
                }
                if (type == EnumEnchantmentType.breakable && item.func_77984_f()) {
                    return true;
                }
                if (ench.field_77351_y == type) {
                    return true;
                }
                if (type == EnumEnchantmentType.armor_feet) break block8;
                if (type == EnumEnchantmentType.armor_head) break block8;
                if (type == EnumEnchantmentType.armor_legs) break block8;
                if (type != EnumEnchantmentType.armor_torso) break block9;
            }
            if (ench.field_77351_y == EnumEnchantmentType.armor) {
                return true;
            }
        }
        return tool.isSpecialSupport(item, ench);
    }

    public List<EnchantmentData> getItemEnchantments() {
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
        for (int i = 1; i < 4; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null || item.func_77973_b() != Items.field_151134_bR) continue;
            Map map = EnchantmentHelper.func_82781_a((ItemStack)item);
            for (Map.Entry entry : map.entrySet()) {
                list.add(new EnchantmentData(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue()));
            }
        }
        return list;
    }

    public void calculate() {
        this.isDefined = true;
        this.mode = this.isItemEnchanted(this.inventory[4]) ? 1 : 0;
        int n = this.neededExp = this.mode == 0 ? this.getBookCount() : this.getAnvilCost();
        if (this.mode == 1) {
            this.validateCombo();
        }
        this.getNetwork().updateTileGuiField(this, "neededExp");
    }

    public void validateCombo() {
        List<EnchantmentData> itemEnchantments = this.getEnchantments(this.inventory[4]);
        for (EnchantmentData data : this.getItemEnchantments()) {
            if (this.combineable(itemEnchantments, data)) continue;
            this.neededExp = 0;
            break;
        }
    }

    public List<EnchantmentData> getEnchantments(ItemStack par1) {
        if (par1 == null) {
            return new ArrayList<EnchantmentData>();
        }
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)par1);
        for (Map.Entry entry : map.entrySet()) {
            list.add(new EnchantmentData(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue()));
        }
        return list;
    }

    public int getProgressTime() {
        return this.mode == 0 ? 1000 : 100;
    }

    public int getAnvilCost() {
        if (this.inventory[4] == null) {
            return 0;
        }
        int cost = this.getEnchantmentCount(this.inventory[4]);
        int extra = 0;
        for (int i = 1; i < 4; ++i) {
            if (this.inventory[i] == null) continue;
            extra += this.getEnchantmentCount(this.inventory[i]);
        }
        if (extra <= 0) {
            return 0;
        }
        return cost + extra;
    }

    public int getBookCount() {
        int amount = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    amount += (int)this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z).getEnchantPowerBonus(this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                }
            }
        }
        return Math.min(amount, 30);
    }

    public boolean isItemEnchanted(ItemStack item) {
        return item.func_77948_v();
    }

    public int getEnchantmentCount(ItemStack item) {
        if (item.func_77973_b() == Items.field_151134_bR) {
            return Items.field_151134_bR.func_92110_g(item).func_74745_c() + item.func_82838_A();
        }
        return (!item.func_77942_o() ? 0 : item.func_77986_q().func_74745_c()) + item.func_82838_A();
    }

    public boolean isItemValidToEnchant(ItemStack item) {
        return item != null && (item.func_77973_b() == Items.field_151122_aG || item.func_77973_b().func_77616_k(item) || item.func_77973_b() instanceof IElectricTool);
    }

    public boolean isExtrasValid() {
        int count = 0;
        for (int i = 1; i < 4; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null) continue;
            if (item.func_77973_b() != Items.field_151122_aG && item.func_77973_b() != Items.field_151134_bR) {
                return false;
            }
            ++count;
        }
        return count > 0;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 0) {
            if (player.field_71075_bZ.field_75098_d) {
                this.exp = this.neededExp;
                this.getNetwork().updateTileGuiField(this, "exp");
                return;
            }
            int needed = this.neededExp - this.exp;
            if (player.field_71068_ca >= needed) {
                this.exp = this.neededExp;
                player.func_82242_a(-needed);
                player.field_71067_cb = this.getXP(player);
                player.field_71106_cc = (float)(player.field_71067_cb - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
            } else {
                this.exp += player.field_71068_ca;
                player.field_71068_ca = 0;
                player.field_71067_cb = this.getXP(player);
                player.field_71106_cc = (float)(player.field_71067_cb - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
            }
            this.getNetwork().updateTileGuiField(this, "exp");
        } else if (event == 1 && !this.started && this.isDefined) {
            this.started = true;
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerElectricEnchanter(this, p0.field_71071_by);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiElectricEnchanter";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    private int getXP(EntityPlayer player) {
        return (int)((float)this.getXPForLvl(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 15) {
            return level * 17;
        }
        if (level <= 30) {
            return (int)((double)(level * level) * 1.5 - 29.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 3.5 - 151.5 * (double)level + 2220.0);
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxEnergy;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public float getProgress() {
        float ret = (float)this.progress / (float)this.getProgressTime();
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.exp = nbt.func_74762_e("Exp");
        this.neededExp = nbt.func_74762_e("Needed");
        this.progress = nbt.func_74762_e("Progress");
        this.mode = nbt.func_74762_e("Mode");
        this.isDefined = nbt.func_74767_n("Defined");
        this.started = nbt.func_74767_n("Started");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Exp", this.exp);
        nbt.func_74768_a("Needed", this.neededExp);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("Mode", this.mode);
        nbt.func_74757_a("Defined", this.isDefined);
        nbt.func_74757_a("Started", this.started);
    }

    @Override
    public int getEnergyUsage() {
        return 500;
    }
}

