/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManagerExp;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.util.StackUtil;
import java.util.AbstractMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class TileEntityExtractor
extends TileEntityElectricMachine {
    public static List<AbstractMap.SimpleEntry<ItemStack, ItemStack>> recipes = new Vector<AbstractMap.SimpleEntry<ItemStack, ItemStack>>();

    public TileEntityExtractor() {
        super(3, 2, 400, 32);
    }

    public static void init() {
        if (Ic2Items.rubberSapling != null) {
            TileEntityExtractor.addRecipe(Ic2Items.rubberSapling, Ic2Items.rubber);
        }
        TileEntityExtractor.addRecipe(Ic2Items.resin, StackUtil.copyWithSize(Ic2Items.rubber, 3), 0.2f);
        TileEntityExtractor.addRecipe(Ic2Items.bioCell, Ic2Items.biofuelCell, 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.hydratedCoalCell, Ic2Items.coalfuelCell, 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.waterCell, Ic2Items.hydratingCell, 0.1f);
        TileEntityExtractor.addRecipe("itemRawRubber", 1, StackUtil.copyWithSize(Ic2Items.rubber, 3), 0.2f);
        TileEntityExtractor.addRecipe("woodRubber", 1, Ic2Items.rubber, 0.2f);
        TileEntityExtractor.addRecipe(new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h, 3), 0.3f);
        TileEntityExtractor.addRecipe(new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 10, 4), 0.5f);
        TileEntityExtractor.addRecipe(new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i, 3), 1.0f);
        TileEntityExtractor.addRecipe(new ItemStack(Blocks.field_150412_bA), new ItemStack(Items.field_151166_bC, 3), 1.0f);
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input), output);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input, stacksize), output);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output) {
        TileEntityExtractor.addRecipe(new RecipeInputOreDict(input, stacksize), output);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input), output, exp);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, float exp) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input, stacksize), output, exp);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, float exp) {
        TileEntityExtractor.addRecipe(new RecipeInputOreDict(input, stacksize), output, exp);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, float exp) {
        IMachineRecipeManager manager = Recipes.extractor;
        if (manager != null && manager instanceof IMachineRecipeManagerExp) {
            ((IMachineRecipeManagerExp)manager).addRecipe(input, null, exp, output);
        } else {
            TileEntityExtractor.addRecipe(input, output);
        }
    }

    public static void addRecipe(IRecipeInput input, ItemStack output) {
        Recipes.extractor.addRecipe(input, null, output);
    }

    @Override
    public RecipeOutput getResultFor(ItemStack itemStack, boolean adjustInput) {
        return Recipes.extractor.getOutputFor(itemStack, adjustInput);
    }

    @Override
    public String func_145825_b() {
        return "Extractor";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiExtractor";
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/ExtractorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        for (IRecipeInput input : Recipes.extractor.getRecipes().keySet()) {
            if (!input.matches(par1)) continue;
            return super.isValidInput(par1);
        }
        return false;
    }

    @Override
    public IMachineRecipeManager getRecipeList() {
        return Recipes.extractor;
    }
}

