/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.container.ContainerMatter;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMatter
extends TileEntityElecMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(32);
    public int scrap = 0;
    private int StateIdle = 0;
    private int StateRunning = 1;
    private int StateRunningScrap = 2;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;

    public TileEntityMatter() {
        super(2, 0, 1100000, 512);
        this.addNetworkFields("state");
        this.addGuiFields("scrap");
    }

    public static void init() {
        TileEntityMatter.addAmplifier(Ic2Items.scrap, 5000);
        TileEntityMatter.addAmplifier(Ic2Items.scrapBox, 45000);
        TileEntityMatter.addAmplifier(Ic2Items.scrapMetal, 100000);
    }

    public static void addAmplifier(ItemStack input, int amplification) {
        TileEntityMatter.addAmplifier(new RecipeInputItemStack(input), amplification);
    }

    public static void addAmplifier(ItemStack input, int amount, int amplification) {
        TileEntityMatter.addAmplifier(new RecipeInputItemStack(input, amount), amplification);
    }

    public static void addAmplifier(String input, int amount, int amplification) {
        TileEntityMatter.addAmplifier(new RecipeInputOreDict(input, amount), amplification);
    }

    public static void addAmplifier(IRecipeInput input, int amplification) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("amplification", amplification);
        Recipes.matterAmplifier.addRecipe(input, metadata, new ItemStack[0]);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.func_74762_e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.func_74765_d("scrap");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
    }

    @Override
    public String func_145825_b() {
        return "Mass Fabricator";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.handleRedstone();
        if (this.isRedstonePowered() || this.energy <= 0) {
            this.setState(0);
            this.setActive(false);
        } else {
            RecipeOutput output;
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            boolean needsInvUpdate = false;
            if (this.scrap < 1000 && this.inventory[0] != null && (output = Recipes.matterAmplifier.getOutputFor(this.inventory[0], false)) != null) {
                if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
                    this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                } else {
                    ItemStack itemStack = this.inventory[0];
                    --itemStack.field_77994_a;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                }
                this.scrap += output.metadata.func_74762_e("amplification");
                this.getNetwork().updateTileGuiField(this, "scrap");
            }
            if (this.energy >= 1000000) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (needsInvUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        if (this.inventory[1] == null) {
            this.inventory[1] = Ic2Items.matter.func_77946_l();
            this.energy -= 1000000;
            this.getNetwork().updateTileGuiField(this, "energy");
            return true;
        }
        if (!this.inventory[1].func_77969_a(Ic2Items.matter) || this.inventory[1].field_77994_a >= this.inventory[1].func_77976_d()) {
            return false;
        }
        this.energy -= 1000000;
        this.getNetwork().updateTileGuiField(this, "energy");
        ItemStack itemStack = this.inventory[1];
        ++itemStack.field_77994_a;
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        if (this.isRedstonePowered()) {
            return 0.0;
        }
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volts) {
        if (amount > 512.0) {
            return 0.0;
        }
        int bonus = (int)amount;
        if (bonus > this.scrap) {
            bonus = this.scrap;
        }
        this.scrap -= bonus;
        this.energy = (int)((double)this.energy + (amount + (double)(5 * bonus)));
        this.getNetwork().updateTileGuiField(this, "energy");
        this.getNetwork().updateTileGuiField(this, "scrap");
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return 3;
    }

    public String getProgressAsString() {
        int p = this.energy / 10000;
        if (p > 100) {
            p = 100;
        }
        return "" + p + "%";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMatter(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiMatter";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            this.getNetwork().updateTileEntityField(this, "state");
        }
        this.prevState = state;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{0};
        }
        if (var1 == 1) {
            return new int[]{1};
        }
        return new int[0];
    }

    @Override
    public float getWrenchDropRate() {
        return 0.7f;
    }

    @Override
    public int getEnergyUsage() {
        return this.maxEnergy;
    }
}

