/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import ic2.api.item.IItemReactorPlanStorage;
import ic2.api.network.INetworkFieldData;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.container.ContainerReactorPlanner;
import ic2.core.block.machine.logic.ReactorLogicBase;
import ic2.core.block.machine.logic.ReactorPlannerInv;
import ic2.core.block.machine.logic.TickingReactorLogic;
import ic2.core.block.machine.logic.TickingSteamReactorLogic;
import ic2.core.block.machine.logic.encoder.EncoderRegistry;
import ic2.core.block.machine.logic.encoder.IEncoder;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.network.internal.IPayloadReceiver;
import ic2.core.network.internal.PayloadPacket;
import ic2.core.network.packets.server.ReactorPlannerEncoderPacket;
import ic2.core.util.Tuple;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;

public class TileEntityReactorPlanner
extends TileEntityElecMachine
implements IHasGui,
INetworkTileEntityEventListener,
IPayloadReceiver {
    public ReactorPlannerInv components = new ReactorPlannerInv(this);
    public UserSettings settings = new UserSettings();
    public ReactorBackup backup = new ReactorBackup();
    public ReactorLogicBase reactor = new TickingReactorLogic(this);
    public ReactorLogicBase.IReactorPrediction reactorPrediction = new TickingReactorLogic.ReactorPrediction();
    public ReactorLogicBase steamReactor = new TickingSteamReactorLogic(this);
    public ReactorLogicBase.IReactorPrediction steamReactorPrediction = new TickingSteamReactorLogic.SteamReactorPrediction();
    public int selectedSlot = 0;
    public int stackSize = 1;
    public int selectedView = 2;
    public String setupName = "";
    public int reactorSize = 6;
    public boolean isSteamReactor = false;

    public TileEntityReactorPlanner() {
        super(0, -1, 100000, 128);
        this.addGuiFields("isSteamReactor", "reactorSize", "setupName", "selectedView", "stackSize", "selectedSlot", "steamReactorPrediction", "steamReactor", "reactorPrediction", "reactor", "backup", "settings", "components");
    }

    public ReactorLogicBase getReactorLogic() {
        return this.isSteamReactor ? this.steamReactor : this.reactor;
    }

    public ReactorLogicBase.IReactorPrediction getPrediction() {
        return this.isSteamReactor ? this.steamReactorPrediction : this.reactorPrediction;
    }

    public UserSettings getUserSettings() {
        return this.settings;
    }

    @Override
    public void func_145845_h() {
        if (!this.getActive()) {
            return;
        }
        if (!this.hasEnergy(10)) {
            return;
        }
        this.useEnergy(10);
        ReactorLogicBase base = this.getReactorLogic();
        if (base.isFinished()) {
            this.setActive(false);
            return;
        }
        UserSettings setting = this.getUserSettings();
        if (base.isValid() && !base.didReactorBreak()) {
            for (int i = 0; i < setting.ticksPerTick && !base.isFinished() && !base.didReactorBreak(); ++i) {
                base.onTick();
                if (!base.isFinished()) continue;
                base.onFinished();
                this.setActive(false);
            }
            this.updateReactor();
        } else {
            this.setActive(false);
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerReactorPlanner(player.field_71071_by, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiReactorPlanner";
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    public boolean onRightClick(EntityPlayer player, EnumFacing face, Side side) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof IItemReactorPlanStorage) {
            if (side == Side.CLIENT) {
                return false;
            }
            IItemReactorPlanStorage storage = (IItemReactorPlanStorage)stack.func_77973_b();
            if (!storage.isPlanStorage(stack)) {
                return false;
            }
            if (player.func_70093_af()) {
                IEncoder encoder = EncoderRegistry.instance.getDefaultEncoder();
                String setup = encoder.createEncodedData(this);
                if (!Strings.isNullOrEmpty((String)setup)) {
                    if (storage.setSetup(stack, setup)) {
                        if (!Strings.isNullOrEmpty((String)this.setupName)) {
                            storage.setPlanName(stack, this.setupName);
                        }
                        IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.exportToItemSuccess.name"));
                        return true;
                    }
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.exportToItemFail.name"));
                } else {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.encoderFailed.name"));
                }
                return true;
            }
            if (storage.hasSetup(stack)) {
                Tuple<String, NBTTagCompound> data = EncoderRegistry.instance.createDecodedMessage(storage.getSetup(stack));
                if (data != null) {
                    IEncoder encoder = EncoderRegistry.instance.getEncoderFromID(data.getFirst());
                    int oldSize = this.reactorSize;
                    boolean steam = this.isSteamReactor;
                    String oldName = this.setupName;
                    NBTTagCompound backup = new NBTTagCompound();
                    NBTTagCompound settingBackup = new NBTTagCompound();
                    this.getReactorLogic().writeToNBT(backup);
                    this.getUserSettings().writeToNBT(settingBackup);
                    encoder.processData(data.getSecond(), this);
                    boolean failed = false;
                    if (!this.getReactorLogic().isValid()) {
                        failed = true;
                        this.getReactorLogic().clear();
                        this.isSteamReactor = steam;
                        this.reactorSize = oldSize;
                        this.setupName = oldName;
                        this.getReactorLogic().readFromNBT(backup);
                        this.getUserSettings().readFromNBT(settingBackup);
                    }
                    ReactorLogicBase.IReactorPrediction pred = this.getReactorLogic().createPrediction();
                    NBTTagCompound nbt = new NBTTagCompound();
                    pred.writeToNBT(nbt);
                    this.getPrediction().readFromNBT((NBTTagCompound)nbt.func_74737_b());
                    this.getNetwork().updateTileGuiField(this, "isSteamReactor");
                    this.getNetwork().updateTileGuiField(this, "reactorSize");
                    this.getNetwork().updateTileGuiField(this, "setupName");
                    this.updateReactor();
                    this.updatePrediction();
                    this.updateContainer(player);
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)("container.reactorplannerAction." + (failed ? "importToItemFail" : "importFromItemSuccess") + ".name")));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.components.create();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.components.readFromNBT(nbt.func_74775_l("Components"));
        this.settings.readFromNBT(nbt.func_74775_l("Settings"));
        this.isSteamReactor = nbt.func_74767_n("steam");
        this.reactorSize = nbt.func_74762_e("ReactorSize");
        this.selectedSlot = nbt.func_74762_e("SelectedSlot");
        this.getReactorLogic().readFromNBT(nbt.func_74775_l("Logic"));
        this.getPrediction().readFromNBT(nbt.func_74775_l("Prediction"));
        this.setupName = nbt.func_74779_i("SetupName");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.components.writeToNBT(this.getNBT(nbt, "Components"));
        this.settings.writeToNBT(this.getNBT(nbt, "Settings"));
        this.getReactorLogic().writeToNBT(this.getNBT(nbt, "Logic"));
        this.getPrediction().writeToNBT(this.getNBT(nbt, "Prediction"));
        nbt.func_74757_a("steam", this.isSteamReactor);
        nbt.func_74768_a("ReactorSize", this.reactorSize);
        nbt.func_74768_a("SelectedSlot", this.selectedSlot);
        nbt.func_74778_a("SetupName", this.setupName);
    }

    @Override
    public void onNetworkEvent(int event) {
        EntityPlayer player;
        ContainerReactorPlanner planner;
        if (event == 0 && (planner = this.getContainer(player = IC2.platform.getPlayerInstance())) != null) {
            planner.reset(player.field_71071_by);
            planner.func_75142_b();
        }
    }

    @Override
    public void onPayloadPacket(EntityPlayer player, PayloadPacket packet) {
        if (packet.getSize(1) == 1 && packet.getSize(0) == 1) {
            this.setupName = packet.getString(0);
            this.getNetwork().updateTileGuiField(this, "setupName");
        } else if (packet.getSize(1) == 2) {
            ReactorLogicBase base;
            UserSettings user;
            ReactorLogicBase base2;
            int event = packet.getNumber(0);
            int value = packet.getNumber(1);
            if (event == 0) {
                this.clearCurrentReactor();
                this.isSteamReactor = value == 1;
                this.selectedSlot = 0;
                this.components.offset = 0;
                this.components.create();
                this.getNetwork().updateTileGuiField(this, "isSteamReactor");
                this.getNetwork().updateTileGuiField(this, "components");
                this.getNetwork().updateTileGuiField(this, "selectedSlot");
                this.updateContainer(player);
            }
            if (event == 1) {
                this.components.applyOffset(value);
                this.selectedSlot = 0;
                this.getNetwork().updateTileGuiField(this, "components");
                this.getNetwork().updateTileGuiField(this, "selectedSlot");
                this.updateContainer(player);
            }
            if (event == 2) {
                this.components.setNextFilter();
                this.selectedSlot = 0;
                this.getNetwork().updateTileGuiField(this, "selectedSlot");
                this.getNetwork().updateTileGuiField(this, "components");
                this.updateContainer(player);
            }
            if (event == 3) {
                this.reactorSize += value;
                if (this.reactorSize < 0) {
                    this.reactorSize = 0;
                }
                if (this.reactorSize > 6) {
                    this.reactorSize = 6;
                }
                this.getNetwork().updateTileEntityField(this, "reactorSize");
                this.getReactorLogic().onSizeUpdate();
                ContainerReactorPlanner cont = this.getContainer(player);
                if (cont != null) {
                    cont.reset(player.field_71071_by);
                    cont.func_75142_b();
                }
            }
            if (event == 4) {
                this.stackSize += value;
                if (this.stackSize < 1) {
                    this.stackSize = 1;
                }
                if (this.stackSize > 64) {
                    this.stackSize = 64;
                }
                this.getNetwork().updateTileGuiField(this, "stackSize");
            }
            if (event == 5) {
                this.setActive(value == 0);
            }
            if (event == 6) {
                base2 = this.getReactorLogic();
                if (value == 0) {
                    if (!base2.isValid()) {
                        base2.validate();
                        NBTTagCompound data = new NBTTagCompound();
                        ReactorLogicBase.IReactorPrediction pred = base2.createPrediction();
                        pred.writeToNBT(data);
                        this.getPrediction().readFromNBT((NBTTagCompound)data.func_74737_b());
                        this.updateReactor();
                        this.updatePrediction();
                    }
                } else if (base2.isValid()) {
                    base2.reset();
                    this.updateReactor();
                    this.updatePrediction();
                }
            }
            if (event == 7) {
                base2 = this.getReactorLogic();
                if (value == 0) {
                    if (base2.isValid()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        base2.createBackup().writeToNBT(nbt);
                        this.backup.readFromNBT((NBTTagCompound)nbt.func_74737_b());
                        this.getNetwork().updateTileGuiField(this, "backup");
                        this.getNetwork().updateTileGuiField(this, "settings");
                        this.updateReactor();
                        this.updatePrediction();
                    }
                } else if (this.backup.hasBackup) {
                    base2.clear();
                    this.getPrediction().clear();
                    this.isSteamReactor = this.backup.isSteam;
                    this.reactorSize = this.backup.reactorSize;
                    this.getNetwork().updateTileEntityField(this, "reactorSize");
                    this.getNetwork().initiateTileEntityEvent(this, 0, false);
                    ContainerReactorPlanner cont = this.getContainer(player);
                    if (cont != null) {
                        cont.reset(player.field_71071_by);
                    }
                    base2 = this.getReactorLogic();
                    base2.restoreFromBackup(this.backup);
                    this.updateReactor();
                    this.updatePrediction();
                    this.getNetwork().updateTileGuiField(this, "settings");
                }
            }
            if (event == 8) {
                if (value == 0) {
                    this.getReactorLogic().clear();
                    this.getPrediction().clear();
                    this.updateReactor();
                    this.updatePrediction();
                    this.updateContainer(player);
                    this.setupName = "";
                    this.getNetwork().updateTileGuiField(this, "setupName");
                } else if (value == 1) {
                    this.backup = new ReactorBackup();
                    this.getNetwork().updateTileGuiField(this, "backup");
                }
            }
            if (event == 9) {
                this.selectedView = value;
                this.getNetwork().updateTileGuiField(this, "selectedView");
            }
            if (event == 10) {
                user = this.getUserSettings();
                base = this.getReactorLogic();
                user.startingHeat += value;
                if (user.startingHeat < 0) {
                    user.startingHeat = 0;
                }
                if (user.startingHeat > base.maxHeat - 100) {
                    user.startingHeat = base.maxHeat - 100;
                }
                this.getNetwork().updateTileGuiField(this, "settings");
            }
            if (event == 11) {
                base2 = this.getReactorLogic();
                base2.producing = !base2.producing;
                this.updateReactor();
            }
            if (event == 12) {
                user = this.getUserSettings();
                base = this.getReactorLogic();
                user.maxTicks += value;
                if (user.maxTicks < 0) {
                    user.maxTicks = 0;
                }
                if (user.maxTicks > 99999999) {
                    user.maxTicks = 99999999;
                }
                this.getNetwork().updateTileGuiField(this, "settings");
            }
            if (event == 13) {
                int max = IC2.reactorPlannerMaxTicks;
                UserSettings user2 = this.getUserSettings();
                user2.ticksPerTick += value;
                if (user2.ticksPerTick < 1) {
                    user2.ticksPerTick = 1;
                }
                if (user2.ticksPerTick > max) {
                    user2.ticksPerTick = max;
                }
                this.getNetwork().updateTileGuiField(this, "settings");
            }
        } else if (packet.getSize(0) == 2) {
            String key = packet.getString(0);
            NBTTagCompound data = this.getNBTFromString(packet.getString(1));
            if (data.func_82582_d()) {
                IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.lostData.name"));
                return;
            }
            IEncoder encoder = EncoderRegistry.instance.getEncoderFromID(key);
            if (encoder == null) {
                IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.encoderNotOnServer.name"));
                return;
            }
            int oldSize = this.reactorSize;
            boolean steam = this.isSteamReactor;
            String oldName = this.setupName;
            NBTTagCompound backup = new NBTTagCompound();
            NBTTagCompound settingBackup = new NBTTagCompound();
            this.getReactorLogic().writeToNBT(backup);
            this.getUserSettings().writeToNBT(settingBackup);
            encoder.processData(data, this);
            boolean failed = false;
            if (!this.getReactorLogic().isValid()) {
                failed = true;
                this.getReactorLogic().clear();
                this.isSteamReactor = steam;
                this.reactorSize = oldSize;
                this.setupName = oldName;
                this.getReactorLogic().readFromNBT(backup);
                this.getUserSettings().readFromNBT(settingBackup);
            }
            ReactorLogicBase.IReactorPrediction pred = this.getReactorLogic().createPrediction();
            NBTTagCompound nbt = new NBTTagCompound();
            pred.writeToNBT(nbt);
            this.getPrediction().readFromNBT((NBTTagCompound)nbt.func_74737_b());
            this.getNetwork().updateTileGuiField(this, "isSteamReactor");
            this.getNetwork().updateTileGuiField(this, "reactorSize");
            this.getNetwork().updateTileGuiField(this, "setupName");
            this.updateReactor();
            this.updatePrediction();
            this.updateContainer(player);
            IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)("container.reactorplannerAction." + (failed ? "importFail" : "importSuccess") + ".name")));
        } else if (packet.getSize(0) == 1) {
            IEncoder encoder = EncoderRegistry.instance.getEncoderFromID(packet.getString(0));
            if (encoder == null) {
                IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.encoderNotOnServer.name"));
                return;
            }
            String encoded = encoder.createEncodedData(this);
            if (Strings.isNullOrEmpty((String)encoded)) {
                IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.reactorplannerAction.encoderFailed.name"));
                return;
            }
            this.getNetwork().sendCustomPacket(player, new ReactorPlannerEncoderPacket(encoded));
        }
    }

    private NBTTagCompound getNBTFromString(String key) {
        try {
            return (NBTTagCompound)JsonToNBT.func_150315_a((String)key);
        }
        catch (Exception exception) {
            return new NBTTagCompound();
        }
    }

    private void updateContainer(EntityPlayer player) {
        ContainerReactorPlanner cont = this.getContainer(player);
        if (cont != null) {
            cont.func_75142_b();
        }
    }

    private ContainerReactorPlanner getContainer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        Container cont = player.field_71070_bA;
        if (cont instanceof ContainerReactorPlanner) {
            return (ContainerReactorPlanner)cont;
        }
        return null;
    }

    public void clearCurrentReactor() {
        this.getReactorLogic().clear();
        this.getPrediction().clear();
        this.updateReactor();
        this.updatePrediction();
    }

    public void updateReactor() {
        this.getNetwork().updateTileGuiField(this, this.isSteamReactor ? "steamReactor" : "reactor");
    }

    public void updatePrediction() {
        this.getNetwork().updateTileGuiField(this, this.isSteamReactor ? "steamReactorPrediction" : "reactorPrediction");
    }

    @Override
    public int getEnergyUsage() {
        return 10;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    @Override
    public String func_145825_b() {
        return null;
    }

    public static class ReactorBackup
    implements INetworkFieldData {
        public ItemStack[] items = new ItemStack[54];
        public int customTicks;
        public int customHeat;
        public int reactorSize;
        public boolean hasBackup = false;
        public boolean isSteam;

        public void readFromNBT(NBTTagCompound nbt) {
            this.customTicks = nbt.func_74762_e("CustomTicks");
            this.customHeat = nbt.func_74762_e("CustomHeat");
            this.reactorSize = nbt.func_74762_e("Size");
            this.hasBackup = nbt.func_74767_n("HasBackup");
            this.isSteam = nbt.func_74767_n("isSteam");
            this.items = new ItemStack[54];
            NBTTagList list = nbt.func_150295_c("Setup", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                this.items[data.func_74762_e((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)data);
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("CustomTicks", this.customTicks);
            nbt.func_74768_a("CustomHeat", this.customHeat);
            nbt.func_74768_a("Size", this.reactorSize);
            nbt.func_74757_a("HasBackup", this.hasBackup);
            nbt.func_74757_a("isSteam", this.isSteam);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < 54; ++i) {
                if (this.items[i] == null) continue;
                NBTTagCompound data = new NBTTagCompound();
                this.items[i].func_77955_b(data);
                data.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)data);
            }
            nbt.func_74782_a("Setup", (NBTBase)list);
        }

        @Override
        public void read(DataInput stream) {
            try {
                this.hasBackup = stream.readBoolean();
                this.reactorSize = stream.readInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void write(DataOutput stream) {
            try {
                stream.writeBoolean(this.hasBackup);
                stream.writeInt(this.reactorSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class UserSettings
    implements INetworkFieldData {
        public int maxTicks = 0;
        public int startingHeat = 0;
        public int ticksPerTick = 1;

        @Override
        public void read(DataInput stream) {
            try {
                this.maxTicks = stream.readInt();
                this.startingHeat = stream.readInt();
                this.ticksPerTick = stream.readInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void write(DataOutput stream) {
            try {
                stream.writeInt(this.maxTicks);
                stream.writeInt(this.startingHeat);
                stream.writeInt(this.ticksPerTick);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.maxTicks = nbt.func_74762_e("Max");
            this.startingHeat = nbt.func_74762_e("StartingHeat");
            this.ticksPerTick = nbt.func_74762_e("Ticks");
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("Max", this.maxTicks);
            nbt.func_74768_a("StartingHeat", this.startingHeat);
            nbt.func_74768_a("Ticks", this.ticksPerTick);
        }
    }
}

