/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.api.tile.IMachine;
import ic2.core.BasicListRecipeManager;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityRecycler
extends TileEntityElectricMachine {
    public TileEntityRecycler() {
        super(3, 1, 45, 32);
    }

    public static void init(Configuration config) {
        Property prop = config.get("general", "recyclerBlacklist", TileEntityRecycler.getRecyclerBlacklistString());
        prop.comment = "List of blocks and items which should not be turned into scrap by the recycler. Comma separated, format is id(Block/ItemName)-metadata";
        Recipes.recyclerBlacklist.getInputs().clear();
        TileEntityRecycler.setRecyclerBlacklistFromString(prop.getString());
    }

    public static void preInit() {
        Recipes.recycler = new RecyclerRecipeManager();
        Recipes.recyclerWhitelist = new BasicListRecipeManager();
        Recipes.recyclerBlacklist = new BasicListRecipeManager();
        TileEntityRecycler.addBlacklistItem(Blocks.field_150410_aZ);
        TileEntityRecycler.addBlacklistItem(Items.field_151055_y);
        TileEntityRecycler.addBlacklistItem(Items.field_151126_ay);
        TileEntityRecycler.addBlacklistItem(Ic2Items.scaffold);
    }

    private static boolean isMetal(ItemStack par1) {
        boolean flag = false;
        for (int id : OreDictionary.getOreIDs((ItemStack)par1)) {
            String name = OreDictionary.getOreName((int)id);
            if (!name.contains("ingot") && !name.contains("metal")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public void operateOnce(RecipeOutput result, List<ItemStack> items) {
        if (this.field_145850_b.field_73012_v.nextInt(TileEntityRecycler.recycleChance(this.inventory[0])) == 0) {
            super.operateOnce(result, items);
        } else {
            this.getResultFor(this.inventory[0], true);
        }
    }

    @Override
    public RecipeOutput getResultFor(ItemStack itemstack, boolean adjustInput) {
        return Recipes.recycler.getOutputFor(itemstack, adjustInput);
    }

    @Override
    public String func_145825_b() {
        return "Recycler";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiRecycler";
    }

    public static int recycleChance() {
        return 8;
    }

    public static int recycleChance(ItemStack par1) {
        return TileEntityRecycler.isMetal(par1) ? 4 : 8;
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/RecyclerOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    public static void addBlacklistItem(Item item) {
        TileEntityRecycler.addBlacklistItem(new ItemStack(item));
    }

    public static void addBlacklistItem(Block block) {
        TileEntityRecycler.addBlacklistItem(new ItemStack(block));
    }

    public static void addBlacklistItem(ItemStack item) {
        Recipes.recyclerBlacklist.add(new RecipeInputItemStack(item));
    }

    public static boolean getIsItemBlacklisted(ItemStack itemStack) {
        for (IRecipeInput blackItem : Recipes.recyclerBlacklist) {
            if (!blackItem.matches(itemStack)) continue;
            return true;
        }
        return false;
    }

    private static String getRecyclerBlacklistString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (IRecipeInput entry : Recipes.recyclerBlacklist.getInputs()) {
            if (entry == null) continue;
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(Item.field_150901_e.func_148750_c((Object)entry.getInputs().get(0).func_77973_b()));
            if (entry.getInputs().get(0).func_77960_j() == 0) continue;
            ret.append("-");
            ret.append(entry.getInputs().get(0).func_77960_j());
        }
        return ret.toString();
    }

    private static void setRecyclerBlacklistFromString(String str) {
        String[] arr$;
        for (String strPart : arr$ = str.trim().split("\\s*,\\s*")) {
            String[] idMeta = strPart.split("\\s*-\\s*");
            if (idMeta[0].length() == 0) continue;
            String[] split = idMeta[0].split(":");
            Item blockId = GameRegistry.findItem((String)split[0], (String)split[1]);
            ItemStack stack = null;
            if (blockId == null) {
                Block block = GameRegistry.findBlock((String)split[0], (String)split[1]);
                if (block != null) {
                    stack = new ItemStack(block);
                }
            } else {
                stack = new ItemStack(blockId);
            }
            if (stack == null) {
                FMLLog.getLogger().info("Recycler Error: Could not find: " + idMeta[0] + " Please check the registry names to fix it");
                continue;
            }
            int metaData = Short.MAX_VALUE;
            if (idMeta.length == 2) {
                metaData = Integer.parseInt(idMeta[1]);
            }
            stack.func_77964_b(metaData);
            TileEntityRecycler.addBlacklistItem(stack);
        }
    }

    @Override
    public List<IMachine.UpgradeType> getSupportedTypes() {
        List<IMachine.UpgradeType> list = super.getSupportedTypes();
        list.remove((Object)IMachine.UpgradeType.WorldInteraction);
        return list;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (!TileEntityRecycler.getIsItemBlacklisted(par1)) {
            return super.isValidInput(par1);
        }
        return false;
    }

    @Override
    public IMachineRecipeManager getRecipeList() {
        return Recipes.recycler;
    }

    private static class RecyclerRecipeManager
    implements IMachineRecipeManager {
        private RecyclerRecipeManager() {
        }

        @Override
        public void addRecipe(IRecipeInput input, NBTTagCompound metadata, ItemStack ... outputs) {
        }

        @Override
        public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
            RecipeOutput ret;
            if (!TileEntityRecycler.getIsItemBlacklisted(input)) {
                boolean flag = false;
                for (int i : OreDictionary.getOreIDs((ItemStack)input)) {
                    String name = OreDictionary.getOreName((int)i);
                    if (!name.contains("ingot") && !name.contains("metal")) continue;
                    flag = true;
                    break;
                }
                ret = flag ? new RecipeOutput(null, StackUtil.copyWithSize(Ic2Items.scrapMetal.func_77946_l(), 1)) : new RecipeOutput(null, StackUtil.copyWithSize(Ic2Items.scrap.func_77946_l(), 1));
            } else {
                return null;
            }
            if (adjustInput) {
                --input.field_77994_a;
            }
            return ret;
        }

        @Override
        public Map<IRecipeInput, RecipeOutput> getRecipes() {
            return null;
        }
    }
}

