/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IMachineUpgradeItem;
import ic2.api.tile.IMachine;
import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.container.ContainerSoundBeacon;
import ic2.core.block.machine.tileentity.FakeMachine;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.item.ItemChargePadUpgrade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TileEntitySoundBeacon
extends TileEntityElecMachine
implements IHasGui {
    public static List<TileEntitySoundBeacon> beacon = new ArrayList<TileEntitySoundBeacon>();
    public FakeMachine machine;
    public int tileRange = 5;
    public int itemRange = 5;
    public int armorRange = 5;
    public float tileEffect = 1.0f;
    public float itemEffect = 1.0f;
    public float armorEffect = 1.0f;

    public TileEntitySoundBeacon() {
        super(9, -1, 20000, 32, 1);
        this.addNetworkFields("tileRange", "itemRange", "armorRange", "tileEffect", "itemEffect", "armorEffect");
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public String func_145825_b() {
        return "Sound Beacon";
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.machine = new FakeMachine(this, Arrays.asList(IMachine.UpgradeType.Sounds));
        this.tileRange = 5;
        this.itemRange = 5;
        this.armorRange = 5;
        this.tileEffect = 1.0f;
        this.itemEffect = 1.0f;
        this.armorEffect = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int x = 0; x < 3; ++x) {
                int meta;
                int slot = i * 3 + x;
                ItemStack item = this.inventory[slot];
                if (item == null) continue;
                if (i == 0) {
                    if (item.func_77973_b() instanceof IMachineUpgradeItem) {
                        this.tileEffect = (float)((double)this.tileEffect * Math.pow(((IMachineUpgradeItem)item.func_77973_b()).getSoundVolumeMultiplier(item, this.machine), item.field_77994_a));
                        continue;
                    }
                    if (!(item.func_77973_b() instanceof ItemChargePadUpgrade)) continue;
                    meta = item.func_77960_j();
                    if (meta == 9) {
                        this.tileRange += 2;
                        continue;
                    }
                    if (meta == 10) {
                        this.tileRange += 5;
                        continue;
                    }
                    if (meta != 11) continue;
                    this.tileRange += 10;
                    continue;
                }
                if (i == 1) {
                    if (item.func_77973_b() instanceof IMachineUpgradeItem) {
                        this.itemEffect = (float)((double)this.itemEffect * Math.pow(((IMachineUpgradeItem)item.func_77973_b()).getSoundVolumeMultiplier(item, this.machine), item.field_77994_a));
                        continue;
                    }
                    if (!(item.func_77973_b() instanceof ItemChargePadUpgrade)) continue;
                    meta = item.func_77960_j();
                    if (meta == 9) {
                        this.itemRange += 2;
                        continue;
                    }
                    if (meta == 10) {
                        this.itemRange += 5;
                        continue;
                    }
                    if (meta != 11) continue;
                    this.itemRange += 10;
                    continue;
                }
                if (item.func_77973_b() instanceof IMachineUpgradeItem) {
                    this.armorEffect = (float)((double)this.armorEffect * Math.pow(((IMachineUpgradeItem)item.func_77973_b()).getSoundVolumeMultiplier(item, this.machine), item.field_77994_a));
                    continue;
                }
                if (!(item.func_77973_b() instanceof ItemChargePadUpgrade)) continue;
                meta = item.func_77960_j();
                if (meta == 9) {
                    this.armorRange += 2;
                    continue;
                }
                if (meta == 10) {
                    this.armorRange += 5;
                    continue;
                }
                if (meta != 11) continue;
                this.armorRange += 10;
            }
        }
        this.getNetwork().updateTileEntityField(this, "tileRange");
        this.getNetwork().updateTileEntityField(this, "itemRange");
        this.getNetwork().updateTileEntityField(this, "armorRange");
        this.getNetwork().updateTileEntityField(this, "tileEffect");
        this.getNetwork().updateTileEntityField(this, "itemEffect");
        this.getNetwork().updateTileEntityField(this, "armorEffect");
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        if (this.isRendering()) {
            if (this.field_145850_b.func_82737_E() % 50L != 0L) {
                return;
            }
            this.addIfNeeded();
            return;
        }
        if (!this.getActive()) {
            if (this.energy >= 5) {
                this.useEnergy(5);
                this.setActive(true);
            }
        } else if (this.getActive()) {
            if (this.energy >= 5) {
                this.useEnergy(5);
                return;
            }
            this.setActive(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addIfNeeded() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == this.field_145850_b && !beacon.contains(this)) {
            beacon.add(this);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isRendering()) {
            TileEntitySoundBeacon.addTile(this);
        } else {
            this.func_70296_d();
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering()) {
            TileEntitySoundBeacon.removeTile(this);
        }
        super.onUnloaded();
    }

    private static void addTile(TileEntitySoundBeacon par1) {
        beacon.add(par1);
    }

    private static void removeTile(TileEntitySoundBeacon par1) {
        beacon.remove(par1);
    }

    public static void updateList(World world) {
        if (beacon.isEmpty()) {
            return;
        }
        if (world == null) {
            beacon = new ArrayList<TileEntitySoundBeacon>();
            return;
        }
        for (int i = 0; i < beacon.size(); ++i) {
            TileEntitySoundBeacon tile = beacon.get(i);
            if (tile.func_145831_w() == world) continue;
            beacon.remove(i--);
        }
    }

    public boolean isInRange(AudioPosition position, PositionSpec spec) {
        int range = this.getRange(spec);
        int minX = this.field_145851_c - range;
        int minY = this.field_145848_d - range;
        int minZ = this.field_145849_e - range;
        int maxX = this.field_145851_c + range;
        int maxY = this.field_145848_d + range;
        int maxZ = this.field_145849_e + range;
        return (float)minX <= position.x && (float)maxX >= position.x && (float)minY <= position.y && (float)maxY >= position.y && (float)minZ <= position.z && (float)maxZ >= position.z;
    }

    public int getRange(PositionSpec spec) {
        switch (spec) {
            case Backpack: {
                return this.armorRange;
            }
            case Center: {
                return this.tileRange;
            }
            case Hand: {
                return this.itemRange;
            }
        }
        return 0;
    }

    public float getEffect(PositionSpec spec) {
        switch (spec) {
            case Backpack: {
                return this.armorEffect;
            }
            case Center: {
                return this.tileEffect;
            }
            case Hand: {
                return this.itemEffect;
            }
        }
        return 1.0f;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerSoundBeacon(this, p0.field_71071_by);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiSoundBeacon";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }
}

