/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2DamageSource;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTesla
extends TileEntityBlock
implements IEnergySink,
IEnergyContainer {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 10000;
    public int maxInput = 128;
    public boolean addedToEnergyNet = false;

    public TileEntityTesla() {
        this.addGuiFields("energy");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.isSimulating() || !this.redstoned()) {
            return;
        }
        if (this.energy < TileEntityTesla.getCost()) {
            return;
        }
        int damage = this.energy / TileEntityTesla.getCost();
        --this.energy;
        if (this.ticker++ % 32 == 0 && this.shock(damage)) {
            this.energy = 0;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    public boolean shock(int damage) {
        boolean shock = false;
        List list1 = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 4), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5)));
        for (int l = 0; l < list1.size(); ++l) {
            EntityLivingBase victim = (EntityLivingBase)list1.get(l);
            if (ItemArmorHazmat.hasCompleteHazmat(victim)) continue;
            shock = true;
            victim.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
            for (int i = 0; i < damage; ++i) {
                this.field_145850_b.func_72869_a("reddust", victim.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), victim.field_70163_u + (double)(this.field_145850_b.field_73012_v.nextFloat() * 2.0f), victim.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 0.0, 0.0, 1.0);
            }
        }
        return shock;
    }

    public boolean redstoned() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static int getCost() {
        return 400;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        if (amount > (double)this.maxInput) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return re;
    }

    @Override
    public int getSinkTier() {
        return EnergyNet.instance.getTierFromPower(this.maxInput);
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyUsage() {
        return this.energy;
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return 128;
    }
}

