/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.IIndirectInventory;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.personal.ContainerPersonalChest;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.IPersonalInventory;
import ic2.core.block.personal.PersonalInventory;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class TileEntityPersonalChest
extends TileEntityBlock
implements IPersonalBlock,
IHasGui,
IIndirectInventory {
    private int ticksSinceSync;
    private int numUsingPlayers;
    public float lidAngle;
    public float prevLidAngle;
    public UUID owner;
    PersonalInventory inv = new PersonalInventory(this, "Personal Save", 54);

    public TileEntityPersonalChest() {
        this.addNetworkFields("owner");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("PlayerOwner")) {
            NBTTagCompound nbt = nbttagcompound.func_74775_l("PlayerOwner");
            this.owner = new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast"));
        } else {
            this.owner = null;
        }
        this.inv.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("UUIDMost", this.owner.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.owner.getLeastSignificantBits());
            nbttagcompound.func_74782_a("PlayerOwner", (NBTBase)nbt);
        }
        this.inv.writeToNBT(nbttagcompound);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        double var3;
        if (++this.ticksSinceSync % 20 * 4 == 0 && this.isSimulating()) {
            this.syncNumUsingPlayers();
        }
        this.prevLidAngle = this.lidAngle;
        float var1 = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double var2 = (double)this.field_145851_c + 0.5;
            var3 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(var2, (double)this.field_145848_d + 0.5, var3, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float var5;
            float var4 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += var1) : (this.lidAngle -= var1);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (var5 = 0.5f) && var4 >= var5) {
                var3 = (double)this.field_145851_c + 0.5;
                double var6 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(var3, (double)this.field_145848_d + 0.5, var6, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public void openInventory() {
        ++this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    @Override
    public void closeInventory() {
        --this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public boolean func_145842_c(int event, int data) {
        if (event == 1) {
            this.numUsingPlayers = data;
        }
        return true;
    }

    private void syncNumUsingPlayers() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        if (!this.canAccess(entityPlayer)) {
            return false;
        }
        boolean flag = this.inv.isInvEmpty();
        if (!flag) {
            IC2.platform.messagePlayer(entityPlayer, StatCollector.func_74838_a((String)"itemInfo.wrenchPickSafe.name"));
        }
        return flag;
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner == null) {
            this.owner = player.func_146103_bH().getId();
            this.getNetwork().updateTileEntityField(this, "owner");
            return true;
        }
        return this.canAccess(player.func_146103_bH().getId());
    }

    @Override
    public boolean canAccess(UUID player) {
        if (this.owner == null) {
            return true;
        }
        return this.owner.equals(player);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPersonalChest(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.personal.GuiPersonalChest";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public IPersonalInventory getInventory(EntityPlayer player) {
        if (!this.canAccess(player)) {
            return null;
        }
        return this.getInventory(player.func_146103_bH().getId());
    }

    @Override
    public IPersonalInventory getInventory(UUID player) {
        if (!this.canAccess(player)) {
            return null;
        }
        return this.inv;
    }
}

