/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import ic2.api.Direction;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.PositionSpec;
import ic2.core.block.inventory.filter.BasicItemFilter;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.personal.ContainerTradeOMatClosed;
import ic2.core.block.personal.ContainerTradeOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.IPersonalInventory;
import ic2.core.block.personal.PersonalInventory;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.util.StackUtil;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class TileEntityTradeOMat
extends TileEntityMachine
implements IPersonalBlock,
IHasGui,
IPersonalInventory,
ISidedInventory,
INetworkTileEntityEventListener {
    private static Direction[] directions = Direction.values();
    public static Random randomizer = new Random();
    private UUID owner;
    public int totalTradeCount = 0;
    public int stock = 0;
    private static int EventTrade = 0;
    private PersonalInventory inv = new PersonalInventory(this, "Trade-O-Mat", 2);

    public TileEntityTradeOMat() {
        super(2);
        this.addNetworkFields("owner");
        this.addGuiFields("totalTradeCount", "stock");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("PlayerOwner")) {
            NBTTagCompound nbt = nbttagcompound.func_74775_l("PlayerOwner");
            this.owner = new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast"));
        } else {
            this.owner = null;
        }
        this.totalTradeCount = nbttagcompound.func_74762_e("totalTradeCount");
        this.inv.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("UUIDMost", this.owner.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.owner.getLeastSignificantBits());
            nbttagcompound.func_74782_a("PlayerOwner", (NBTBase)nbt);
        }
        nbttagcompound.func_74768_a("totalTradeCount", this.totalTradeCount);
        this.inv.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.inv.func_70301_a(0) != null && this.inv.func_70301_a(1) != null && this.inventory[0] != null && StackUtil.isStackEqual(this.inv.func_70301_a(0), this.inventory[0]) && this.inventory[0].field_77994_a >= this.inv.func_70301_a((int)0).field_77994_a && (this.inventory[1] == null || StackUtil.isStackEqual(this.inv.func_70301_a(1), this.inventory[1]) && this.inventory[1].field_77994_a + this.inv.func_70301_a((int)1).field_77994_a <= this.inventory[1].func_77976_d())) {
            boolean tradePerformed = false;
            for (Direction direction : directions) {
                ItemStack gs;
                TileEntity target = direction.applyToTileEntity(this);
                if (!(target instanceof IInventory) || target instanceof TileEntityPersonalChest && !((TileEntityPersonalChest)target).owner.equals(this.owner)) continue;
                IInventory targetInventory = (IInventory)target;
                if (target instanceof TileEntityChest) {
                    targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
                }
                if (targetInventory == null || targetInventory.func_70302_i_() < 18) continue;
                int inputSpace = 0;
                int outputAvailable = 0;
                for (int i = 0; i < targetInventory.func_70302_i_(); ++i) {
                    ItemStack itemStack = targetInventory.func_70301_a(i);
                    if (itemStack == null) {
                        inputSpace += this.inv.func_70301_a(0).func_77976_d();
                        continue;
                    }
                    if (StackUtil.isStackEqual(itemStack, this.inv.func_70301_a(0))) {
                        inputSpace += itemStack.func_77976_d() - itemStack.field_77994_a;
                    }
                    if (!StackUtil.isStackEqual(itemStack, this.inv.func_70301_a(1))) continue;
                    outputAvailable += itemStack.field_77994_a;
                }
                int outputSpace = this.inventory[1] == null ? this.inv.func_70301_a(1).func_77976_d() : this.inventory[1].func_77976_d() - this.inventory[1].field_77994_a;
                int tradeCount = Math.min(Math.min(Math.min(this.inventory[0].field_77994_a / this.inv.func_70301_a((int)0).field_77994_a, inputSpace / this.inv.func_70301_a((int)0).field_77994_a), outputSpace / this.inv.func_70301_a((int)1).field_77994_a), outputAvailable / this.inv.func_70301_a((int)1).field_77994_a);
                if (tradeCount <= 0) continue;
                int inputCount = this.inv.func_70301_a((int)0).field_77994_a * tradeCount;
                int outputCount = this.inv.func_70301_a((int)1).field_77994_a * tradeCount;
                ItemStack itemStack2 = this.inventory[0];
                itemStack2.field_77994_a -= inputCount;
                if (this.inventory[0].field_77994_a == 0) {
                    this.inventory[0] = null;
                }
                if ((gs = StackUtil.getFromInventory(targetInventory, direction, this.owner, new BasicItemFilter(this.inv.func_70301_a(1).func_77946_l()), outputCount, true)) != null) {
                    if (this.inventory[1] == null) {
                        this.inventory[1] = gs;
                    } else {
                        ItemStack itemStack3 = this.inventory[1];
                        itemStack3.field_77994_a += gs.field_77994_a;
                    }
                }
                ItemStack item = this.inv.func_70301_a(0).func_77946_l();
                item.field_77994_a = inputCount;
                StackUtil.putInInventory(targetInventory, direction, this.owner, item);
                this.totalTradeCount += tradeCount;
                tradePerformed = true;
                this.getNetwork().initiateTileEntityEvent(this, 0, true);
                this.func_70296_d();
                break;
            }
            if (tradePerformed) {
                this.updateStock();
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.updateStock();
        }
    }

    public void updateStock() {
        this.stock = 0;
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IInventory) || target instanceof TileEntityPersonalChest && !((TileEntityPersonalChest)target).owner.equals(this.owner)) continue;
            IInventory targetInventory = (IInventory)target;
            if (target instanceof TileEntityChest) {
                targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
            }
            if (targetInventory.func_70302_i_() < 18) continue;
            for (int i = 0; i < targetInventory.func_70302_i_(); ++i) {
                ItemStack stack = targetInventory.func_70301_a(i);
                if (!StackUtil.isStackEqual(this.inv.func_70301_a(1), stack)) continue;
                this.stock += stack.field_77994_a;
            }
        }
        this.getNetwork().updateTileGuiField(this, "stock");
        this.getNetwork().updateTileGuiField(this, "totalTradeCount");
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.canAccess(entityPlayer);
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner == null) {
            this.owner = player.func_146103_bH().getId();
            this.getNetwork().updateTileGuiField(this, "owner");
            return true;
        }
        return this.canAccess(player.func_146103_bH().getId());
    }

    @Override
    public boolean canAccess(UUID player) {
        if (this.owner == null) {
            return true;
        }
        return this.owner.equals(player);
    }

    @Override
    public String func_145825_b() {
        return "Trade-O-Mat";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return new ContainerTradeOMatOpen(entityPlayer, this);
        }
        return new ContainerTradeOMatClosed(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return "block.personal.GuiTradeOMatOpen";
        }
        return "block.personal.GuiTradeOMatClosed";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        return new int[]{var1 == 1 ? 1 : 0};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/o-mat.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\nT: " + this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ")");
            }
        }
    }

    @Override
    public IPersonalInventory getInventory(EntityPlayer player) {
        if (!this.canAccess(player)) {
            return this;
        }
        return this.getInventory(player.func_146103_bH().getId());
    }

    @Override
    public IPersonalInventory getInventory(UUID player) {
        if (!this.canAccess(player)) {
            return this;
        }
        return this.inv;
    }

    UUID getOwner() {
        return this.owner;
    }
}

