/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.event.PaintEvent;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockContainerCommon;
import ic2.core.block.BlockPoleFence;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.BlockLuminatorMultipart;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockLuminator
extends BlockContainerCommon {
    public static int renderPass = 0;
    public static int colorMultiplier = -1;

    public BlockLuminator() {
        super(Material.field_151592_s);
        this.func_149672_a(field_149778_k);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.5f);
        this.func_149647_a(IC2.tabIC2);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return Ic2Icons.getTexture("b0")[31];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (renderPass == 0) {
            return super.func_149673_e(world, x, y, z, side);
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileEntityLuminator)) {
            return super.func_149673_e(world, x, y, z, side);
        }
        TileEntityLuminator luma = (TileEntityLuminator)tile;
        ItemStack item = luma.getGlass();
        if (item == null) {
            return super.func_149673_e(world, x, y, z, side);
        }
        Block id = Block.func_149634_a((Item)item.func_77973_b());
        int meta = item.func_77973_b().func_77647_b(item.func_77960_j());
        return id.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (colorMultiplier != -1) {
            return colorMultiplier;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator lumi = (TileEntityLuminator)tile;
            if (lumi.color != -1) {
                return ItemDye.field_150922_c[lumi.color];
            }
        }
        return 0xFFFFFF;
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        return par5;
    }

    public boolean func_149707_d(World world, int i, int j, int k, int direction) {
        if (!world.func_147437_c(i, j, k)) {
            return false;
        }
        switch (direction) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public static boolean isSupportingBlock(World world, int i, int j, int k) {
        return !world.func_147437_c(i, j, k) && (world.func_147445_c(i, j, k, true) || BlockLuminator.isSpecialSupporter((IBlockAccess)world, i, j, k));
    }

    public static boolean isSpecialSupporter(IBlockAccess world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        return !world.func_147437_c(i, j, k) && (block instanceof BlockFence || block instanceof BlockPoleFence || block instanceof BlockCable || block instanceof BlockLuminatorMultipart || block == Block.func_149634_a((Item)Ic2Items.reinforcedGlass.func_77973_b()) || block == Blocks.field_150359_w);
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && ((TileEntityLuminator)te).ignoreBlockStay) {
            return true;
        }
        int facing = world.func_72805_g(i, j, k);
        switch (facing) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public void func_149695_a(World world, int i, int j, int k, Block l) {
        if (!this.func_149718_j(world, i, j, k)) {
            if (!BlockLuminator.isGlass((IBlockAccess)world, i, j, k)) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)i, (double)j, (double)k, Ic2Items.luminator.func_77946_l()));
                }
                world.func_147468_f(i, j, k);
            }
        }
        super.func_149695_a(world, i, j, k, l);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("luminator");
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        float[] box = BlockLuminator.getBoxOfLuminator((IBlockAccess)world, i, j, k);
        return AxisAlignedBB.func_72330_a((double)(box[0] + (float)i), (double)(box[1] + (float)j), (double)(box[2] + (float)k), (double)(box[3] + (float)i), (double)(box[4] + (float)j), (double)(box[5] + (float)k));
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        float[] box = BlockLuminator.getBoxOfLuminator((IBlockAccess)world, i, j, k);
        return AxisAlignedBB.func_72330_a((double)(box[0] + (float)i), (double)(box[1] + (float)j), (double)(box[2] + (float)k), (double)(box[3] + (float)i), (double)(box[4] + (float)j), (double)(box[5] + (float)k));
    }

    public static float[] getBoxOfLuminator(IBlockAccess world, int i, int j, int k) {
        TileEntityLuminator luma;
        ItemStack item;
        TileEntityLuminator luma2;
        ItemStack item2;
        TileEntity tile;
        if (renderPass == 1 && (tile = world.func_147438_o(i, j, k)) instanceof TileEntityLuminator && (item2 = (luma2 = (TileEntityLuminator)tile).getGlass()) != null) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        boolean hasGlass = false;
        TileEntity tile2 = world.func_147438_o(i, j, k);
        if (tile2 instanceof TileEntityLuminator && (item = (luma = (TileEntityLuminator)tile2).getGlass()) != null) {
            hasGlass = true;
        }
        int facing = world.func_72805_g(i, j, k);
        float px = 0.0625f;
        float glass = hasGlass ? 0.01f : 0.0f;
        switch (facing) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        boolean fullCover = BlockLuminator.isSpecialSupporter(world, i, j, k);
        switch (facing) {
            case 1: {
                return new float[]{0.0f + glass, 0.0f, 0.0f + glass, 1.0f - glass, 1.0f * px, 1.0f - glass};
            }
            case 2: {
                if (fullCover) {
                    return new float[]{0.0f + glass, 0.0f + glass, 15.0f * px, 1.0f - glass, 1.0f - glass, 1.0f};
                }
                return new float[]{6.0f * px, 3.0f * px, 14.0f * px, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 1.0f};
            }
            case 3: {
                if (fullCover) {
                    return new float[]{0.0f + glass, 0.0f + glass, 0.0f, 1.0f - glass, 1.0f - glass, 1.0f * px};
                }
                return new float[]{6.0f * px, 3.0f * px, 0.0f, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 2.0f * px};
            }
            case 4: {
                if (fullCover) {
                    return new float[]{15.0f * px, 0.0f + glass, 0.0f + glass, 1.0f, 1.0f - glass, 1.0f - glass};
                }
                return new float[]{14.0f * px, 3.0f * px, 6.0f * px, 1.0f, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
            case 5: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f + glass, 0.0f + glass, 1.0f * px, 1.0f - glass, 1.0f - glass};
                }
                return new float[]{0.0f, 3.0f * px, 6.0f * px, 2.0f * px, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
        }
        if (fullCover) {
            return new float[]{0.0f + glass, 15.0f * px, 0.0f + glass, 1.0f - glass, 1.0f, 1.0f - glass};
        }
        return new float[]{4.0f * px, 13.0f * px, 4.0f * px, 1.0f - 4.0f * px, 1.0f, 1.0f - 4.0f * px};
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return renderPass;
    }

    @SubscribeEvent
    public void onColoring(PaintEvent event) {
        TileEntity tile = event.world.func_147438_o(event.x, event.y, event.z);
        if (!(tile instanceof TileEntityLuminator)) {
            return;
        }
        TileEntityLuminator lumi = (TileEntityLuminator)tile;
        if (lumi.color == event.color) {
            return;
        }
        lumi.setColor(event.color);
        event.painted = true;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        ItemStack itemStack = entityplayer.func_71045_bC();
        if (itemStack == null || !(itemStack.func_77973_b() instanceof IElectricItem)) {
            TileEntityLuminator lumi;
            if (itemStack == null) {
                TileEntityLuminator lumi2;
                if (entityplayer.func_70093_af() && (lumi2 = (TileEntityLuminator)world.func_147438_o(i, j, k)).getGlass() != null) {
                    if (!entityplayer.field_71071_by.func_70441_a(lumi2.getGlass())) {
                        entityplayer.func_70099_a(lumi2.getGlass(), 0.5f);
                    }
                    lumi2.setGlass(null);
                }
                return false;
            }
            if ((StackUtil.hasOreTag("blockGlass", itemStack) || itemStack.func_77969_a(Ic2Items.reinforcedGlass)) && (lumi = (TileEntityLuminator)world.func_147438_o(i, j, k)).getGlass() == null) {
                --itemStack.field_77994_a;
                ItemStack item = itemStack.func_77946_l();
                item.field_77994_a = 1;
                lumi.setGlass(item);
                entityplayer.field_71069_bz.func_75142_b();
                return true;
            }
            return false;
        }
        TileEntityLuminator lumi = (TileEntityLuminator)world.func_147438_o(i, j, k);
        int transfer = lumi.getMaxEnergy() - lumi.energy;
        if (transfer <= 0) {
            return false;
        }
        transfer = (int)ElectricItem.manager.discharge(itemStack, transfer, 10, true, true, false);
        lumi.energy += transfer;
        return true;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileEntityLuminator && ((TileEntityLuminator)tile).active && entity instanceof EntityMob) {
            entity.func_70015_d(entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD ? 20 : 10);
        }
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        float[] floats = BlockLuminator.getBoxOfLuminator(p_149719_1_, p_149719_2_, p_149719_3_, p_149719_4_);
        this.func_149676_a(floats[0], floats[1], floats[2], floats[3], floats[4], floats[5]);
    }

    public TileEntity createNewTileEntity(World world) {
        return new TileEntityLuminator();
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_0.png";
    }

    public void func_149666_a(Item i, CreativeTabs tabs, List itemList) {
        super.func_149666_a(i, tabs, itemList);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return this.createNewTileEntity(p_149915_1_);
    }

    @Override
    public void init() {
        Ic2Items.activeLuminator = new ItemStack((Block)this);
        Ic2Items.luminator = new ItemStack((Block)this);
    }

    public static boolean isGlass(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator luma = (TileEntityLuminator)tile;
            return luma.getGlass() != null;
        }
        return false;
    }

    public static ItemStack getGlass(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator luma = (TileEntityLuminator)tile;
            return luma.getGlass();
        }
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)tile).active ? 15 : 0;
        }
        return super.getLightValue(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        ItemStack item;
        Block block;
        TileEntityLuminator lumi;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminator && (lumi = (TileEntityLuminator)tile).getGlass() != null && (block = Block.func_149634_a((Item)(item = lumi.getGlass()).func_77973_b())) != Blocks.field_150350_a) {
            return block.func_149638_a(par1Entity);
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }
}

