/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.ContainerAdjustableTransformer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAdjustableTransformer
extends TileEntityBlock
implements IHasGui,
IEnergySink,
IMultiEnergySource,
IEnergyContainer,
INetworkClientTileEntityEventListener {
    public int energy;
    public int sinkTier = 6;
    public int packetCount = 1;
    public int energyPacket = 32;
    public int maxEnergy = 256;
    public boolean enet;

    public TileEntityAdjustableTransformer() {
        this.addGuiFields("energy", "maxEnergy", "packetCount", "energyPacket");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("Energy");
        this.packetCount = nbt.func_74762_e("Packet");
        this.energyPacket = nbt.func_74762_e("PacketEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("Packet", this.packetCount);
        nbt.func_74768_a("PacketEnergy", this.energyPacket);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.enet) {
            this.enet = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.isSimulating() && this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.enet = false;
        }
    }

    @Override
    public void setFacing(short side) {
        if (this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.enet = false;
        super.setFacing(side);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.enet = true;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }

    @Override
    public double getOfferedEnergy() {
        if (this.energyPacket > this.energy) {
            return 0.0;
        }
        return this.energyPacket;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
    }

    @Override
    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.energyPacket);
    }

    @Override
    public double getDemandedEnergy() {
        return Math.max(0, this.maxEnergy - this.energy);
    }

    @Override
    public int getSinkTier() {
        return this.sinkTier;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount > EnergyNet.instance.getPowerFromTier(this.sinkTier)) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return re;
    }

    @Override
    public boolean sendMultibleEnergyPackets() {
        return this.packetCount > 1;
    }

    @Override
    public int getMultibleEnergyPacketAmount() {
        return this.packetCount;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        int amount;
        if (event >= 0 && event <= 1) {
            amount = event == 0 ? 1 : 10;
            this.packetCount += amount;
            if (this.packetCount > 32) {
                this.packetCount = 32;
            }
            this.getNetwork().updateTileGuiField(this, "packetCount");
        }
        if (event >= 2 && event <= 3) {
            amount = event == 2 ? 1 : 10;
            this.packetCount -= amount;
            if (this.packetCount < 1) {
                this.packetCount = 1;
            }
            this.getNetwork().updateTileGuiField(this, "packetCount");
        }
        if (event >= 4 && event <= 7) {
            amount = event == 4 ? 1 : (event == 5 ? 10 : (event == 6 ? 100 : 1000));
            this.energyPacket += amount;
            if (this.energyPacket > Short.MAX_VALUE) {
                this.energyPacket = Short.MAX_VALUE;
            }
            this.maxEnergy = this.energyPacket * 32;
            this.getNetwork().updateTileGuiField(this, "energyPacket");
            this.getNetwork().updateTileGuiField(this, "maxEnergy");
        }
        if (event >= 8 && event <= 11) {
            amount = event == 8 ? 1 : (event == 9 ? 10 : (event == 10 ? 100 : 1000));
            this.energyPacket -= amount;
            if (this.energyPacket < 1) {
                this.energyPacket = 1;
            }
            this.maxEnergy = this.energyPacket * 32;
            if (this.energy > this.maxEnergy) {
                this.energy = this.maxEnergy;
                this.getNetwork().updateTileGuiField(this, "energy");
            }
            this.getNetwork().updateTileGuiField(this, "energyPacket");
            this.getNetwork().updateTileGuiField(this, "maxEnergy");
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return (int)EnergyNet.instance.getPowerFromTier(this.sinkTier);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerAdjustableTransformer(this, p0.field_71071_by);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.wiring.GuiAdjustableTransformer";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }
}

