/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import com.google.common.math.DoubleMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityChargePad;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.util.StackUtil;
import java.math.RoundingMode;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityChargePadNuclear
extends TileEntityChargePad {
    public int nuclearTicks = 0;
    public int energyProduct = 0;

    public TileEntityChargePadNuclear() {
        super(TileEntityChargePad.ChargePadType.Nuclear);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getMaxParticalAge() {
        return 14;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected float[] getParticalColour(Random rand) {
        float red = 0.9804688f;
        float green = 0.835938f;
        float blue = 0.1367188f;
        if (this.installedUpgrades[TileEntityChargePad.PadUpgrade.Drain.ordinal()]) {
            green /= 2.0f;
            blue /= 2.0f;
        }
        if (this.installedUpgrades[TileEntityChargePad.PadUpgrade.Damage.ordinal()]) {
            blue = 0.4f;
            green = 0.4f;
        } else {
            red *= 0.6f + rand.nextFloat() * 0.4f;
        }
        return new float[]{red, green *= 0.6f + rand.nextFloat() * 0.4f, blue *= 0.6f + rand.nextFloat() * 0.4f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected double[] getParticleVelocity(Random rand) {
        return new double[]{0.0, 7.6, 0.0};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getParticalAmount(Random rand) {
        return 6;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return Ic2Items.nuclearChargePad.func_77946_l();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.nuclearTicks = nbt.func_74762_e("NuclearTicks");
        this.energyProduct = nbt.func_74762_e("NuclearProduction");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("NuclearTicks", this.nuclearTicks);
        nbt.func_74768_a("NuclearProduction", this.energyProduct);
    }

    @Override
    public boolean provideEnergy() {
        int demanded;
        boolean up = super.provideEnergy();
        if (this.nuclearTicks > 0) {
            --this.nuclearTicks;
        }
        if ((demanded = DoubleMath.roundToInt((double)this.getDemandedEnergy(), (RoundingMode)RoundingMode.DOWN)) > 0) {
            if (this.nuclearTicks == 0) {
                ItemStack item = this.inv.func_70301_a(0);
                if (!this.useCell()) {
                    return up;
                }
                up = true;
                this.nuclearTicks = 20;
                this.energyProduct = this.getEnergy(item);
            }
            this.storedEnergy += this.energyProduct;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
        }
        return up;
    }

    private boolean isUraniumCell(ItemStack item) {
        return this.getEnergy(item) > 0;
    }

    private int getEnergy(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUranium) {
            return this.getEnergyFromCellAmount(((ItemReactorUranium)item).numberOfCells);
        }
        return 0;
    }

    private int getEnergyFromCellAmount(int cells) {
        switch (cells) {
            case 1: {
                return 5;
            }
            case 2: {
                return 20;
            }
            case 4: {
                return 60;
            }
        }
        return 0;
    }

    private boolean useCell() {
        ItemStack item = this.inv.func_70301_a(0);
        if (!this.isCell(item)) {
            return false;
        }
        if (item.func_77960_j() + 1 >= item.func_77958_k()) {
            this.inv.func_70299_a(0, this.createUsedCells(item));
        } else {
            item.func_77964_b(item.func_77960_j() + 1);
        }
        return true;
    }

    private ItemStack createUsedCells(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUranium && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            return StackUtil.copyWithSize(Ic2Items.nearDepletedUraniumCell, ((ItemReactorUranium)item).numberOfCells);
        }
        return null;
    }

    public boolean isCell(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemReactorUranium;
    }
}

