/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.ContainerCreativeStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCreativeStorage
extends TileEntityBlock
implements IMultiEnergySource,
IEnergyContainer,
INetworkClientTileEntityEventListener,
IHasGui {
    public int offer = 32;
    public int packets = 4;
    public byte step = 0;
    public boolean enet;

    public TileEntityCreativeStorage() {
        this.addGuiFields("offer", "packets");
    }

    @Override
    public double getOfferedEnergy() {
        return this.offer;
    }

    @Override
    public void drawEnergy(double amount) {
    }

    @Override
    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.offer);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public int getStoredEnergy() {
        return 0;
    }

    @Override
    public int getEnergyCapacity() {
        return 0;
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public int getEnergyProduction() {
        return this.offer * this.packets;
    }

    @Override
    public int getMaxEnergyInput() {
        return 0;
    }

    @Override
    public boolean sendMultibleEnergyPackets() {
        return this.packets > 1;
    }

    @Override
    public int getMultibleEnergyPacketAmount() {
        return this.packets;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (this.step == 0) {
            this.offer = event;
        } else if (this.step == 1) {
            this.packets = event;
        }
        this.step = (byte)(this.step + 1);
        if (this.step == 2) {
            this.step = 0;
            this.getNetwork().updateTileGuiField(this, "offer");
            this.getNetwork().updateTileGuiField(this, "packets");
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerCreativeStorage(this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.wiring.GuiCreativeStorage";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.offer = nbttagcompound.func_74762_e("energy");
        this.packets = nbttagcompound.func_74762_e("Packets");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.offer);
        nbttagcompound.func_74768_a("Packets", this.packets);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.enet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.enet = false;
        }
        super.onUnloaded();
    }
}

