/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.wiring.ContainerElectricBlock;
import ic2.core.block.wiring.IElectrolyzerProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityElectricBlock
extends TileEntityMachine
implements IEnergySink,
IEnergySourceInfo,
IHasGui,
ISidedInventory,
INetworkClientTileEntityEventListener,
IEnergyStorage,
IElectrolyzerProvider,
IEnergyContainer {
    public int tier;
    public int output;
    public int maxStorage;
    public int energy = 0;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)8;
    public boolean addedToEnergyNet = false;
    public int state = 0;
    public boolean emit = false;
    public boolean redstone;

    public TileEntityElectricBlock(int tierc, int outputc, int maxStoragec) {
        super(2);
        this.tier = tierc;
        this.output = outputc;
        this.maxStorage = maxStoragec;
        this.addNetworkFields("state");
        this.addGuiFields("energy");
    }

    public String getNameByTier() {
        switch (this.tier) {
            case 1: {
                return StatCollector.func_74838_a((String)"blockBatBox.name");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"blockMFE.name");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"blockMFSU.name");
            }
        }
        return null;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("state")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setActiveWithoutNotify(nbttagcompound.func_74767_n("active"));
        this.energy = nbttagcompound.func_74762_e("energy");
        if (this.maxStorage > Integer.MAX_VALUE) {
            this.energy *= 10;
        }
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
        this.state = nbttagcompound.func_74762_e("state");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        int write = this.energy;
        if (this.maxStorage > Integer.MAX_VALUE) {
            write /= 10;
        }
        nbttagcompound.func_74768_a("energy", write);
        nbttagcompound.func_74757_a("active", this.getActive());
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
        nbttagcompound.func_74768_a("state", this.state);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        int newState;
        super.func_145845_h();
        this.redstone = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean needsInvUpdate = false;
        boolean wasEmittingRedstone = this.isEmittingRedstone();
        if (this.energy > 0 && this.inventory[0] != null && (this.inventory[0].func_77973_b() instanceof IElectricItem || ElectricItem.getBackupManager(this.inventory[0]) != null)) {
            int sent = (int)ElectricItem.manager.charge(this.inventory[0], this.energy, this.tier, false, false);
            this.energy -= sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.getDemandedEnergy() > 0.0 && this.inventory[1] != null) {
            int gain;
            if (this.inventory[1].func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)this.inventory[1].func_77973_b();
                if (item.canProvideEnergy(this.inventory[1])) {
                    gain = (int)ElectricItem.manager.discharge(this.inventory[1], this.maxStorage - this.energy, this.tier, false, true, false);
                    this.energy += gain;
                    needsInvUpdate = gain > 0 || needsInvUpdate;
                }
            } else {
                Item id = this.inventory[1].func_77973_b();
                gain = 0;
                if (id == Items.field_151137_ax) {
                    gain = 500;
                }
                if (id == Ic2Items.suBattery.func_77973_b()) {
                    gain = 1000;
                }
                if (gain > 0 && gain <= this.maxStorage - this.energy) {
                    ItemStack itemStack = this.inventory[1];
                    --itemStack.field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                    this.energy += gain;
                    needsInvUpdate = true;
                }
            }
        }
        if ((newState = this.getUpdatedState()) != this.state) {
            this.state = newState;
            this.getNetwork().updateTileEntityField(this, "state");
        }
        boolean isFull = false;
        if (this.energy >= this.maxStorage) {
            isFull = true;
        }
        this.setActive(isFull);
        if (wasEmittingRedstone != this.isEmittingRedstone() || this.emit != this.isEmittingRedstone()) {
            this.updateNeighbors(true);
            this.emit = this.isEmittingRedstone();
        }
        if (needsInvUpdate) {
            this.func_70296_d();
            this.getNetwork().updateTileGuiField(this, "energy");
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public double getOfferedEnergy() {
        if (!(this.energy < this.output || this.redstoneMode == 6 && this.redstone || this.redstoneMode == 7 && this.redstone && this.energy < this.maxStorage)) {
            return this.output;
        }
        return 0.0;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        if (amount > (double)this.output) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxStorage) {
            re = this.energy - this.maxStorage;
            this.energy = this.maxStorage;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return re;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricBlock(entityPlayer.field_71071_by, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.wiring.GuiElectricBlock";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    public int getUpdatedState() {
        float charge = this.getChargeLevel();
        if ((double)charge <= 0.01) {
            return 0;
        }
        if ((double)charge >= 0.99) {
            return 3;
        }
        if ((double)charge < 0.5) {
            return 1;
        }
        return 2;
    }

    public boolean isEmittingRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy >= this.maxStorage;
            }
            case 2: {
                return this.energy > this.output && this.energy < this.maxStorage;
            }
            case 3: {
                return this.energy >= this.maxStorage / 2;
            }
            case 4: {
                return this.energy <= this.maxStorage / 2;
            }
            case 5: {
                return this.energy < this.output;
            }
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{1};
        }
        if (var1 == 1) {
            return new int[]{0};
        }
        return new int[0];
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        this.updateNeighbors(true);
        IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)("container.energyStorageRedstoneMode" + this.redstoneMode + ".name")));
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public void setStored(int energy) {
        this.energy = energy;
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int addEnergy(int amount) {
        this.energy += amount;
        this.getNetwork().updateTileGuiField(this, "energy");
        return amount;
    }

    public boolean isTeleporterCompatible(Direction side) {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return this.output;
    }

    @Override
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return true;
    }

    public void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.notifyBlocksOfNeighborChange(side);
        }
    }

    protected void notifyBlocksOfNeighborChange(ForgeDirection side) {
        this.field_145850_b.func_147459_d(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ, this.func_145838_q());
    }

    @Override
    public boolean hasTileMeta() {
        return true;
    }

    @Override
    public int getTileMeta() {
        return this.state;
    }

    @Override
    public int getProcessRate() {
        switch (this.tier) {
            default: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: 
        }
        return 32;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void drawPower(int amount) {
        this.energy = Math.max(this.energy - amount, 0);
    }

    @Override
    public void addPower(int amount) {
        this.energy = Math.min(this.energy + amount, this.maxStorage);
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int getStoredPower() {
        return this.energy;
    }

    @Override
    public int getMaxStorage() {
        return this.maxStorage;
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return (int)EnergyNet.instance.getPowerFromTier(this.tier);
    }
}

