/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.network.INetworkFieldData;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.tile.ISpecialWrenchable;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.util.Util;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLuminatorMultipart
extends TileEntityBlock
implements IEnergySink,
ISpecialWrenchable,
IEnergyConductorColored {
    public boolean[] lamps = new boolean[6];
    public byte[] connections = new byte[6];
    public byte[] emit = new byte[6];
    public int[] energy = new int[6];
    public int[] colors = new int[]{-1, -1, -1, -1, -1, -1};
    public int maxEnergy = 10000;
    public int current = 0;
    public int ticker = 0;
    public ItemStack cable;
    public IEnergyConductorColored.WireColor cableColor = IEnergyConductorColored.WireColor.Blank;
    public boolean addedToEnergyNet;
    public CableData data = new CableData();

    public TileEntityLuminatorMultipart() {
        this.addNetworkFields("connections", "lamps", "cable", "cableColor", "colors", "data", "emit");
    }

    public void func_145845_h() {
        if (this.ticker++ % 4 == 0) {
            for (int i = 0; i < 6; ++i) {
                if (!this.lamps[i]) continue;
                if (this.emit[i] == 1 && this.energy[i] <= 0 || this.emit[i] == 0 && this.energy[i] <= 0) {
                    this.emit[i] = 0;
                    continue;
                }
                if (this.emit[i] == 0 && this.energy[i] > 0) {
                    this.emit[i] = 1;
                }
                int n = i;
                this.energy[n] = this.energy[n] - 1;
            }
            boolean newActive = false;
            for (int i = 0; i < 6; ++i) {
                if (this.emit[i] != 1) continue;
                newActive = true;
                break;
            }
            this.setActive(newActive);
        }
    }

    public void onBlockChange() {
        byte[] array = new byte[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = EnergyNet.instance.getNeighbor(this, dir);
            if (tile == null) continue;
            array[dir.ordinal()] = (byte)(this.canInteractWith(tile, dir) ? 1 : 0);
        }
        if (!Util.match(this.connections, array)) {
            this.connections = array;
            this.getNetwork().updateTileEntityField(this, "connections");
        }
    }

    public boolean canConnect(int side) {
        return this.connections[side] == 1;
    }

    public boolean hasSide(int side) {
        return this.lamps[side];
    }

    public void addLamp(int side) {
        this.removeFromEnet();
        this.lamps[side] = true;
        this.addToEnet();
        this.getNetwork().updateTileEntityField(this, "lamps");
    }

    public boolean addColor(int side, int color) {
        if (this.hasSide(side)) {
            this.colors[side] = color;
            this.getNetwork().updateTileEntityField(this, "colors");
            return true;
        }
        if (this.canBeColored()) {
            this.removeFromEnet();
            this.cableColor = IEnergyConductorColored.WireColor.values()[color + 1];
            this.addToEnet();
            this.getNetwork().updateTileEntityField(this, "cableColor");
            return true;
        }
        return false;
    }

    public boolean canBeColored() {
        int meta = this.cable != null ? this.cable.func_77960_j() : 0;
        return meta == 0 || meta == 3 || meta == 4 || meta == 6 || meta == 7 || meta == 8 || meta == 14 || meta == 15;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("cable") || field.equals("lamps") || field.equals("colors") || field.equals("cableColor")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (field.equals("active")) {
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void setCable(ItemStack item, IEnergyConductorColored.WireColor color, int side) {
        this.cable = item;
        this.lamps[side] = true;
        this.cableColor = color;
        this.getNetwork().updateTileEntityField(this, "lamps");
        this.getNetwork().updateTileEntityField(this, "cable");
        this.getNetwork().updateTileEntityField(this, "cableColor");
    }

    public void updateTarget() {
        boolean found = false;
        while (!found) {
            ++this.current;
            if (this.current >= this.energy.length) {
                this.current = 0;
            }
            found = this.lamps[this.current];
        }
    }

    public void validateCableData() {
        if (this.cable != null) {
            TileEntityCable tile = new TileEntityCable((short)this.cable.func_77960_j());
            this.data.loss = tile.getConductionLoss();
            this.data.insolation = tile.getInsulationEnergyAbsorption();
            this.data.isoBreaking = tile.getInsulationBreakdownEnergy();
            this.data.conductorBreaking = tile.getConductorBreakdownEnergy();
        } else {
            this.data.loss = 0.0;
            this.data.insolation = 0.0;
            this.data.isoBreaking = 0.0;
            this.data.conductorBreaking = 0.0;
        }
        this.getNetwork().updateTileEntityField(this, "data");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.validateCableData();
        this.addToEnet();
    }

    @Override
    public void onUnloaded() {
        this.removeFromEnet();
        super.onUnloaded();
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (this.lamps[direction.ordinal()]) {
            return false;
        }
        return this.canConnect(direction.ordinal());
    }

    public void addToEnet() {
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    public void removeFromEnet() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (this.lamps[direction.ordinal()]) {
            return false;
        }
        return this.canConnect(direction.ordinal());
    }

    public boolean canInteractWith(TileEntity te, ForgeDirection dir) {
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof TileEntityLuminatorMultipart) {
            return !((TileEntityLuminatorMultipart)te).hasSide(dir.getOpposite().ordinal()) && this.canInteractWithAPICable((IEnergyConductorColored)te);
        }
        if (te instanceof IEnergyConductorColored) {
            return this.canInteractWithAPICable((IEnergyConductorColored)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).canCableConnectFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (te instanceof IEnergyAcceptor && !(te instanceof IEnergyEmitter)) {
            return ((IEnergyAcceptor)te).acceptsEnergyFrom(this, dir.getOpposite());
        }
        if (te instanceof IEnergyEmitter && !(te instanceof IEnergyAcceptor)) {
            return ((IEnergyEmitter)te).emitsEnergyTo(this, dir.getOpposite());
        }
        if (te instanceof IEnergyAcceptor && te instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)te).emitsEnergyTo(this, dir.getOpposite()) || ((IEnergyAcceptor)te).acceptsEnergyFrom(this, dir.getOpposite());
        }
        return te instanceof IMetaDelegate || te instanceof INetworkTileEntityEventListener;
    }

    public boolean canInteractWithAPICable(IEnergyConductorColored cable) {
        return this.cableColor == IEnergyConductorColored.WireColor.Blank || cable.getConductorColor() == IEnergyConductorColored.WireColor.Blank || this.cableColor == cable.getConductorColor();
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.cableColor == IEnergyConductorColored.WireColor.Blank || cable.color == IEnergyConductorColored.WireColor.Blank || this.cableColor == cable.color;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy[this.current];
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount > 32.0) {
            return 0.0;
        }
        if (amount <= 0.0) {
            return 0.0;
        }
        int energy = this.energy[this.current];
        energy = (int)((double)energy + amount);
        int re = 0;
        if (energy > this.maxEnergy) {
            re = energy - this.maxEnergy;
            energy = this.maxEnergy;
        }
        this.energy[this.current] = energy;
        this.updateTarget();
        return re;
    }

    @Override
    public double getConductionLoss() {
        return this.data.loss;
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        return this.data.insolation;
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        return this.data.isoBreaking;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.data.conductorBreaking;
    }

    @Override
    public void removeInsulation() {
        TileEntityCable tile = new TileEntityCable();
        int newType = 0;
        int type = this.cable.func_77973_b().func_77647_b(this.cable.func_77960_j());
        switch (type) {
            case 0: {
                newType = 1;
                break;
            }
            case 3: {
                newType = 2;
                break;
            }
            case 4: {
                newType = 3;
                break;
            }
            case 6: {
                newType = 5;
                break;
            }
            case 7: {
                newType = 6;
                break;
            }
            case 8: {
                newType = 7;
                break;
            }
            case 14: {
                newType = 13;
                break;
            }
            case 15: {
                newType = 14;
                break;
            }
            default: {
                newType = type;
            }
        }
        this.removeFromEnet();
        this.cable.func_77964_b(newType);
        if (!this.canBeColored()) {
            this.cableColor = IEnergyConductorColored.WireColor.Blank;
            this.getNetwork().updateTileEntityField(this, "cableColor");
        }
        this.addToEnet();
        this.getNetwork().updateTileEntityField(this, "cable");
    }

    @Override
    public void removeConductor() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean tryRemoveIsolation() {
        int meta = this.cable != null ? this.cable.func_77960_j() : 0;
        int target = 0;
        switch (meta) {
            case 0: {
                target = 1;
                break;
            }
            case 3: {
                target = 2;
                break;
            }
            case 4: {
                target = 3;
                break;
            }
            case 6: {
                target = 5;
                break;
            }
            case 7: {
                target = 6;
                break;
            }
            case 8: {
                target = 7;
                break;
            }
            case 14: {
                target = 13;
                break;
            }
            case 15: {
                target = 14;
                break;
            }
            default: {
                target = meta;
            }
        }
        if (meta != target) {
            if (this.isSimulating()) {
                this.removeFromEnet();
                this.cable.func_77964_b(target);
                if (!this.canBeColored()) {
                    this.cableColor = IEnergyConductorColored.WireColor.Blank;
                    this.getNetwork().updateTileEntityField(this, "cableColor");
                }
                this.addToEnet();
                this.getNetwork().updateTileEntityField(this, "cable");
            }
            return true;
        }
        return false;
    }

    public boolean tryAddIsolation() {
        int meta = this.cable != null ? this.cable.func_77960_j() : 0;
        int target = 0;
        switch (meta) {
            case 1: {
                target = 0;
                break;
            }
            case 2: {
                target = 3;
                break;
            }
            case 3: {
                target = 4;
                break;
            }
            case 5: {
                target = 6;
                break;
            }
            case 6: {
                target = 7;
                break;
            }
            case 7: {
                target = 8;
                break;
            }
            case 13: {
                target = 14;
                break;
            }
            case 14: {
                target = 15;
                break;
            }
            default: {
                target = meta;
            }
        }
        if (meta != target) {
            if (this.isSimulating()) {
                this.removeFromEnet();
                this.cable.func_77964_b(target);
                this.addToEnet();
                this.getNetwork().updateTileEntityField(this, "cable");
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cable = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Cable"));
        this.cableColor = IEnergyConductorColored.WireColor.values()[nbt.func_74762_e("CableColor")];
        this.current = nbt.func_74762_e("Current");
        this.connections = nbt.func_74770_j("Connect");
        this.emit = nbt.func_74770_j("Light");
        if (this.connections.length != 6) {
            this.connections = new byte[6];
        }
        if (this.emit.length != 6) {
            this.emit = new byte[6];
        }
        NBTTagList list = nbt.func_150295_c("Data", 10);
        this.energy = new int[6];
        this.colors = new int[6];
        this.lamps = new boolean[6];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte slot = data.func_74771_c("Slot");
            this.lamps[slot] = true;
            this.energy[slot] = data.func_74762_e("EnergyStored");
            this.colors[slot] = data.func_74762_e("Color");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound itemTag = new NBTTagCompound();
        if (this.cable != null) {
            this.cable.func_77955_b(itemTag);
        }
        nbt.func_74782_a("Cable", (NBTBase)itemTag);
        nbt.func_74768_a("CableColor", this.cableColor.ordinal());
        nbt.func_74768_a("Current", this.current);
        nbt.func_74773_a("Connect", this.connections);
        nbt.func_74773_a("Light", this.emit);
        NBTTagList list = new NBTTagList();
        for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            if (!this.lamps[i]) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", i);
            data.func_74768_a("EnergyStored", this.energy[i]);
            data.func_74768_a("Color", this.colors[i]);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean canDoSpecial(EntityPlayer player, int side) {
        return this.lamps[side];
    }

    @Override
    public boolean doSpecial(EntityPlayer player, int side) {
        if (this.lamps[side]) {
            this.lamps[side] = false;
            this.colors[side] = -1;
            if (!player.field_71075_bZ.field_75098_d) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, Ic2Items.luminatorMultipart.func_77946_l()));
            }
        }
        boolean found = false;
        for (int i = 0; i < 6; ++i) {
            if (!this.lamps[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            TileEntity tile;
            if (this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149634_a((Item)Ic2Items.copperCableBlock.func_77973_b()), this.cable.func_77960_j(), 3) && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e)) instanceof TileEntityCable) {
                ((TileEntityCable)tile).changeColor(this.cableColor);
            }
        } else {
            this.getNetwork().updateTileEntityField(this, "lamps");
            this.getNetwork().updateTileEntityField(this, "colors");
        }
        return true;
    }

    @Override
    public IEnergyConductorColored.WireColor getConductorColor() {
        return this.cableColor;
    }

    public ItemStack getDrop() {
        if (this.cable != null) {
            return this.cable.func_77946_l();
        }
        return new ItemStack(Ic2Items.copperCableItem.func_77973_b());
    }

    public class CableData
    implements INetworkFieldData {
        double loss;
        double insolation;
        double isoBreaking;
        double conductorBreaking;

        @Override
        public void read(DataInput stream) {
            try {
                this.loss = stream.readDouble();
                this.insolation = stream.readDouble();
                this.isoBreaking = stream.readDouble();
                this.conductorBreaking = stream.readDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void write(DataOutput stream) {
            try {
                stream.writeDouble(this.loss);
                stream.writeDouble(this.insolation);
                stream.writeDouble(this.isoBreaking);
                stream.writeDouble(this.conductorBreaking);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

