/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.energy.IPacketEnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.PacketStat;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.core.IC2;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.EnergyTransferList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

public class EnergyNetGlobal
implements IPacketEnergyNet {
    private static Map<World, EnergyNetLocal> worldToEnergyNetMap = new HashMap<World, EnergyNetLocal>();
    private static EventHandler eventHandler;

    @Override
    public TileEntity getTileEntity(World world, int x, int y, int z) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != null) {
            return local.getTileEntity(x, y, z);
        }
        return null;
    }

    @Override
    public TileEntity getNeighbor(TileEntity te, ForgeDirection dir) {
        if (te == null) {
            return null;
        }
        return this.getTileEntity(te.func_145831_w(), te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ);
    }

    @Override
    public double getTotalEnergyEmitted(TileEntity tileEntity) {
        if (tileEntity == null) {
            return 0.0;
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(tileEntity.func_145831_w());
        if (local != null) {
            return local.getTotalEnergyEmitted(tileEntity);
        }
        return 0.0;
    }

    @Override
    public double getTotalEnergySunken(TileEntity tileEntity) {
        if (tileEntity == null) {
            return 0.0;
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(tileEntity.func_145831_w());
        if (local != null) {
            return local.getTotalEnergySunken(tileEntity);
        }
        return 0.0;
    }

    @Override
    public double getPowerFromTier(int tier) {
        return 8 << tier * 2;
    }

    @Override
    public List<PacketStat> getSendedPackets(TileEntity par1) {
        if (par1 == null) {
            return new ArrayList<PacketStat>();
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(par1.func_145831_w());
        if (local != null) {
            return local.getSendedPackets(par1);
        }
        return new ArrayList<PacketStat>();
    }

    @Override
    public List<PacketStat> getTotalSendedPackets(TileEntity par1) {
        if (par1 == null) {
            return new ArrayList<PacketStat>();
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(par1.func_145831_w());
        if (local != null) {
            return local.getTotalSendedPackets(par1);
        }
        return new ArrayList<PacketStat>();
    }

    @Override
    public NodeStats getNodeStats(TileEntity te) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(te.func_145831_w());
        if (local == null) {
            return new NodeStats(0.0, 0.0, 0.0);
        }
        return local.getNodeStats(te);
    }

    @Override
    public int getTierFromPower(double power) {
        if (power <= 0.0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(power / 8.0) / Math.log(4.0));
    }

    public static EnergyNetLocal getForWorld(World world) {
        if (world == null) {
            IC2.log.warn("EnergyNet.getForWorld: world = null, bad things may happen..");
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new EnergyNetLocal(world));
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTickStart(World world) {
        EnergyNetLocal energyNet = EnergyNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickStart();
        }
    }

    public static void onTickEnd(World world) {
        EnergyNetLocal energyNet = EnergyNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    public static EnergyNetGlobal initialize() {
        eventHandler = new EventHandler();
        EnergyNetLocal.list = new EnergyTransferList();
        return new EnergyNetGlobal();
    }

    public static Map<Integer, List<AxisAlignedBB>> getBoxes() {
        HashMap<Integer, List<AxisAlignedBB>> boxes = new HashMap<Integer, List<AxisAlignedBB>>();
        for (Map.Entry<World, EnergyNetLocal> entry : worldToEnergyNetMap.entrySet()) {
            List<AxisAlignedBB> boundingbox = entry.getValue().getBoxes();
            if (boundingbox.isEmpty()) continue;
            boxes.put(entry.getKey().field_73011_w.field_76574_g, boundingbox);
        }
        return boxes;
    }

    public static class EventHandler {
        public EventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onEnergyTileLoad(EnergyTileLoadEvent event) {
            EnergyNetLocal local = EnergyNetGlobal.getForWorld(event.world);
            if (local != null) {
                local.addTile((TileEntity)event.energyTile);
            }
        }

        @SubscribeEvent
        public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
            EnergyNetLocal local = EnergyNetGlobal.getForWorld(event.world);
            if (local != null) {
                local.removeTile((TileEntity)event.energyTile);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            EnergyNetLocal local = (EnergyNetLocal)worldToEnergyNetMap.get(event.world);
            if (local != null) {
                local.onUnload();
            }
            IC2.network.get().onWorldUnload(event.world);
        }
    }
}

