/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.util.IElectricHelper;
import ic2.core.util.StackUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricItemManager
implements IElectricItemManager {
    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        assert (item.getMaxCharge(itemStack) > 0.0);
        if (amount < 0.0 || itemStack.field_77994_a > 1 || item.getTier(itemStack) > tier) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > item.getTransferLimit(itemStack)) {
            amount = item.getTransferLimit(itemStack);
        }
        NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(itemStack);
        int tNewCharge = tNBT.func_74762_e("charge");
        if (amount > item.getMaxCharge(itemStack) - (double)tNewCharge) {
            amount = item.getMaxCharge(itemStack) - (double)tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge = (int)((double)tNewCharge + amount)) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_150296_c().isEmpty()) {
                    itemStack.func_77982_d(null);
                }
            }
            itemStack.func_150996_a(tNewCharge > 0 ? item.getChargedItem(itemStack) : item.getEmptyItem(itemStack));
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b((int)(1.0 + (item.getMaxCharge(itemStack) - (double)tNewCharge) * (double)((long)itemStack.func_77958_k() - 2L) / item.getMaxCharge(itemStack)));
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externalUse, boolean simulate) {
        NBTTagCompound tNBT;
        int tNewCharge;
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        assert (item.getMaxCharge(itemStack) > 0.0);
        if (amount < 0.0 || itemStack.field_77994_a > 1 || item.getTier(itemStack) > tier) {
            return 0.0;
        }
        if (externalUse && !item.canProvideEnergy(itemStack)) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > item.getTransferLimit(itemStack)) {
            amount = item.getTransferLimit(itemStack);
        }
        if (amount > (double)(tNewCharge = (tNBT = StackUtil.getOrCreateNbtData(itemStack)).func_74762_e("charge"))) {
            amount = tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge = (int)((double)tNewCharge - amount)) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_150296_c().isEmpty()) {
                    itemStack.func_77982_d(null);
                }
            }
            itemStack.func_150996_a((double)tNewCharge > 0.0 ? item.getChargedItem(itemStack) : item.getEmptyItem(itemStack));
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b((int)(1.0 + (item.getMaxCharge(itemStack) - (double)tNewCharge) * (double)((long)itemStack.func_77958_k() - 2L) / item.getMaxCharge(itemStack)));
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, false, true);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return ElectricItem.manager.getCharge(itemStack) >= this.applyEnchantmentEffect(itemStack, amount);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        amount = this.applyEnchantmentEffect(itemStack, amount);
        ElectricItem.manager.chargeFromArmor(itemStack, entity);
        double transfer = ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, true);
        if ((int)transfer == (int)amount) {
            ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
            ElectricItem.manager.chargeFromArmor(itemStack, entity);
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating() || entity == null) {
            return;
        }
        boolean inventoryChanged = false;
        if (entity instanceof EntityPlayer && IC2.modul.containsKey("Baubles Modul")) {
            inventoryChanged = ((IElectricHelper)((Object)IC2.modul.get("Baubles Modul"))).chargeFromArmor(itemStack, (EntityPlayer)entity);
        }
        for (int i = 0; i < 4; ++i) {
            IElectricItem armorItem;
            ItemStack armorItemStack = entity.func_71124_b(i + 1);
            if (armorItemStack == null || !(armorItemStack.func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) continue;
            double transfer = ElectricItem.manager.charge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, true);
            if (!((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            ElectricItem.manager.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        return ElectricItem.manager.getCharge(itemStack) + "/" + item.getMaxCharge(itemStack) + " EU";
    }

    public double applyEnchantmentEffect(ItemStack item, double amount) {
        double effect;
        int level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)item);
        if (level > 0) {
            effect = 1.0 + 0.15 * (double)level;
            amount *= effect;
        }
        if ((level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)item)) > 0) {
            effect = 1.0 - 0.1 * (double)level;
            amount *= effect;
        }
        return amount;
    }
}

