/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.armor.ItemArmorUtility;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemArmorJetpack
extends ItemArmorUtility {
    public static AudioSource audioSource;
    private static boolean lastJetpackUsed;
    private static JetpackUseMode lastMode;

    public ItemArmorJetpack(int spriteIndex, int armorrendering) {
        super(spriteIndex, armorrendering, 1);
        this.func_77656_e(18002);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        ItemStack stack = this.getArmor(armor);
        if (stack != null) {
            ItemArmor item = (ItemArmor)stack.func_77973_b();
            return new ISpecialArmor.ArmorProperties(0, (double)item.field_77879_b / 25.0, armor.func_77958_k() + 1 - stack.func_77960_j());
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        ItemStack stack = this.getArmor(armor);
        if (stack != null) {
            ItemArmor item = (ItemArmor)stack.func_77973_b();
            return item.field_77879_b;
        }
        return super.getArmorDisplay(player, armor, slot);
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ItemStack armor = this.getArmor(stack);
        if (armor != null) {
            armor.func_77972_a(damage, entity);
            if (armor.field_77994_a <= 0) {
                this.addJetpackArmor(stack, null);
            }
        }
        super.damageArmor(entity, stack, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1, EntityPlayer p_77624_2_, List par3, boolean p_77624_4_) {
        ItemStack stack;
        NBTTagCompound data = StackUtil.getOrCreateNbtData(par1);
        if (data.func_74767_n("RocketMode")) {
            int usedEnergy = data.func_74762_e("UsedEnergy");
            int result = (int)((double)usedEnergy / (double)this.getMaxRocketCharge() * 100.0);
            par3.add(StatCollector.func_74837_a((String)"itemInfo.nuclearJetpackRocketCharge.name", (Object[])new Object[]{result + "%"}));
            par3.add("");
        }
        if ((stack = this.getArmor(par1)) != null) {
            par3.add(StatCollector.func_74837_a((String)"itemInfo.jetpackArmor.name", (Object[])new Object[]{stack.func_82833_r()}));
            par3.add(StatCollector.func_74837_a((String)"itemInfo.armorDurablity.name", (Object[])new Object[]{stack.func_77960_j(), stack.func_77958_k()}));
            par3.add("");
        }
    }

    public int getCharge(ItemStack itemStack) {
        int ret = (int)(this.getMaxCharge(itemStack) - (double)itemStack.func_77960_j() - 1.0);
        return ret > 0 ? ret : 0;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return itemStack.func_77958_k() - 2;
    }

    public void use(ItemStack itemStack, int amount) {
        int newCharge = this.getCharge(itemStack) - amount;
        if (newCharge < 0) {
            newCharge = 0;
        }
        itemStack.func_77964_b(1 + itemStack.func_77958_k() - newCharge);
    }

    public JetpackUseMode useJetpack(EntityPlayer player, HoverMode hoverMode) {
        int maxFlightHeight;
        double y;
        float retruster;
        float forwardpower;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) == 0) {
            return JetpackUseMode.None;
        }
        JetpackUseMode mode = JetpackUseMode.Full;
        boolean electric = this.isElectricJetpack();
        float power = this.getPower();
        float dropPercentage = this.getDropPercentage();
        if ((double)this.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * ((double)this.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
            mode = JetpackUseMode.Dropped;
        }
        if (IC2.keyboard.isForwardKeyDown(player) && (forwardpower = power * (retruster = this.getThruster(hoverMode)) * 2.0f) > 0.0f) {
            player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
        }
        if ((y = player.field_70163_u) > (double)((maxFlightHeight = this.getMaxHeight(IC2.getWorldHeight(player.field_70170_p))) - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power *= (float)(((double)maxFlightHeight - y) / 25.0);
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode != HoverMode.None) {
            float maxHoverY;
            float f = hoverMode == HoverMode.Basic ? -0.1f : (maxHoverY = player.func_70093_af() ? -0.2f : 0.0f);
            if (electric && IC2.keyboard.isJumpKeyDown(player)) {
                float f2 = hoverMode == HoverMode.Basic ? 0.1f : (maxHoverY = hoverMode == HoverMode.Adv ? 0.3f : 0.6f);
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        this.use(jetpack, this.getFuelCost(hoverMode));
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return mode;
    }

    private boolean chargeRocketMode(EntityPlayer player) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) == 0) {
            return false;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(jetpack);
        int chargedEnergy = nbtData.func_74762_e("UsedEnergy");
        if (chargedEnergy > this.getMaxRocketCharge()) {
            return false;
        }
        int fuelCost = this.getFuelCost(HoverMode.None) * 5;
        int used = Math.min(fuelCost, this.getCharge(jetpack));
        this.use(jetpack, used);
        nbtData.func_74768_a("UsedEnergy", chargedEnergy += used);
        return true;
    }

    private void checkRocketCharge(ItemStack jetpack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(jetpack);
        if (nbt.func_74764_b("UsedEnergy")) {
            nbt.func_82580_o("UsedEnergy");
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        HoverMode hoverMode = HoverMode.values()[nbtData.func_74771_c("hoverMode")];
        boolean rocketMode = nbtData.func_74767_n("RocketMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        short rocketDelay = nbtData.func_74765_d("RocketDelay");
        boolean jetpackUsed = false;
        JetpackUseMode mode = JetpackUseMode.None;
        if (rocketMode && !this.canDoRocketMode()) {
            nbtData.func_74757_a("RocketMode", false);
        }
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            hoverMode = this.getNextHoverMode(hoverMode);
            if (IC2.platform.isSimulating()) {
                nbtData.func_74774_a("hoverMode", (byte)hoverMode.ordinal());
                if (hoverMode == HoverMode.Basic || hoverMode == HoverMode.Adv) {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)(hoverMode == HoverMode.Basic ? "itemInfo.jetpackHovermodeOn.name" : "itemInfo.jetpackAdvHoverModeOn.name")));
                    if (rocketMode) {
                        rocketMode = false;
                        nbtData.func_74757_a("RocketMode", rocketMode);
                        IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackRocketModeForcedOff.name"));
                        this.checkRocketCharge(itemStack);
                    }
                } else {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackHovermodeOff.name"));
                }
            }
        }
        if (IC2.keyboard.isModeSwitchKeyDown(player) && IC2.keyboard.isBoostKeyDown(player) && this.canDoRocketMode() && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = rocketMode = !rocketMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("RocketMode", rocketMode);
                if (rocketMode) {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackRocketModeOn.name"));
                    if (hoverMode != HoverMode.None) {
                        hoverMode = HoverMode.None;
                        nbtData.func_74774_a("hoverMode", (byte)hoverMode.ordinal());
                        IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackHovermodeForcedOff.name"));
                    }
                } else {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.jetpackRocketModeOff.name"));
                    this.checkRocketCharge(itemStack);
                }
            }
        }
        if (rocketMode && IC2.keyboard.isBoostKeyDown(player) && rocketDelay <= 0) {
            jetpackUsed = this.chargeRocketMode(player);
            mode = JetpackUseMode.Full;
        }
        if (IC2.keyboard.isAltKeyDown(player) && rocketMode && rocketDelay <= 0) {
            rocketDelay = (short)this.releaseRocket(player);
            nbtData.func_74757_a("RocketMode", false);
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (IC2.keyboard.isJumpKeyDown(player) && !rocketMode && rocketDelay <= 0 || hoverMode == HoverMode.Basic && player.field_70181_x < (double)-0.35f || hoverMode == HoverMode.Adv) {
            mode = this.useJetpack(player, hoverMode);
            boolean bl = jetpackUsed = mode != JetpackUseMode.None;
        }
        if (IC2.platform.isSimulating()) {
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.func_74774_a("toggleTimer", toggleTimer);
            }
            if (rocketDelay > 0) {
                rocketDelay = (short)(rocketDelay - 1);
                nbtData.func_74777_a("RocketDelay", rocketDelay);
            }
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed || lastMode != mode) {
                if (lastMode != mode && audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource(player, PositionSpec.Backpack, mode == JetpackUseMode.Full ? "Tools/Jetpack/JetpackLoop.ogg" : "Tools/Jetpack/JetpackFire.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
                lastMode = mode;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
    }

    public int releaseRocket(EntityPlayer player) {
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(jetpack);
        int charge = nbt.func_74762_e("UsedEnergy");
        if (charge <= 0) {
            return 0;
        }
        nbt.func_74768_a("UsedEnergy", 0);
        this.use(jetpack, 50);
        int charges = charge / this.getFuelCost(HoverMode.None);
        float speed = this.getPower() * (float)(charges /= 50);
        player.field_70181_x += (double)Math.min(speed /= 4.0f, 10.0f);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return (int)(speed * 10.0f);
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        itemList.add(new ItemStack((Item)this, 1, 1));
    }

    @Override
    public String getTextureName() {
        return "jetpack_fuel";
    }

    public float getDropPercentage() {
        return 0.5f;
    }

    public float getPower() {
        return 1.0f;
    }

    public boolean isElectricJetpack() {
        return false;
    }

    public int getFuelCost(HoverMode hoverMode) {
        return hoverMode == HoverMode.Basic ? 6 : 9;
    }

    public int getMaxHeight(int worldHight) {
        return worldHight;
    }

    public float getThruster(HoverMode hoverMode) {
        return hoverMode == HoverMode.Basic ? 0.5f : 0.15f;
    }

    public boolean canDoRocketMode() {
        return false;
    }

    public boolean canDoAdvHover() {
        return false;
    }

    public int getMaxRocketCharge() {
        return 0;
    }

    public void addJetpackArmor(ItemStack jetpack, ItemStack armor) {
        if (armor == null) {
            NBTTagCompound data = StackUtil.getOrCreateNbtData(jetpack);
            data.func_82580_o("JetpackArmor");
            return;
        }
        FMLLog.getLogger().info("Test");
        NBTTagCompound data = new NBTTagCompound();
        armor.func_77955_b(data);
        jetpack.func_77983_a("JetpackArmor", (NBTBase)data);
    }

    public ItemStack getArmor(ItemStack jetpack) {
        NBTTagCompound data = StackUtil.getOrCreateNbtData(jetpack);
        if (data.func_74764_b("JetpackArmor")) {
            return ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("JetpackArmor"));
        }
        return null;
    }

    public boolean hasJetpackOverrideRequest(ItemStack par1) {
        return StackUtil.getOrCreateNbtData(par1).func_74764_b("JOverride");
    }

    public void setJetpackOverrideRequest(ItemStack par1, boolean par2) {
        NBTTagCompound data = StackUtil.getOrCreateNbtData(par1);
        if (par2) {
            data.func_74757_a("JOverride", true);
            return;
        }
        data.func_82580_o("JOverride");
    }

    private HoverMode getNextHoverMode(HoverMode old) {
        if (old == HoverMode.Basic && this.canDoAdvHover()) {
            return HoverMode.Adv;
        }
        if (old == HoverMode.None) {
            return HoverMode.Basic;
        }
        return HoverMode.None;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        boolean hasArmor = this.hasArmor(stack);
        if (!hasArmor || GuiScreen.func_146271_m()) {
            return super.getIcon(stack, 0);
        }
        if (pass == 1) {
            return Ic2Icons.getTexture("i2")[45];
        }
        return this.getArmor(stack).func_77954_c();
    }

    private boolean hasArmor(ItemStack stack) {
        return this.getArmor(stack) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    static {
        lastJetpackUsed = false;
        lastMode = JetpackUseMode.None;
    }

    public static enum JetpackUseMode {
        Full,
        Dropped,
        None;

    }

    public static enum HoverMode {
        None,
        Basic,
        Adv;

    }
}

