/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.item.armor.ItemArmorElectric;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorNanoSuit
extends ItemArmorElectric
implements IMetalArmor {
    public ItemArmorNanoSuit(int index, int armorrendering, int armorType) {
        super(index, armorrendering, armorType, 100000, 160, 2);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, true, true) / (double)energyPerDamage : 0.0);
            float absorbtion = damage < 8.0 ? 1.0f : 0.875f;
            return new ISpecialArmor.ArmorProperties(10, (double)(absorbtion *= IC2.electricSuitAbsorbtionScale), damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IC2.platform.isSimulating() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack armor = player.field_71071_by.field_70460_b[0];
            if (armor != null && armor.func_77973_b() == this) {
                int fallDamage = (int)event.distance - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int energyCost = this.getEnergyPerDamage() * fallDamage;
                if ((double)energyCost <= ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, true, true)) {
                    ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, true, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getEnergyPerDamage() {
        return 800;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    public String getTextureName() {
        return "nano";
    }
}

