/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.IItemTickListener;
import ic2.core.Ic2Items;
import ic2.core.item.ItemTinCan;
import ic2.core.item.armor.ItemArmorElectric;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorQuantumSuit
extends ItemArmorElectric
implements IMetalArmor,
IItemTickListener {
    public static Map<EntityPlayer, Integer> speedTickerMap = new HashMap<EntityPlayer, Integer>();
    public static Map<EntityPlayer, Float> jumpChargeMap = new HashMap<EntityPlayer, Float>();
    public static Map<EntityPlayer, Boolean> enableQuantumSpeedOnSprintMap = new HashMap<EntityPlayer, Boolean>();

    public ItemArmorQuantumSuit(int index, int armorrendering, int armorType) {
        super(index, armorrendering, armorType, 1000000, 1000, 3);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public boolean isBlockingEverything() {
        return true;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (double)energyPerDamage : 0.0);
            return new ISpecialArmor.ArmorProperties(10, (double)(1.0f * IC2.electricSuitAbsorbtionScale), damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IC2.platform.isSimulating() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack armor = player.field_71071_by.field_70460_b[0];
            if (armor != null && armor.func_77973_b() == this) {
                int fallDamage = (int)event.distance - 3;
                int energyCost = this.getEnergyPerDamage() * fallDamage;
                if ((double)energyCost <= ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true)) {
                    ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == 1) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 900;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    @Override
    public boolean onTick(EntityPlayer player, ItemStack itemStack) {
        boolean ret = false;
        switch (this.field_77881_a) {
            case 0: {
                PotionEffect wither;
                PotionEffect radiation;
                int air = player.func_70086_ai();
                if (ElectricItem.manager.canUse(itemStack, 1000.0) && air < 100) {
                    player.func_70050_g(air + 200);
                    ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.manager.canUse(itemStack, 1000.0) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != Ic2Items.filledTinCan.func_77973_b()) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemTinCan can = (ItemTinCan)player.field_71071_by.field_70462_a[slot].func_77973_b();
                        player.func_71024_bL().func_75122_a(can.func_150905_g(player.field_71071_by.field_70462_a[slot]), can.func_150906_h(player.field_71071_by.field_70462_a[slot]));
                        can.onCanEaten(player.field_71071_by.field_70462_a[slot], player.field_70170_p, player);
                        ItemStack itemStack2 = player.field_71071_by.field_70462_a[slot];
                        if (--itemStack2.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[slot] = null;
                        }
                        ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
                        ret = true;
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                PotionEffect poison = player.func_70660_b(Potion.field_76436_u);
                if (poison != null && ElectricItem.manager.canUse(itemStack, 10000 * poison.func_76458_c())) {
                    ElectricItem.manager.use(itemStack, 10000 * poison.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76436_u.field_76415_H);
                }
                if ((radiation = player.func_70660_b((Potion)IC2Potion.radiation)) != null && ElectricItem.manager.canUse(itemStack, 20000 * radiation.func_76458_c())) {
                    ElectricItem.manager.use(itemStack, 20000 * radiation.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, IC2Potion.radiation.field_76415_H);
                }
                if ((wither = player.func_70660_b(Potion.field_82731_v)) == null || !ElectricItem.manager.canUse(itemStack, 25000 * wither.func_76458_c())) break;
                ElectricItem.manager.use(itemStack, 25000 * wither.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, Potion.field_82731_v.field_76415_H);
                break;
            }
            case 1: {
                player.func_70015_d(0);
                break;
            }
            case 2: {
                int speedTicker;
                boolean enableQuantumSpeedOnSprint = true;
                if (IC2.platform.isRendering()) {
                    enableQuantumSpeedOnSprint = IC2.enableQuantumSpeedOnSprint;
                } else if (enableQuantumSpeedOnSprintMap.containsKey(player)) {
                    enableQuantumSpeedOnSprint = enableQuantumSpeedOnSprintMap.get(player);
                }
                if (!(ElectricItem.manager.canUse(itemStack, 1000.0) && player.field_70122_E && Math.abs(player.field_70159_w) + Math.abs(player.field_70179_y) > 0.1000000014901161 && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) && (!player.func_70090_H() || (!enableQuantumSpeedOnSprint || !player.func_70051_ag()) && (enableQuantumSpeedOnSprint || !IC2.keyboard.isBoostKeyDown(player)))) break;
                int n = speedTicker = speedTickerMap.containsKey(player) ? speedTickerMap.get(player) : 0;
                if (++speedTicker >= 10) {
                    speedTicker = 0;
                    ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
                    ret = true;
                }
                speedTickerMap.put(player, speedTicker);
                float speed = 0.22f;
                if (player.func_70090_H()) {
                    speed = 0.1f;
                }
                if (!(speed > 0.0f)) break;
                player.func_70060_a(0.0f, 1.0f, speed);
                break;
            }
            case 3: {
                float jumpCharge;
                float f = jumpCharge = jumpChargeMap.containsKey(player) ? jumpChargeMap.get(player).floatValue() : 1.0f;
                if (ElectricItem.manager.canUse(itemStack, 1000.0) && player.field_70122_E && jumpCharge < 1.0f) {
                    jumpCharge = 1.0f;
                    ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
                    ret = true;
                }
                if (player.field_70181_x >= 0.0 && jumpCharge > 0.0f && !player.func_70090_H()) {
                    if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        if (jumpCharge == 1.0f) {
                            player.field_70159_w *= 3.5;
                            player.field_70179_y *= 3.5;
                        }
                        player.field_70181_x += (double)(jumpCharge * 0.3f);
                        jumpCharge *= 0.75f;
                    } else if (jumpCharge < 1.0f) {
                        jumpCharge = 0.0f;
                    }
                }
                jumpChargeMap.put(player, Float.valueOf(jumpCharge));
                break;
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean func_82816_b_(ItemStack aStack) {
        return this.func_82814_b(aStack) != 10511680;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int par2) {
        return this.func_77617_a(par1);
    }

    public void func_82815_c(ItemStack par1ItemStack) {
        NBTTagCompound tNBT = par1ItemStack.func_77978_p();
        if (tNBT != null && (tNBT = tNBT.func_74775_l("display")).func_74764_b("color")) {
            tNBT.func_82580_o("color");
        }
    }

    public int func_82814_b(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            return 10511680;
        }
        return (tNBT = tNBT.func_74775_l("display")).func_74764_b("color") ? tNBT.func_74762_e("color") : (tNBT == null ? 10511680 : 10511680);
    }

    public void colorQArmor(ItemStack aStack, int par2) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
            aStack.func_77982_d(tNBT);
        }
        if (!tNBT.func_74764_b("display")) {
            tNBT.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        tNBT = tNBT.func_74775_l("display");
        tNBT.func_74768_a("color", par2);
    }

    public void func_82813_b(ItemStack p_82813_1_, int p_82813_2_) {
        this.colorQArmor(p_82813_1_, p_82813_2_);
    }

    @Override
    public String getTextureName() {
        return "quantum";
    }
}

