/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.boats;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityClassicBoat
extends Entity {
    private boolean isBoatEmpty = true;
    private double speedMultiplier = 0.07;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private static final String __OBFID = "CL_00001667";

    public EntityClassicBoat(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.6f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityClassicBoat(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.field_70178_ae && source.func_76347_k()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + damage * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (!flag) {
                    this.onPlayerBreaking();
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int p_70056_9_) {
        if (this.isBoatEmpty) {
            this.boatPosRotationIncrements = p_70056_9_ + 5;
        } else {
            double d3 = x - this.field_70165_t;
            double d4 = y - this.field_70163_u;
            double d5 = z - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.boatPosRotationIncrements = 3;
        }
        this.boatX = x;
        this.boatY = y;
        this.boatZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        double d12;
        double d11;
        int j;
        double d4;
        double d2;
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int b0 = 5;
        double d0 = 0.0;
        for (int i = 0; i < b0; ++i) {
            double minY = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(i + 0) / (double)b0 - 0.125;
            double maxY = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(i + 1) / (double)b0 - 0.125;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)minY, (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)maxY, (double)this.field_70121_D.field_72334_f);
            if (!this.isOnWater(box)) continue;
            d0 += 1.0 / (double)b0;
        }
        double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (d10 > 0.26249999999999996) {
            d2 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            d4 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            j = 0;
            while ((double)j < 1.0 + d10 * 60.0) {
                double d9;
                double d8;
                double d5 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double d6 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    d8 = this.field_70165_t - d2 * d5 * 0.8 + d4 * d6;
                    d9 = this.field_70161_v - d4 * d5 * 0.8 - d2 * d6;
                    this.field_70170_p.func_72869_a("splash", d8, this.field_70163_u - 0.125, d9, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else {
                    d8 = this.field_70165_t + d2 + d4 * d5 * 0.7;
                    d9 = this.field_70161_v + d4 - d2 * d5 * 0.7;
                    this.field_70170_p.func_72869_a("splash", d8, this.field_70163_u - 0.125, d9, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                ++j;
            }
        }
        if (this.field_70170_p.field_72995_K && this.isBoatEmpty) {
            if (this.boatPosRotationIncrements > 0) {
                d2 = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                d4 = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                d11 = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                d12 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d12 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(d2, d4, d11);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                d2 = this.field_70165_t + this.field_70159_w;
                d4 = this.field_70163_u + this.field_70181_x;
                d11 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d2, d4, d11);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
        } else {
            if (d0 < 1.0) {
                d2 = d0 * 2.0 - 1.0;
                this.field_70181_x += (double)0.04f * d2;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f;
            }
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)this.field_70153_n;
                float f = this.field_70153_n.field_70177_z + -entitylivingbase.field_70702_br * 90.0f;
                double maxSpeed = this.getSpeed(entitylivingbase);
                double lastX = this.field_70159_w;
                double lastZ = this.field_70179_y;
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
                if (lastX - this.field_70159_w != 0.0 || lastZ - this.field_70179_y != 0.0) {
                    this.field_70177_z = (this.field_70153_n.field_70177_z - 90.0f) % 360.0f;
                }
            } else if (this.hasAfkSpeed()) {
                float f = this.field_70177_z + 90.0f;
                double maxSpeed = this.getAfkSpeed();
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * maxSpeed * (double)0.05f;
            }
            d2 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d2 > this.getTopSpeed()) {
                d4 = this.getTopSpeed() / d2;
                this.field_70159_w *= d4;
                this.field_70179_y *= d4;
                d2 = this.getTopSpeed();
            }
            if (d2 > d10 && this.speedMultiplier < 0.35) {
                this.speedMultiplier += (0.35 - this.speedMultiplier) / 35.0;
                if (this.speedMultiplier > 0.35) {
                    this.speedMultiplier = 0.35;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / 35.0;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            for (int l = 0; l < 4; ++l) {
                int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 0.8));
                j = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 0.8));
                for (int j1 = 0; j1 < 2; ++j1) {
                    int k = MathHelper.func_76128_c((double)this.field_70163_u) + j1;
                    Block block = this.field_70170_p.func_147439_a(i1, k, j);
                    if (block == Blocks.field_150431_aC) {
                        this.field_70170_p.func_147468_f(i1, k, j);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_147480_a(i1, k, j, true);
                    this.field_70123_F = false;
                }
            }
            if (this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && d10 > this.getMaxRammingSpeed()) {
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.onRammingBreaking(d10);
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            this.field_70125_A = 0.0f;
            d11 = this.field_70159_w;
            d12 = this.field_70179_y;
            if (d11 * d11 + d12 * d12 > 0.001) {
                double d = (float)(Math.atan2(d12, d11) * 180.0 / Math.PI);
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(this.field_70177_z));
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (int k1 = 0; k1 < list.size(); ++k1) {
                        Entity entity = (Entity)list.get(k1);
                        if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityBoat) && !(entity instanceof EntityClassicBoat)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
            } else {
                this.func_70101_b(this.field_70180_af.func_111145_d(16), this.field_70125_A);
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70177_z = this.field_70180_af.func_111145_d(16);
            double d0 = Math.cos((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            double d1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + d0, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + d1);
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_130002_c(EntityPlayer p_130002_1_) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != p_130002_1_) {
            return false;
        }
        if (!p_130002_1_.func_70093_af() && !this.field_70170_p.field_72995_K) {
            p_130002_1_.func_70078_a((Entity)this);
        }
        return true;
    }

    protected void func_70064_a(double p_70064_1_, boolean p_70064_3_) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (p_70064_3_) {
            if (this.field_70143_R > 3.0f) {
                this.func_70069_a(this.field_70143_R);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.onFallingBreaking(this.field_70143_R);
                    this.func_70106_y();
                }
                this.field_70143_R = 0.0f;
            }
        } else if (this.field_70170_p.func_147439_a(i, j - 1, k).func_149688_o() != Material.field_151586_h && p_70064_1_ < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - p_70064_1_);
        }
    }

    public void setDamageTaken(float p_70266_1_) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(p_70266_1_));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int p_70265_1_) {
        this.field_70180_af.func_75692_b(17, (Object)p_70265_1_);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int p_70269_1_) {
        this.field_70180_af.func_75692_b(18, (Object)p_70269_1_);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsBoatEmpty(boolean p_70270_1_) {
        this.isBoatEmpty = p_70270_1_;
    }

    public float getSpeed(EntityLivingBase base) {
        return base.field_70701_bs;
    }

    public boolean hasAfkSpeed() {
        return false;
    }

    public float getAfkSpeed() {
        return 0.0f;
    }

    public void onPlayerBreaking() {
        this.func_70099_a(this.getItem(), 0.0f);
    }

    public void onFallingBreaking(float fallingDistance) {
    }

    public void onRammingBreaking(double speed) {
    }

    public double getMaxRammingSpeed() {
        return 0.2;
    }

    public double getTopSpeed() {
        return 0.35;
    }

    protected boolean isOnWater(AxisAlignedBB aabb) {
        return this.field_70170_p.func_72830_b(aabb, Material.field_151586_h);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return this.getItem();
    }

    protected ResourceLocation createBase(String par1) {
        return new ResourceLocation("ic2", "textures/models/boat/" + par1 + ".png");
    }

    public abstract ItemStack getItem();

    public abstract ResourceLocation getTexture();
}

