/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.boats;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.item.boats.ContainerElectricBoat;
import ic2.core.item.boats.EntityClassicBoat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityElectricBoat
extends EntityClassicBoat
implements IInvBasic,
IHasGui {
    public AnimalChest chest;
    private float speedCheck = 0.0f;
    public static double MaxUsage = 2.5;
    public boolean guiOpen = false;

    public EntityElectricBoat(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityElectricBoat(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(21, (Object)new Float(0.0f));
        this.chest = new AnimalChest("BatterySlot", 1);
        this.chest.func_110134_a((IInvBasic)this);
    }

    @Override
    public ItemStack getItem() {
        return Ic2Items.electricBoat.func_77946_l();
    }

    @Override
    public ResourceLocation getTexture() {
        return this.createBase("boatElectric");
    }

    @Override
    public void onRammingBreaking(double speed) {
        this.func_70099_a(this.getItem(), 0.0f);
        if (this.chest.func_70301_a(0) != null) {
            this.func_70099_a(this.chest.func_70301_a(0), 0.0f);
            this.chest.func_70299_a(0, null);
        }
    }

    @Override
    public void onPlayerBreaking() {
        super.onPlayerBreaking();
        if (this.chest.func_70301_a(0) != null) {
            this.func_70099_a(this.chest.func_70301_a(0), 0.0f);
            this.chest.func_70299_a(0, null);
        }
    }

    @Override
    public void onFallingBreaking(float fallingDistance) {
        this.func_70099_a(this.getItem(), 0.0f);
        if (this.chest.func_70301_a(0) != null) {
            this.func_70099_a(this.chest.func_70301_a(0), 0.0f);
            this.chest.func_70299_a(0, null);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Inv")) {
            this.chest.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Inv")));
        } else {
            this.chest.func_70299_a(0, null);
        }
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(nbt.func_74760_g("Speed")));
        this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.chest.func_70301_a(0) != null) {
            NBTTagCompound data = new NBTTagCompound();
            this.chest.func_70301_a(0).func_77955_b(data);
            nbt.func_74782_a("Inv", (NBTBase)data);
        }
        this.speedCheck = this.field_70180_af.func_111145_d(20);
        nbt.func_74776_a("Speed", this.speedCheck);
    }

    private float getCharge(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IElectricItem)) {
            return 0.0f;
        }
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        return (float)(ElectricItem.manager.getCharge(stack) / item.getMaxCharge(stack));
    }

    @Override
    public void func_70071_h_() {
        if (IC2.platform.isSimulating()) {
            if (this.chest.func_70301_a(0) == null) {
                if (this.speedCheck != 0.0f) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(0.0f));
                }
                if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && IC2.keyboard.isSideinventoryKeyDown((EntityPlayer)this.field_70153_n) && !this.guiOpen) {
                    IC2.platform.launchGui((EntityPlayer)this.field_70153_n, this);
                    this.guiOpen = true;
                }
            } else if (this.field_70153_n == null || !(this.field_70153_n instanceof EntityPlayer)) {
                double energyUsage = Math.max(this.speedCheck != 0.0f ? 1.0 : 0.0, Math.abs((double)this.speedCheck * (this.speedCheck < 0.0f ? MaxUsage * 2.0 : MaxUsage)));
                energyUsage -= ElectricItem.manager.discharge(this.chest.func_70301_a(0), energyUsage, Integer.MAX_VALUE, true, true, false);
                this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
                if (energyUsage != 0.0 || this.field_70159_w == 0.0 && this.field_70179_y == 0.0) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(0.0f));
                }
            } else {
                EntityPlayer player = (EntityPlayer)this.field_70153_n;
                if (player.field_70701_bs != 0.0f) {
                    if (player.field_70701_bs > 0.0f && this.speedCheck < 4.0f || player.field_70701_bs < 0.0f && this.speedCheck > -2.0f) {
                        this.speedCheck += 0.05f * player.field_70701_bs;
                        this.speedCheck = Math.min(4.0f, Math.max(-2.0f, this.speedCheck));
                        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(this.speedCheck));
                    }
                } else if (IC2.keyboard.isModeSwitchKeyDown(player)) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(0.0f));
                }
                double energyUsage = Math.max(this.speedCheck != 0.0f ? 1.0 : 0.0, Math.abs((double)this.speedCheck * (this.speedCheck < 0.0f ? MaxUsage * 2.0 : MaxUsage)));
                if (!ElectricItem.manager.use(this.chest.func_70301_a(0), energyUsage, (EntityLivingBase)player)) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(0.0f));
                }
                this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
                if (IC2.keyboard.isSideinventoryKeyDown(player) && !this.guiOpen) {
                    IC2.platform.launchGui(player, this);
                    this.guiOpen = true;
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public float getSpeed(EntityLivingBase base) {
        return this.field_70180_af.func_111145_d(20);
    }

    @Override
    public double getTopSpeed() {
        return 1.0;
    }

    @Override
    public boolean hasAfkSpeed() {
        return this.speedCheck != 0.0f;
    }

    @Override
    public float getAfkSpeed() {
        return this.field_70180_af.func_111145_d(20);
    }

    @Override
    public double getMaxRammingSpeed() {
        return 2.0;
    }

    public void func_76316_a(InventoryBasic p_76316_1_) {
        if (IC2.platform.isRendering()) {
            return;
        }
        this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
    }

    public float getCharge() {
        return this.field_70180_af.func_111145_d(21);
    }

    public float getForce() {
        return this.field_70180_af.func_111145_d(20);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerElectricBoat(p0.field_71071_by, (IInventory)this.chest, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "item.boats.GuiElectricBoat";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
        this.guiOpen = false;
    }
}

