/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorPlanner;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.ISteamReactor;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.item.ItemIC2;
import ic2.core.item.reactor.ItemReactorEnrichUranium;
import ic2.core.util.IExtraData;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.IIcon;

public class ItemReactorDepletedEnrichedUranium
extends ItemIC2
implements ICustomDamageItem,
ISteamReactorComponent,
IReactorPlannerComponent,
IExtraData {
    public ItemReactorDepletedEnrichedUranium(int index) {
        super(index);
        this.func_77627_a(true);
        this.func_77656_e(10000);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.getTexture(this.spriteID)[this.iconIndex + par1];
    }

    public ItemReactorEnrichUranium.UraniumType getUranType(ItemStack par1) {
        return ItemReactorEnrichUranium.UraniumType.values()[par1.func_77960_j()];
    }

    @Override
    public void init() {
        Ic2Items.reactorRedstoneIsotopeCell = new ItemStack((Item)this, 1, ItemReactorEnrichUranium.UraniumType.Redstone.ordinal());
        Ic2Items.reactorBlazeIsotopeCell = new ItemStack((Item)this, 1, ItemReactorEnrichUranium.UraniumType.Blaze.ordinal());
        Ic2Items.reactorEnderPearlIsotopeCell = new ItemStack((Item)this, 1, ItemReactorEnrichUranium.UraniumType.EnderPearl.ordinal());
        Ic2Items.reactorNetherStarIsotopeCell = new ItemStack((Item)this, 1, ItemReactorEnrichUranium.UraniumType.NetherStar.ordinal());
        Ic2Items.reactorCharcoalIsotopeCell = new ItemStack((Item)this, 1, ItemReactorEnrichUranium.UraniumType.Charcoal.ordinal());
    }

    public String func_77667_c(ItemStack item) {
        ItemReactorEnrichUranium.UraniumType uran = this.getUranType(item);
        switch (uran) {
            case Redstone: {
                return "item.itemDepletedRedstoneEnrichedUraniumCell";
            }
            case Blaze: {
                return "item.itemDepletedBlazeEnrichedUraniumCell";
            }
            case EnderPearl: {
                return "item.itemDepletedEnderPearlEnrichedUraniumCell";
            }
            case NetherStar: {
                return "item.itemDepletedNetherStarEnrichedUraniumCell";
            }
            case Charcoal: {
                return "item.itemDepletedCharcoalEnrichedUraniumCell";
            }
        }
        return super.func_77667_c(item);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        return StackUtil.getOrCreateNbtData(stack).func_74762_e("CustomDamage");
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta < ItemReactorEnrichUranium.UraniumType.values().length) {
            return ItemReactorEnrichUranium.UraniumType.values()[meta].getMaxDamage();
        }
        return this.getMaxDamage(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Deprecated
    public int getDisplayDamage(ItemStack stack) {
        return this.getCustomDamage(stack);
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74768_a("CustomDamage", damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        this.setCustomDamage(stack, this.getCustomDamage(stack) + damage);
        return true;
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            planner.addReEnrichPulse();
        }
        if (reactor instanceof ISteamReactor) {
            if (heatrun) {
                int myLevel = this.getCustomDamage(yourStack) - 1 - reactor.getHeat() / 3000;
                if (myLevel <= 0) {
                    ItemReactorEnrichUranium.UraniumType type = this.getUranType(yourStack);
                    reactor.setItemAt(youX, youY, type.getReEnriched());
                } else {
                    this.setCustomDamage(yourStack, myLevel);
                }
            }
            return true;
        }
        int myLevel = this.getCustomDamage(yourStack) - 1 - reactor.getHeat() / 3000;
        if (myLevel <= 0) {
            reactor.setItemAt(youX, youY, new ItemStack(Ic2Items.reEnrichedUraniumCell.func_77973_b()));
        } else {
            this.setCustomDamage(yourStack, myLevel);
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return 0;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[ItemReactorEnrichUranium.UraniumType.values().length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new ItemStack((Item)this, 1, i);
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return null;
    }

    @Override
    public short getID(ItemStack stack) {
        ItemReactorEnrichUranium.UraniumType type = this.getUranType(stack);
        switch (type) {
            case Redstone: {
                return 43;
            }
            case Blaze: {
                return 44;
            }
            case EnderPearl: {
                return 45;
            }
            case NetherStar: {
                return 46;
            }
            case Charcoal: {
                return 47;
            }
        }
        return 0;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack par1) {
        return IReactorPlannerComponent.ReactorComponentType.IsotopeCell;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return new NBTTagInt(this.func_77612_l());
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return false;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactor par1, int x, int y, ItemStack item, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List list) {
        for (ItemReactorEnrichUranium.UraniumType uran : ItemReactorEnrichUranium.UraniumType.values()) {
            list.add(new ItemStack((Item)this, 1, uran.ordinal()));
        }
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

