/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.item.ItemIC2;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemReactorHeatpack
extends ItemIC2
implements IReactorComponent,
IReactorPlannerComponent {
    public int maxPer;
    public int heatPer;

    public ItemReactorHeatpack(int index, int maxper, int heatper) {
        super(index);
        this.maxPer = maxper;
        this.heatPer = heatper;
        this.setSpriteID("i3");
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        this.heat(reactor, yourStack.field_77994_a, x + 1, y);
        this.heat(reactor, yourStack.field_77994_a, x - 1, y);
        this.heat(reactor, yourStack.field_77994_a, x, y + 1);
        this.heat(reactor, yourStack.field_77994_a, x, y - 1);
    }

    private void heat(IReactor reactor, int stacksize, int x, int y) {
        IReactorComponent comp;
        int want = this.maxPer * stacksize;
        if (reactor.getHeat() >= want) {
            return;
        }
        ItemStack stack = reactor.getItemAt(x, y);
        if (stack != null && stack.func_77973_b() instanceof IReactorComponent && (comp = (IReactorComponent)stack.func_77973_b()).canStoreHeat(reactor, stack, x, y)) {
            int add = this.heatPer * stacksize;
            int curr = comp.getCurrentHeat(reactor, stack, x, y);
            if (add > want - curr) {
                add = want - curr;
            }
            if (add > 0) {
                comp.alterHeat(reactor, stack, x, y, add);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return 0;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return yourStack.field_77994_a / 10;
    }

    @Override
    public ItemStack[] getSubParts() {
        return null;
    }

    @Override
    public boolean hasSubParts() {
        return false;
    }

    @Override
    public ItemStack getReactorPart() {
        return new ItemStack((Item)this);
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack par1) {
        return IReactorPlannerComponent.ReactorComponentType.HeatPack;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            return new NBTTagInt(par2.field_77994_a * 2);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return par1 == IReactorPlannerComponent.ReactorComponentStat.HeatProduction;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactor par1, int x, int y, ItemStack item, IReactorPlannerComponent.ReactorComponentStat stat) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int sides = 0;
            for (ForgeDirection dir : TileEntityMiner.validDirs) {
                IReactorComponent comp;
                int newX = x + dir.offsetX;
                int newY = y + dir.offsetZ;
                ItemStack stack = par1.getItemAt(newX, newY);
                if (stack == null || !(stack.func_77973_b() instanceof IReactorComponent) || !(comp = (IReactorComponent)stack.func_77973_b()).canStoreHeat(par1, stack, x, y)) continue;
                ++sides;
            }
            return new NBTTagInt(item.field_77994_a * 2 * sides);
        }
        return nulltag;
    }

    @Override
    public short getID(ItemStack stack) {
        return 17;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Reactor;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

