/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.reactor.IReactorPlanner;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.ISteamReactor;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.item.ItemGradual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;

public class ItemReactorUranium
extends ItemGradual
implements ISteamReactorComponent,
IReactorPlannerComponent {
    public int numberOfCells;

    public ItemReactorUranium(int index, int cells) {
        super(index);
        this.numberOfCells = cells;
        this.setSpriteID("i3");
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        for (int iteration = 0; iteration < this.numberOfCells; ++iteration) {
            int heat;
            int dheat;
            int pulses = 1 + this.numberOfCells / 2;
            if (!heatrun) {
                for (int i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y, heatrun);
                }
                pulses += ItemReactorUranium.checkPulseable(reactor, x - 1, y, yourStack, x, y, heatrun) + ItemReactorUranium.checkPulseable(reactor, x + 1, y, yourStack, x, y, heatrun) + ItemReactorUranium.checkPulseable(reactor, x, y - 1, yourStack, x, y, heatrun) + ItemReactorUranium.checkPulseable(reactor, x, y + 1, yourStack, x, y, heatrun);
                continue;
            }
            ArrayList heatAcceptors = new ArrayList();
            this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            for (heat = this.sumUp(pulses += ItemReactorUranium.checkPulseable(reactor, x - 1, y, yourStack, x, y, heatrun) + ItemReactorUranium.checkPulseable(reactor, x + 1, y, yourStack, x, y, heatrun) + ItemReactorUranium.checkPulseable(reactor, x, y - 1, yourStack, x, y, heatrun) + ItemReactorUranium.checkPulseable(reactor, x, y + 1, yourStack, x, y, heatrun)) * 4; heatAcceptors.size() > 0 && heat > 0; heat += dheat) {
                dheat = heat / heatAcceptors.size();
                heat -= dheat;
                dheat = ((IReactorComponent)((ItemStackCoord)heatAcceptors.get((int)0)).stack.func_77973_b()).alterHeat(reactor, ((ItemStackCoord)heatAcceptors.get((int)0)).stack, ((ItemStackCoord)heatAcceptors.get((int)0)).x, ((ItemStackCoord)heatAcceptors.get((int)0)).y, dheat);
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (yourStack.func_77960_j() >= this.func_77612_l() - 1) {
            if (IC2.random.nextInt(3) == 0) {
                reactor.setItemAt(x, y, new ItemStack(Ic2Items.nearDepletedUraniumCell.func_77973_b(), this.numberOfCells));
            } else {
                reactor.setItemAt(x, y, null);
            }
        } else if (heatrun) {
            yourStack.func_77964_b(yourStack.func_77960_j() + 1);
        }
    }

    private static int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other != null && other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey, heatrun)) {
            return 1;
        }
        return 0;
    }

    private int sumUp(int x) {
        int sum = 0;
        for (int i = 1; i <= x; ++i) {
            sum += i;
        }
        return sum;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing != null && thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            planner.addFuelPulse();
        }
        if (reactor instanceof ISteamReactor) {
            return true;
        }
        if (!heatrun) {
            reactor.addOutput(1.0f);
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 2 * this.numberOfCells;
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        if (!reactor.produceEnergy()) {
            return;
        }
        for (int iteration = 0; iteration < this.numberOfCells; ++iteration) {
            int heat;
            int dheat;
            int pulses = 1 + this.numberOfCells / 2;
            if (!heatrun) {
                for (int i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y, heatrun);
                }
                pulses += ItemReactorUranium.checkPulseable(reactor, x - 1, y, yourStack, x, y, damageTick) + ItemReactorUranium.checkPulseable(reactor, x + 1, y, yourStack, x, y, damageTick) + ItemReactorUranium.checkPulseable(reactor, x, y - 1, yourStack, x, y, damageTick) + ItemReactorUranium.checkPulseable(reactor, x, y + 1, yourStack, x, y, damageTick);
                continue;
            }
            ArrayList heatAcceptors = new ArrayList();
            this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            for (heat = this.sumUp(pulses += ItemReactorUranium.checkPulseable(reactor, x - 1, y, yourStack, x, y, damageTick) + ItemReactorUranium.checkPulseable(reactor, x + 1, y, yourStack, x, y, damageTick) + ItemReactorUranium.checkPulseable(reactor, x, y - 1, yourStack, x, y, damageTick) + ItemReactorUranium.checkPulseable(reactor, x, y + 1, yourStack, x, y, damageTick)) * 4; heatAcceptors.size() > 0 && heat > 0; heat += dheat) {
                dheat = heat / heatAcceptors.size();
                heat -= dheat;
                dheat = ((IReactorComponent)((ItemStackCoord)heatAcceptors.get((int)0)).stack.func_77973_b()).alterHeat(reactor, ((ItemStackCoord)heatAcceptors.get((int)0)).stack, ((ItemStackCoord)heatAcceptors.get((int)0)).x, ((ItemStackCoord)heatAcceptors.get((int)0)).y, dheat);
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (damageTick) {
            if (yourStack.func_77960_j() >= this.func_77612_l() - 1) {
                if (IC2.random.nextInt(3) == 0) {
                    reactor.setItemAt(x, y, new ItemStack(Ic2Items.nearDepletedUraniumCell.func_77973_b(), this.numberOfCells));
                } else {
                    reactor.setItemAt(x, y, null);
                }
            } else {
                yourStack.func_77964_b(yourStack.func_77960_j() + 1);
            }
        }
    }

    @Override
    public ItemStack[] getSubParts() {
        return null;
    }

    @Override
    public boolean hasSubParts() {
        return false;
    }

    @Override
    public short getID(ItemStack stack) {
        switch (this.numberOfCells) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public ItemStack getReactorPart() {
        return new ItemStack((Item)this);
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack par1) {
        return IReactorPlannerComponent.ReactorComponentType.FuelRod;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            for (int i = 0; i < this.numberOfCells; ++i) {
                amount += this.sumUp(1 + this.numberOfCells / 2) * 4;
            }
            return new NBTTagInt(amount);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            int amount = 0;
            for (int i = 0; i < this.numberOfCells; ++i) {
                int pulses = 1 + this.numberOfCells / 2;
                for (int z = 0; z < pulses; ++z) {
                    ++amount;
                }
            }
            return new NBTTagFloat((float)amount);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return new NBTTagInt(this.func_77612_l());
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.ReactorEEM) {
            return new NBTTagFloat((float)(2 * this.numberOfCells));
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.RodAmount) {
            return new NBTTagInt(this.numberOfCells);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.PulseAmount) {
            return new NBTTagInt((1 + this.numberOfCells / 2) * this.numberOfCells);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return par1 == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction || par1 == IReactorPlannerComponent.ReactorComponentStat.HeatProduction;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactor par1, int x, int y, ItemStack item, IReactorPlannerComponent.ReactorComponentStat stat) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            for (int i = 0; i < this.numberOfCells; ++i) {
                int pulses = 1 + this.numberOfCells / 2;
                amount += this.sumUp(pulses += ItemReactorUranium.checkPulseable(par1, x - 1, y, item, x, y, false) + ItemReactorUranium.checkPulseable(par1, x + 1, y, item, x, y, false) + ItemReactorUranium.checkPulseable(par1, x, y - 1, item, x, y, false) + ItemReactorUranium.checkPulseable(par1, x, y + 1, item, x, y, false)) * 4;
            }
            return new NBTTagInt(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            for (int i = 0; i < this.numberOfCells; ++i) {
                int pulses = 1 + this.numberOfCells / 2;
                for (int z = 0; z < pulses; ++z) {
                    this.acceptUraniumPulse(par1, item, item, x, y, x, y, false);
                }
                pulses += ItemReactorUranium.checkPulseable(par1, x - 1, y, item, x, y, false) + ItemReactorUranium.checkPulseable(par1, x + 1, y, item, x, y, false) + ItemReactorUranium.checkPulseable(par1, x, y - 1, item, x, y, false) + ItemReactorUranium.checkPulseable(par1, x, y + 1, item, x, y, false);
            }
            return new NBTTagFloat(par1.getReactorEnergyOutput());
        }
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }

    static class ItemStackCoord {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemStackCoord(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

