/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.tile.ISpecialWrenchable;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemToolWrench
extends ItemIC2 {
    public ItemToolWrench(int index) {
        super(index);
        this.func_77656_e(160);
        this.func_77625_d(1);
        this.setSpriteID("i1");
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityTerra tileEntityTerra;
        if (!this.canTakeDamage(itemstack, 1)) {
            return false;
        }
        Block blockId = world.func_147439_a(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityTerra && (tileEntityTerra = (TileEntityTerra)tileEntity).ejectBlueprint()) {
            if (IC2.platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (IC2.keyboard.isAltKeyDown(entityPlayer)) {
                side = entityPlayer.func_70093_af() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
            } else if (entityPlayer.func_70093_af()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (IC2.platform.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.damage(itemstack, 1, entityPlayer);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
            if (wrenchable instanceof ISpecialWrenchable && this.canTakeDamage(itemstack, 5) && ((ISpecialWrenchable)wrenchable).canDoSpecial(entityPlayer, side)) {
                if (IC2.platform.isSimulating()) {
                    boolean result = ((ISpecialWrenchable)wrenchable).doSpecial(entityPlayer, side);
                    if (result) {
                        this.damage(itemstack, 5, entityPlayer);
                    }
                    return true;
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
            if (this.canTakeDamage(itemstack, this.overrideWrenchSuccessRate(itemstack) ? 100 : 10) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (IC2.platform.isSimulating()) {
                    Block block = blockId;
                    boolean dropOriginalBlock = false;
                    double base = wrenchable.getWrenchDropRate();
                    dropOriginalBlock = (double)world.field_73012_v.nextFloat() <= (base *= this.applyFortune(itemstack, this.getModifier(itemstack)));
                    this.damage(itemstack, 10, entityPlayer);
                    if (!dropOriginalBlock && this.overrideWrenchSuccessRate(itemstack)) {
                        dropOriginalBlock = true;
                        this.damage(itemstack, 200, entityPlayer);
                    }
                    ArrayList drops = block.getDrops(world, x, y, z, metaData, 0);
                    if (dropOriginalBlock) {
                        if (drops.isEmpty()) {
                            drops.add(wrenchable.getWrenchDrop(entityPlayer));
                        } else {
                            drops.set(0, wrenchable.getWrenchDrop(entityPlayer));
                        }
                    }
                    for (ItemStack itemStack : drops) {
                        StackUtil.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.func_147468_f(x, y, z);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
        }
        return false;
    }

    public double getModifier(ItemStack stack) {
        return 1.0;
    }

    public double applyFortune(ItemStack stack, double base) {
        int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack);
        for (int i = 0; i < fortune; ++i) {
            base += base * 0.1;
        }
        return base;
    }

    public void damage(ItemStack is, int damage, EntityPlayer player) {
        is.func_77972_a(damage, (EntityLivingBase)player);
    }

    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        return false;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return false;
    }
}

