/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import com.google.common.math.DoubleMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManagerExp;
import ic2.api.tile.IMachine;
import ic2.api.tile.IRecipeMachine;
import ic2.core.Ic2Icons;
import ic2.core.item.upgrades.BaseMetaUpgrade;
import ic2.core.util.StackUtil;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ExpCollectorUpgrade
extends BaseMetaUpgrade {
    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        return 5;
    }

    @Override
    public void onProcessEnd(ItemStack upgrade, IMachine machine, List<ItemStack> results) {
        IMachineRecipeManager rMachine;
        IRecipeMachine recipe;
        if (machine instanceof IRecipeMachine && (recipe = (IRecipeMachine)machine).getRecipeList() != null && (rMachine = recipe.getRecipeList()) instanceof IMachineRecipeManagerExp) {
            IMachineRecipeManagerExp exp = (IMachineRecipeManagerExp)rMachine;
            for (int i = 0; i < results.size(); ++i) {
                ItemStack item = results.get(i);
                if (item == null || item.field_77994_a <= 0) continue;
                float amount = exp.getExpResult(item) * (float)item.field_77994_a;
                this.addExp(upgrade, amount /= 10.0f);
            }
        }
    }

    @Override
    public IMachine.UpgradeType getType() {
        return IMachine.UpgradeType.Processing;
    }

    @Override
    public String getName() {
        return "expCollectorUpgrade";
    }

    @Override
    public IIcon getTexture() {
        return Ic2Icons.getTexture("i0")[140];
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3) {
        DecimalFormat format = new DecimalFormat("0.#");
        par3.add(StatCollector.func_74837_a((String)"itemInfo.upgradeStoredExp.name", (Object[])new Object[]{format.format(this.getStoredExp(par1))}));
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player) {
        float exp = this.getExp(item);
        int realExp = DoubleMath.roundToInt((double)exp, (RoundingMode)RoundingMode.DOWN);
        if (realExp > 0) {
            player.func_71023_q(realExp);
            this.removeExp(item, realExp);
        }
    }

    public void addExp(ItemStack item, float exp) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        float stuff = nbt.func_74760_g("Exp");
        if ((stuff += exp) > 250.0f) {
            stuff = 250.0f;
        }
        nbt.func_74776_a("Exp", stuff);
    }

    public void removeExp(ItemStack par1, float exp) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        float amount = nbt.func_74760_g("Exp");
        if ((amount -= exp) < 0.0f) {
            amount = 0.0f;
        }
        nbt.func_74776_a("Exp", amount);
    }

    public float getExp(ItemStack item) {
        return StackUtil.getOrCreateNbtData(item).func_74760_g("Exp");
    }

    public double getStoredExp(ItemStack par1) {
        return this.getExp(par1);
    }
}

