/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.IHandHeldInventory;
import ic2.core.network.PacketManager;
import ic2.core.network.internal.INetworkGuiDataProvider;
import ic2.core.network.packets.IC2Packet;
import ic2.core.network.packets.server.BlockUpdatePacket;
import ic2.core.network.packets.server.ExplosionPacket;
import ic2.core.network.packets.server.FieldUpdatePacket;
import ic2.core.network.packets.server.GuiFieldPacket;
import ic2.core.network.packets.server.ItemEventPacket;
import ic2.core.network.packets.server.ItemGuiPacket;
import ic2.core.network.packets.server.TileGuiPacket;
import ic2.core.network.packets.server.TileServerEventPacket;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class NetworkManager {
    private int updatePeriod = 2;
    protected static Map<World, FieldStorage> fieldsToUpdateSet = new HashMap<World, FieldStorage>();
    protected static Map<World, GuiFieldStorage> guiToSync = new LinkedHashMap<World, GuiFieldStorage>();
    public static Map<EntityPlayer, TileEntity> watchingTile = new LinkedHashMap<EntityPlayer, TileEntity>();

    public void onUnload() {
        fieldsToUpdateSet.clear();
        guiToSync.clear();
        watchingTile.clear();
    }

    public void clearGuiFields() {
        for (GuiFieldStorage storage : guiToSync.values()) {
            storage.clear();
        }
    }

    public void onWorldUnload(World world) {
        GuiFieldStorage gui;
        FieldStorage storage = fieldsToUpdateSet.remove(world);
        if (storage != null) {
            storage.clear();
        }
        if ((gui = guiToSync.remove(world)) != null) {
            gui.clear();
        }
    }

    public void onTick(World world) {
        this.sendUpdatePacket(world);
    }

    public void startWatchingTile(EntityPlayer player, TileEntity tile) {
        watchingTile.put(player, tile);
    }

    public void updateGuiChanges(EntityPlayer player, TileEntity tile) {
        GuiFieldStorage storage = guiToSync.get(tile.func_145831_w());
        if (storage == null) {
            return;
        }
        List<FieldData> data = storage.getData(tile);
        if (data.isEmpty()) {
            return;
        }
        PacketManager.instance.sendToPlayer(new GuiFieldPacket(tile, data), player);
    }

    public void requestInitialGuiData(EntityPlayer player, INetworkGuiDataProvider dataProvider) {
        if (!(dataProvider instanceof TileEntity)) {
            return;
        }
        ArrayList<FieldData> data = new ArrayList<FieldData>();
        for (String field : dataProvider.getGuiFields()) {
            data.add(GuiFieldStorage.createData((TileEntity)dataProvider, field));
        }
        PacketManager.instance.sendToPlayer(new GuiFieldPacket((TileEntity)dataProvider, data), player);
    }

    public void updateTileGuiField(TileEntity te, String field) {
        GuiFieldStorage worldFieldStorage = guiToSync.get(te.func_145831_w());
        if (worldFieldStorage == null) {
            worldFieldStorage = new GuiFieldStorage();
            guiToSync.put(te.func_145831_w(), worldFieldStorage);
        }
        worldFieldStorage.addTileEntityField(te, field);
    }

    public void updateTileEntityField(TileEntity te, String field) {
        FieldStorage worldFieldStorage = fieldsToUpdateSet.get(te.func_145831_w());
        if (worldFieldStorage == null) {
            worldFieldStorage = new FieldStorage();
            fieldsToUpdateSet.put(te.func_145831_w(), worldFieldStorage);
        }
        if (worldFieldStorage.addGlobalField(new TileEntityField(te, field))) {
            this.sendUpdatePacket(te.func_145831_w());
        }
    }

    public void updateTileEntityField(TileEntity te, String field, EntityPlayerMP player) {
        FieldStorage worldFieldStorage = fieldsToUpdateSet.get(te.func_145831_w());
        if (worldFieldStorage == null) {
            worldFieldStorage = new FieldStorage();
            fieldsToUpdateSet.put(te.func_145831_w(), worldFieldStorage);
        }
        if (worldFieldStorage.addPlayerField(player, new TileEntityField(te, field))) {
            this.sendUpdatePacket(te.func_145831_w());
        }
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        int maxDistance = (MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) / 2;
        World world = te.func_145831_w();
        TileServerEventPacket packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            if (!(entityPlayer.func_70011_f((double)te.field_145851_c, (double)te.field_145848_d, (double)te.field_145849_e) < (double)maxDistance)) continue;
            if (packet == null) {
                packet = new TileServerEventPacket(te, event);
            }
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
        ItemEventPacket packet = new ItemEventPacket(itemStack, event);
        PacketManager.instance.sendToPlayer(packet, player);
    }

    public void announceBlockUpdate(World world, int x, int y, int z) {
        BlockUpdatePacket packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distance = Math.min(Math.abs(x - (int)entityPlayer.field_70165_t), Math.abs(z - (int)entityPlayer.field_70161_v));
            if (distance > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            if (packet == null) {
                packet = new BlockUpdatePacket(world, x, y, z);
            }
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void sendCustomPacket(IC2Packet packet) {
    }

    public void sendCustomPacket(EntityPlayer player, IC2Packet packet) {
        PacketManager.instance.sendToPlayer(packet, player);
    }

    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    public void initiateClientItemEvent(ItemStack itemStack, int event) {
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, IHasGui inventory, int windowId) {
        IC2Packet packet = null;
        if (inventory instanceof TileEntity) {
            TileEntity tile = (TileEntity)inventory;
            packet = new TileGuiPacket(tile, windowId);
            if (tile instanceof INetworkGuiDataProvider) {
                this.requestInitialGuiData((EntityPlayer)entityPlayer, (INetworkGuiDataProvider)tile);
            }
            this.startWatchingTile((EntityPlayer)entityPlayer, tile);
        } else if (inventory instanceof Entity) {
            packet = new ItemGuiPacket(((Entity)inventory).func_145782_y(), windowId, true);
        } else if (entityPlayer.field_71071_by.func_70448_g() != null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof IHandHeldInventory) {
            packet = new ItemGuiPacket(entityPlayer.field_71071_by.field_70461_c, windowId, false);
        } else {
            IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
        }
        if (packet != null) {
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void sendUpdatePacket(World world) {
        List<FieldData> quere;
        int distance;
        if (!fieldsToUpdateSet.containsKey(world)) {
            return;
        }
        FieldStorage worldFieldStorage = fieldsToUpdateSet.get(world);
        if (worldFieldStorage.isEmpty()) {
            return;
        }
        if (world.field_73010_i.isEmpty()) {
            worldFieldStorage.clear();
            return;
        }
        HashMap playerQuere = new HashMap();
        int viewDistance = MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        if (worldFieldStorage.hasGlobalFields()) {
            for (TileEntityField tileEntityField : worldFieldStorage.getGlobalFields()) {
                if (tileEntityField.te.func_145837_r() || tileEntityField.te.func_145831_w() != world) continue;
                FieldData data = new FieldData();
                data.x = tileEntityField.te.field_145851_c;
                data.y = tileEntityField.te.field_145848_d;
                data.z = tileEntityField.te.field_145849_e;
                data.fieldName = tileEntityField.field;
                data.data = tileEntityField.getData();
                for (Object obj : world.field_73010_i) {
                    EntityPlayerMP player = (EntityPlayerMP)obj;
                    distance = Math.min(Math.abs(data.x - (int)player.field_70165_t), Math.abs(data.z - (int)player.field_70161_v));
                    if (distance > viewDistance) continue;
                    quere = (ArrayList<FieldData>)playerQuere.get(player);
                    if (quere == null) {
                        quere = new ArrayList<FieldData>(worldFieldStorage.size());
                        playerQuere.put(player, quere);
                    }
                    quere.add(data);
                }
            }
        }
        if (worldFieldStorage.hasPlayerFields()) {
            for (Map.Entry entry : worldFieldStorage.getPlayerFields()) {
                TileEntityField field = (TileEntityField)entry.getKey();
                if (field.te.func_145837_r() || field.te.func_145831_w() != world) continue;
                FieldData data = new FieldData();
                data.x = field.te.field_145851_c;
                data.y = field.te.field_145848_d;
                data.z = field.te.field_145849_e;
                data.fieldName = field.field;
                data.data = field.getData();
                for (EntityPlayerMP player : (Set)entry.getValue()) {
                    if (player.field_70128_L || player.field_70170_p != world || (distance = Math.min(Math.abs(data.x - (int)player.field_70165_t), Math.abs(data.z - (int)player.field_70161_v))) > viewDistance) continue;
                    quere = (List)playerQuere.get(player);
                    if (quere == null) {
                        quere = new ArrayList(worldFieldStorage.size());
                        playerQuere.put(player, quere);
                    }
                    quere.add(data);
                }
            }
        }
        for (Map.Entry entry : playerQuere.entrySet()) {
            FieldUpdatePacket packet = new FieldUpdatePacket((List)entry.getValue(), world);
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entry.getKey());
        }
        worldFieldStorage.clear();
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void sendLoginData() {
    }

    public void sendInitialData(EntityPlayerMP mp, TileEntity tile) {
        if (tile instanceof INetworkDataProvider) {
            for (String key : ((INetworkDataProvider)tile).getNetworkedFields()) {
                this.updateTileEntityField(tile, key);
            }
        }
    }

    public void initiateExplosionEffect(World world, double x, double y, double z) {
        this.initiateExplosionEffect(world, x, y, z, false);
    }

    public void initiateExplosionEffect(World world, double x, double y, double z, boolean nuke) {
        ExplosionPacket packet = new ExplosionPacket(world, x, y, z, nuke);
        for (Object player : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
            if (!(entityPlayer.func_70092_e(x, y, z) < 128.0)) continue;
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
        if (!nuke) {
            world.func_72908_a(x, y, z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    public static class GuiFieldStorage {
        Map<TileEntity, Set<String>> fieldStorage = new HashMap<TileEntity, Set<String>>();
        Map<TileEntity, Map<String, FieldData>> dataStorage = new HashMap<TileEntity, Map<String, FieldData>>();

        public void addTileEntityField(TileEntity tile, String id) {
            Set<String> keys = this.fieldStorage.get(tile);
            if (keys == null) {
                keys = new LinkedHashSet<String>();
                this.fieldStorage.put(tile, keys);
            }
            keys.add(id);
        }

        public void clear() {
            this.fieldStorage = new LinkedHashMap<TileEntity, Set<String>>();
            this.dataStorage = new HashMap<TileEntity, Map<String, FieldData>>();
        }

        public List<FieldData> getData(TileEntity tile) {
            Set<String> keys = this.fieldStorage.get(tile);
            if (keys == null || keys.isEmpty()) {
                return new ArrayList<FieldData>();
            }
            Map<String, FieldData> data = this.dataStorage.get(tile);
            if (data == null) {
                data = new HashMap<String, FieldData>();
                this.dataStorage.put(tile, data);
            }
            ArrayList<FieldData> result = new ArrayList<FieldData>();
            for (String key : keys) {
                FieldData local = data.get(key);
                if (local == null) {
                    local = GuiFieldStorage.createData(tile, key);
                    data.put(key, local);
                }
                result.add(local);
            }
            return result;
        }

        public static FieldData createData(TileEntity tile, String field) {
            FieldData data = new FieldData();
            data.x = tile.field_145851_c;
            data.y = tile.field_145848_d;
            data.z = tile.field_145849_e;
            data.fieldName = field;
            data.data = GuiFieldStorage.getData(tile, field);
            return data;
        }

        public static Object getData(TileEntity tile, String field) {
            try {
                Field targetfield = null;
                Class<?> fieldDeclaringClass = tile.getClass();
                do {
                    try {
                        targetfield = fieldDeclaringClass.getDeclaredField(field);
                    }
                    catch (NoSuchFieldException e3) {
                        fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                    }
                } while (targetfield == null && fieldDeclaringClass != null);
                if (targetfield == null) {
                    throw new NoSuchFieldException(field);
                }
                targetfield.setAccessible(true);
                return targetfield.get(tile);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class FieldStorage {
        Set<TileEntityField> globalFields = new LinkedHashSet<TileEntityField>();
        Map<TileEntityField, Set<EntityPlayerMP>> playerFields = new LinkedHashMap<TileEntityField, Set<EntityPlayerMP>>();

        public boolean isEmpty() {
            return this.globalFields.isEmpty() && this.playerFields.isEmpty();
        }

        public boolean hasGlobalFields() {
            return this.globalFields.size() > 0;
        }

        public boolean hasPlayerFields() {
            return this.playerFields.size() > 0;
        }

        public int size() {
            return this.globalFields.size() + this.playerFields.size();
        }

        public Set<TileEntityField> getGlobalFields() {
            return this.globalFields;
        }

        public Set<Map.Entry<TileEntityField, Set<EntityPlayerMP>>> getPlayerFields() {
            return this.playerFields.entrySet();
        }

        public void clear() {
            this.globalFields = new LinkedHashSet<TileEntityField>();
            this.playerFields = new LinkedHashMap<TileEntityField, Set<EntityPlayerMP>>();
        }

        public boolean addGlobalField(TileEntityField field) {
            if (!this.globalFields.add(field)) {
                return false;
            }
            this.playerFields.remove(field);
            return this.size() >= 10000;
        }

        public boolean addPlayerField(EntityPlayerMP player, TileEntityField field) {
            if (this.globalFields.contains(field)) {
                return false;
            }
            Set<EntityPlayerMP> fields = this.playerFields.get(field);
            boolean result = false;
            if (fields == null) {
                fields = new LinkedHashSet<EntityPlayerMP>();
                this.playerFields.put(field, fields);
                boolean bl = result = this.size() >= 10000;
            }
            if (fields.add(player)) {
                return result;
            }
            return false;
        }
    }

    class TileEntityField {
        TileEntity te;
        String field;
        EntityPlayerMP target = null;

        TileEntityField(TileEntity te, String field) {
            this.te = te;
            this.field = field;
        }

        public Object getData() {
            try {
                Field targetfield = null;
                Class<?> fieldDeclaringClass = this.te.getClass();
                do {
                    try {
                        targetfield = fieldDeclaringClass.getDeclaredField(this.field);
                    }
                    catch (NoSuchFieldException e3) {
                        fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                    }
                } while (targetfield == null && fieldDeclaringClass != null);
                if (targetfield == null) {
                    throw new NoSuchFieldException(this.field);
                }
                targetfield.setAccessible(true);
                return targetfield.get(this.te);
            }
            catch (Exception e) {
                return null;
            }
        }

        TileEntityField(TileEntity te, String field, EntityPlayerMP target) {
            this.te = te;
            this.field = field;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field);
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }

    public static class FieldData {
        public int x;
        public int y;
        public int z;
        public String fieldName;
        public Object data;

        public ChunkCoordinates getCoords() {
            return new ChunkCoordinates(this.x, this.y, this.z);
        }
    }
}

