/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.internal;

import ic2.core.IC2;
import ic2.core.network.internal.IPayloadReceiver;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PayloadPacket
extends IC2Packet {
    int dim;
    int x;
    int y;
    int z;
    public String[] strings;
    public int[] numbers;
    public boolean[] flags;

    public PayloadPacket() {
    }

    public PayloadPacket(TileEntity tile, int text, int number, int flag) {
        this.dim = tile.func_145831_w().field_73011_w.field_76574_g;
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.strings = new String[text];
        this.numbers = new int[number];
        this.flags = new boolean[flag];
    }

    public void addString(int slot, String text) {
        this.strings[slot] = text;
    }

    public void addFlag(int slot, boolean flag) {
        this.flags[slot] = flag;
    }

    public void addNumber(int slot, int number) {
        this.numbers[slot] = number;
    }

    @Override
    public void read(ByteBuf par1) {
        int i;
        this.dim = par1.readInt();
        this.x = par1.readInt();
        this.y = par1.readInt();
        this.z = par1.readInt();
        int length = par1.readByte();
        this.strings = new String[length];
        for (i = 0; i < length; ++i) {
            this.strings[i] = this.readString(par1);
        }
        length = par1.readByte();
        this.numbers = new int[length];
        for (i = 0; i < length; ++i) {
            this.numbers[i] = par1.readInt();
        }
        length = par1.readByte();
        this.flags = new boolean[length];
        for (i = 0; i < length; ++i) {
            this.flags[i] = par1.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf par1) {
        int i;
        par1.writeInt(this.dim);
        par1.writeInt(this.x);
        par1.writeInt(this.y);
        par1.writeInt(this.z);
        par1.writeByte(this.strings.length);
        for (i = 0; i < this.strings.length; ++i) {
            this.writeString(par1, this.strings[i]);
        }
        par1.writeByte(this.numbers.length);
        for (i = 0; i < this.numbers.length; ++i) {
            par1.writeInt(this.numbers[i]);
        }
        par1.writeByte(this.flags.length);
        for (i = 0; i < this.flags.length; ++i) {
            par1.writeBoolean(this.flags[i]);
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dim);
        if (world == null) {
            throw new RuntimeException("Packet Got Wrong Data");
        }
        TileEntity tile = world.func_147438_o(this.x, this.y, this.z);
        if (!(tile instanceof IPayloadReceiver)) {
            throw new RuntimeException("Packet Got Wrong Data");
        }
        ((IPayloadReceiver)tile).onPayloadPacket(par1, this);
    }

    private String readString(ByteBuf par1) {
        byte[] array = new byte[par1.readInt()];
        par1.readBytes(array);
        return new String(array);
    }

    private void writeString(ByteBuf par1, String text) {
        byte[] array = text.getBytes();
        par1.writeInt(array.length);
        par1.writeBytes(array);
    }

    public boolean getFlag(int slot) {
        return this.flags[slot];
    }

    public int getNumber(int slot) {
        return this.numbers[slot];
    }

    public String getString(int slot) {
        return this.strings[slot];
    }

    public int getSize(int type) {
        switch (type) {
            case 0: {
                return this.strings.length;
            }
            case 1: {
                return this.numbers.length;
            }
            case 2: {
                return this.flags.length;
            }
        }
        return 0;
    }
}

