/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.client;

import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FieldRequestPacket
extends IC2Packet {
    int dimID;
    int x;
    int y;
    int z;

    public FieldRequestPacket() {
    }

    public FieldRequestPacket(TileEntity tile) {
        this.dimID = tile.func_145831_w().field_73011_w.field_76574_g;
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        this.x = par1.readInt();
        this.y = par1.readInt();
        this.z = par1.readInt();
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeInt(this.x);
        par1.writeInt(this.y);
        par1.writeInt(this.z);
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet was sended Wrong: " + this.dimID + ":" + this.x + ":" + this.y + ":" + this.z);
        }
        TileEntity tile = world.func_147438_o(this.x, this.y, this.z);
        if (tile != null) {
            List<String> networkFields = ((INetworkDataProvider)tile).getNetworkedFields();
            for (String s : networkFields) {
                IC2.network.get().updateTileEntityField(tile, s);
            }
        }
    }
}

