/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import cpw.mods.fml.common.FMLLog;
import ic2.api.network.INetworkFieldData;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class FieldUpdatePacket
extends IC2Packet {
    Map<ChunkCoordinates, Map<String, Object>> data = new HashMap<ChunkCoordinates, Map<String, Object>>();
    int dimID;

    public FieldUpdatePacket() {
    }

    public FieldUpdatePacket(List<NetworkManager.FieldData> par1, World par2) {
        for (NetworkManager.FieldData cu : par1) {
            ChunkCoordinates coords = cu.getCoords();
            if (!this.data.containsKey(coords)) {
                this.data.put(coords, new HashMap());
            }
            this.data.get(coords).put(cu.fieldName, cu.data);
        }
        this.dimID = par2.field_73011_w.field_76574_g;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        int expected = par1.readInt();
        byte[] byteArray = new byte[par1.readInt()];
        par1.readBytes(byteArray);
        try {
            DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(byteArray)));
            for (int i = 0; i < expected; ++i) {
                int amount = (Integer)DataEncoder.decode(stream);
                ChunkCoordinates coord = (ChunkCoordinates)DataEncoder.decode(stream);
                if (!this.data.containsKey(coord)) {
                    this.data.put(coord, new HashMap());
                }
                for (int z = 0; z < amount; ++z) {
                    this.data.get(coord).put((String)DataEncoder.decode(stream), DataEncoder.decode(stream));
                }
            }
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeInt(this.data.size());
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(new GZIPOutputStream(bytes));
            for (Map.Entry<ChunkCoordinates, Map<String, Object>> entry : this.data.entrySet()) {
                Map<String, Object> value = entry.getValue();
                DataEncoder.encode(stream, value.size());
                DataEncoder.encode(stream, entry.getKey());
                for (Map.Entry<String, Object> dataValue : value.entrySet()) {
                    DataEncoder.encode(stream, dataValue.getKey());
                    DataEncoder.encode(stream, dataValue.getValue());
                }
            }
            stream.close();
            bytes.close();
            byte[] resultData = bytes.toByteArray();
            par1.writeInt(resultData.length);
            par1.writeBytes(resultData);
        }
        catch (Exception e) {
            FMLLog.getLogger().info("Packet got a problem during Writing data");
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        for (Map.Entry<ChunkCoordinates, Map<String, Object>> entry : this.data.entrySet()) {
            Map<String, Object> map = entry.getValue();
            ChunkCoordinates coord = entry.getKey();
            TileEntity tile = world.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            if (tile == null) continue;
            for (Map.Entry<String, Object> fields : map.entrySet()) {
                try {
                    Object value = fields.getValue();
                    String field = fields.getKey();
                    Field targetField = null;
                    Class<?> fieldDeclaringClass = tile.getClass();
                    do {
                        try {
                            targetField = fieldDeclaringClass.getDeclaredField(field);
                        }
                        catch (NoSuchFieldException e4) {
                            fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                        }
                    } while (targetField == null && fieldDeclaringClass != null);
                    if (targetField == null) {
                        IC2.log.warn("Can't find field " + field + " in te " + tile + " at " + coord.field_71574_a + "/" + coord.field_71572_b + "/" + coord.field_71573_c);
                    } else {
                        targetField.setAccessible(true);
                    }
                    if (targetField != null && tile != null) {
                        if (targetField.getType().isEnum()) {
                            value = targetField.getType().getEnumConstants()[(Integer)value];
                        }
                        if (INetworkFieldData.class.isAssignableFrom(targetField.getType()) && value instanceof byte[]) {
                            DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream((byte[])value)));
                            INetworkFieldData data = (INetworkFieldData)targetField.get(tile);
                            data.read(stream);
                            stream.close();
                        } else {
                            targetField.set(tile, value);
                        }
                    }
                    if (!(tile instanceof INetworkUpdateListener)) continue;
                    ((INetworkUpdateListener)tile).onNetworkUpdate(field);
                }
                catch (Exception e) {
                    FMLLog.getLogger().info("Field: " + fields.getKey());
                    e.printStackTrace();
                    throw new RuntimeException("Could not Inject TileEntity Data");
                }
            }
        }
    }
}

