/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.network.INetworkFieldData;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiFieldPacket
extends IC2Packet {
    Map<String, Object> data = new LinkedHashMap<String, Object>();
    int dim;
    int x;
    int y;
    int z;

    public GuiFieldPacket() {
    }

    public GuiFieldPacket(TileEntity tile, List<NetworkManager.FieldData> fields) {
        this.dim = tile.func_145831_w().field_73011_w.field_76574_g;
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        for (int i = 0; i < fields.size(); ++i) {
            NetworkManager.FieldData field = fields.get(i);
            this.data.put(field.fieldName, field.data);
        }
    }

    @Override
    public void read(ByteBuf par1) {
        this.dim = par1.readInt();
        this.x = par1.readInt();
        this.y = par1.readInt();
        this.z = par1.readInt();
        int expected = par1.readInt();
        byte[] byteArray = new byte[par1.readInt()];
        par1.readBytes(byteArray);
        try {
            DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(byteArray)));
            for (int i = 0; i < expected; ++i) {
                String key = (String)DataEncoder.decode(stream);
                Object value = DataEncoder.decode(stream);
                this.data.put(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dim);
        par1.writeInt(this.x);
        par1.writeInt(this.y);
        par1.writeInt(this.z);
        par1.writeInt(this.data.size());
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(new GZIPOutputStream(bytes));
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                DataEncoder.encode(stream, entry.getKey());
                DataEncoder.encode(stream, entry.getValue());
            }
            stream.close();
            bytes.close();
            byte[] resultData = bytes.toByteArray();
            par1.writeInt(resultData.length);
            par1.writeBytes(resultData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dim);
        if (world == null) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        TileEntity tile = world.func_147438_o(this.x, this.y, this.z);
        if (tile == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            try {
                Object value = entry.getValue();
                String field = entry.getKey();
                Field targetField = null;
                Class<?> fieldDeclaringClass = tile.getClass();
                do {
                    try {
                        targetField = fieldDeclaringClass.getDeclaredField(field);
                    }
                    catch (NoSuchFieldException e4) {
                        fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                    }
                } while (targetField == null && fieldDeclaringClass != null);
                if (targetField == null) {
                    IC2.log.warn("Can't find field " + field + " in te " + tile + " at " + this.x + "/" + this.y + "/" + this.z);
                } else {
                    targetField.setAccessible(true);
                }
                if (targetField == null || tile == null) continue;
                if (targetField.getType().isEnum()) {
                    value = targetField.getType().getEnumConstants()[(Integer)value];
                }
                if (INetworkFieldData.class.isAssignableFrom(targetField.getType()) && value instanceof byte[]) {
                    DataInputStream stream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream((byte[])value)));
                    INetworkFieldData data = (INetworkFieldData)targetField.get(tile);
                    data.read(stream);
                    stream.close();
                    continue;
                }
                targetField.set(tile, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not Inject TileEntity Data: " + entry.getKey());
            }
        }
    }
}

