/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.info.IEnergyValueProvider;
import ic2.api.info.IFuelValueProvider;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemInfo
implements IEnergyValueProvider,
IFuelValueProvider {
    @Override
    public double getEnergyValue(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return 0.0;
        }
        if (item instanceof IElectricItem) {
            return ElectricItem.manager.getCharge(itemStack);
        }
        if (item == Ic2Items.suBattery.func_77973_b()) {
            return 1000.0;
        }
        if (item == Items.field_151137_ax) {
            return 500.0;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
            return 4500.0;
        }
        return 0.0;
    }

    @Override
    public int getFuelValue(ItemStack itemStack, boolean allowLava) {
        Item itemId = itemStack.func_77973_b();
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (liquid != null && liquid.getFluid() == FluidRegistry.LAVA) {
            if (allowLava) {
                return 2000;
            }
            return 0;
        }
        if (itemId == Ic2Items.filledFuelCan.func_77973_b()) {
            int fv;
            NBTTagCompound data = StackUtil.getOrCreateNbtData(itemStack);
            if (!data.func_74764_b("value") && itemStack.func_77960_j() > 0) {
                data.func_74768_a("value", itemStack.func_77960_j());
            }
            return (fv = data.func_74762_e("value") * 2) > 500 ? 500 : fv;
        }
        if (itemId == Ic2Items.scrap.func_77973_b() && !IC2.enableBurningScrap) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }
}

