/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;
import ic2.core.IC2;
import ic2.core.block.inventory.IItemTransporter;
import ic2.core.block.inventory.TransporterManager;
import ic2.core.block.inventory.filter.BackupItemFilter;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.IPersonalInventory;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtil {
    private static Direction[] directions = Direction.values();

    public static void distributeDrop(TileEntity source, List<ItemStack> itemStacks) {
        for (Direction direction : directions) {
            if (itemStacks.isEmpty()) break;
            TileEntity target = direction.applyToTileEntity(source);
            if (!(target instanceof IInventory) || target instanceof TileEntityMiner || target instanceof TileEntityPump) continue;
            IInventory inventory = (IInventory)target;
            if (target instanceof TileEntityChest) {
                for (Direction direction2 : directions) {
                    TileEntity target2;
                    if (direction2 == Direction.YN || direction2 == Direction.YP || !((target2 = direction2.applyToTileEntity(target)) instanceof TileEntityChest)) continue;
                    inventory = new InventoryLargeChest("", inventory, (IInventory)target2);
                    break;
                }
            }
            Iterator<ItemStack> it = itemStacks.iterator();
            while (it.hasNext()) {
                ItemStack itemStackSource = it.next();
                if (itemStackSource == null) continue;
                int added = StackUtil.putInInventory(inventory, direction, null, itemStackSource);
                itemStackSource.field_77994_a -= added;
                if (itemStackSource.field_77994_a != 0) continue;
                it.remove();
            }
        }
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.field_77994_a > itemStack.func_77976_d()) {
                for (int i = 0; itemStack.field_77994_a > 0 && i < 1000; ++i) {
                    ItemStack drop = StackUtil.splitStack(itemStack, itemStack.func_77976_d());
                    StackUtil.dropAsEntity(source.func_145831_w(), source.field_145851_c, source.field_145848_d, source.field_145849_e, drop);
                }
                continue;
            }
            StackUtil.dropAsEntity(source.func_145831_w(), source.field_145851_c, source.field_145848_d, source.field_145849_e, itemStack);
        }
        itemStacks.clear();
    }

    public static ItemStack splitStack(ItemStack input, int size) {
        if (input == null) {
            return null;
        }
        ItemStack copy = input.func_77946_l();
        if (input.field_77994_a > size) {
            input.field_77994_a -= size;
            copy.field_77994_a = size;
            return copy;
        }
        input.field_77994_a = 0;
        return copy;
    }

    public static ItemStack getFromInventory(Object target, Direction dir, UUID owner, IItemTransporter.IFilter filter, int amount, boolean doRemove) {
        if (!(target instanceof IInventory) && !(target instanceof IPersonalBlock)) {
            return null;
        }
        IPersonalInventory inventory = null;
        if (target instanceof IPersonalBlock) {
            inventory = ((IPersonalBlock)target).getInventory(owner);
        }
        if (inventory == null && target instanceof IInventory) {
            inventory = (IInventory)target;
        }
        if (inventory == null) {
            return null;
        }
        IItemTransporter transporter = TransporterManager.manager.getTransporter(inventory);
        if (transporter == null) {
            return null;
        }
        return transporter.removeItem(filter, dir.toForgeDirection(), amount, doRemove);
    }

    public static ItemStack getFromInventory(IInventory inventory, Direction dir, ItemStack itemStackDestination) {
        BackupItemFilter filter = new BackupItemFilter(itemStackDestination);
        return StackUtil.getFromInventory(inventory, dir, null, filter, 1, true);
    }

    public static int putInInventory(Object target, Direction dir, UUID owner, ItemStack itemStackSource) {
        if (!(target instanceof IInventory) && !(target instanceof IPersonalBlock)) {
            return 0;
        }
        IPersonalInventory inventory = null;
        if (target instanceof IPersonalBlock) {
            inventory = ((IPersonalBlock)target).getInventory(owner);
        }
        if (inventory == null && target instanceof IInventory) {
            inventory = (IInventory)target;
        }
        if (inventory == null) {
            return 0;
        }
        IItemTransporter item = TransporterManager.manager.getTransporter(inventory);
        if (item == null) {
            return 0;
        }
        ItemStack added = item.addItem(itemStackSource, dir.toForgeDirection(), true);
        if (added == null) {
            return 0;
        }
        return added.field_77994_a;
    }

    public static boolean putInInventory(IInventory inventory, Direction dir, ItemStack itemStackSource) {
        return StackUtil.putInInventory(inventory, dir, null, itemStackSource) >= itemStackSource.field_77994_a;
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack.func_77946_l());
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack, String data) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null || !ret.func_74764_b(data)) {
            itemStack.func_77983_a(data, (NBTBase)new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74775_l(data);
    }

    public static void writeNBTDataToItemStack(ItemStack itemStack, NBTTagCompound data, String name) {
        itemStack.func_77983_a(name, (NBTBase)data);
    }

    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77973_b().func_77645_m() || stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE);
    }

    public static ItemStack copyWithWildCard(ItemStack itemStack) {
        ItemStack ret = itemStack.func_77946_l();
        Items.field_151100_aR.setDamage(ret, Short.MAX_VALUE);
        return ret;
    }

    public static boolean hasOreTag(String oreTag, ItemStack item) {
        for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
            if (!oreTag.equals(OreDictionary.getOreName((int)id))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOreID(ItemStack item) {
        int[] ints = OreDictionary.getOreIDs((ItemStack)item);
        return ints != null && ints.length != 0;
    }

    public static String getFirstOreID(ItemStack item) {
        int[] ints = OreDictionary.getOreIDs((ItemStack)item);
        if (ints == null || ints.length == 0) {
            return null;
        }
        return OreDictionary.getOreName((int)ints[0]);
    }

    public static void addOreIfMissing(String id, ItemStack item) {
        boolean empty = OreDictionary.getOres((String)id).isEmpty();
        if (empty || IC2.enableOreDictOverride) {
            OreDictionary.registerOre((String)id, (ItemStack)item.func_77946_l());
        }
    }

    public static void addInfo(ItemStack par1, EnumChatFormatting format, List<String> list) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74782_a("display", (NBTBase)display);
        NBTTagList lore = display.func_150295_c("Lore", 8);
        display.func_74782_a("Lore", (NBTBase)lore);
        for (int i = 0; i < list.size(); ++i) {
            lore.func_74742_a((NBTBase)new NBTTagString(list.get(i)));
        }
    }

    public static void addToolTip(ItemStack stack, String text) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74782_a("display", (NBTBase)display);
        NBTTagList lore = display.func_150295_c("Lore", 8);
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString(text));
    }
}

