/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import ic2.core.AdvRecipe;
import ic2.core.IC2;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class AdvRecipeHandler
extends ShapedRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == AdvRecipeHandler.class) {
            List allRecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allRecipes) {
                if (irecipe == null || !(irecipe instanceof AdvRecipe)) continue;
                AdvRecipe advRecipe = (AdvRecipe)irecipe;
                if (IC2.enableSecretRecipeHiding && !AdvRecipe.canShow(advRecipe)) continue;
                CachedShapedRecipe2 recipe = new CachedShapedRecipe2(advRecipe.length, advRecipe.height, (Object[])advRecipe.input.clone(), advRecipe.output.func_77946_l());
                if (!recipe.isAvailable) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allRecipes) {
            if (irecipe == null || !(irecipe instanceof AdvRecipe)) continue;
            AdvRecipe advRecipe = (AdvRecipe)irecipe;
            if (IC2.enableSecretRecipeHiding && !AdvRecipe.canShow(advRecipe)) continue;
            CachedShapedRecipe2 recipe = new CachedShapedRecipe2(advRecipe.length, advRecipe.height, (Object[])advRecipe.input.clone(), advRecipe.output.func_77946_l());
            if (!recipe.isAvailable || !this.containsIc2(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allRecipes) {
            if (irecipe == null || !(irecipe instanceof AdvRecipe)) continue;
            AdvRecipe advRecipe = (AdvRecipe)irecipe;
            if (IC2.enableSecretRecipeHiding && !AdvRecipe.canShow(advRecipe) || !this.areStacksSameTypeCraftingIc2(advRecipe.output, result)) continue;
            CachedShapedRecipe2 recipe = new CachedShapedRecipe2(advRecipe.length, advRecipe.height, (Object[])advRecipe.input.clone(), advRecipe.output.func_77946_l());
            if (!recipe.isAvailable) continue;
            this.arecipes.add(recipe);
        }
    }

    public boolean containsIc2(List<PositionedStack> ingredients, ItemStack ingredient) {
        for (PositionedStack stack : ingredients) {
            for (ItemStack item : stack.items) {
                if (!this.areStacksSameTypeCraftingIc2(ingredient, item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areStacksSameTypeCraftingIc2(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE || stack1.func_77973_b() instanceof IElectricItem && !(stack1.func_77973_b() instanceof ISpecialElectricItem) || stack1.func_77973_b().func_77645_m());
    }

    public String getRecipeName() {
        return "Shaped IC2 Crafting";
    }

    public class CachedShapedRecipe2
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;
        public boolean isAvailable;

        public CachedShapedRecipe2(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)AdvRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.isAvailable = false;
            this.setIngredients(width, height, items);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object obj = items[y * width + x];
                    if (obj == null) continue;
                    PositionedStack stack = new PositionedStack(obj, 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
            this.isAvailable = true;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AdvRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

