/*
 * Decompiled with CFR 0.152.
 */
package ic2.tcIntigration.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.IElectricHelper;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;

public class TinkerToolEUManager
implements IBackupElectricItemManager {
    @Override
    public boolean canUse(ItemStack arg0, double arg1) {
        return this.getCharge(arg0) >= arg1;
    }

    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound itemNBT = StackUtil.getOrCreateNbtData(itemStack);
        NBTTagCompound nbt = new NBTTagCompound();
        if (itemNBT.func_74764_b("EUEnergy")) {
            nbt = itemNBT.func_74775_l("EUEnergy");
        } else {
            itemNBT.func_74782_a("EUEnergy", (NBTBase)nbt);
        }
        assert (nbt.func_74762_e("maxCharge") > 0);
        if (amount < 0.0 || itemStack.field_77994_a > 1 || nbt.func_74762_e("Tier") > tier) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > (double)nbt.func_74762_e("limit")) {
            amount = nbt.func_74762_e("limit");
        }
        int tNewCharge = nbt.func_74762_e("charge");
        if (amount > (double)(nbt.func_74762_e("maxCharge") - tNewCharge)) {
            amount = nbt.func_74762_e("maxCharge") - tNewCharge;
        }
        if (!simulate && (tNewCharge = (int)((double)tNewCharge + amount)) > 0) {
            nbt.func_74768_a("charge", tNewCharge);
        }
        return amount;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating() || entity == null) {
            return;
        }
        boolean inventoryChanged = false;
        if (entity instanceof EntityPlayer && IC2.modul.containsKey("Baubles Modul")) {
            inventoryChanged = ((IElectricHelper)((Object)IC2.modul.get("Baubles Modul"))).chargeFromArmor(itemStack, (EntityPlayer)entity);
        }
        for (int i = 0; i < 4; ++i) {
            IElectricItem armorItem;
            ItemStack armorItemStack = entity.func_71124_b(i + 1);
            if (armorItemStack == null || !(armorItemStack.func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) continue;
            double transfer = this.charge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, true);
            if (!((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externalUse, boolean simulate) {
        int tNewCharge;
        if (externalUse) {
            return 0.0;
        }
        NBTTagCompound itemNBT = StackUtil.getOrCreateNbtData(itemStack);
        NBTTagCompound nbt = new NBTTagCompound();
        if (itemNBT.func_74764_b("EUEnergy")) {
            nbt = itemNBT.func_74775_l("EUEnergy");
        } else {
            itemNBT.func_74782_a("EUEnergy", (NBTBase)nbt);
        }
        assert (nbt.func_74762_e("maxCharge") > 0);
        if (amount < 0.0 || itemStack.field_77994_a > 1 || nbt.func_74762_e("Tier") > tier) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > (double)nbt.func_74762_e("limit")) {
            amount = nbt.func_74762_e("limit");
        }
        if (amount > (double)(tNewCharge = nbt.func_74762_e("charge"))) {
            amount = tNewCharge;
        }
        if (!simulate) {
            tNewCharge = (int)((double)tNewCharge - amount);
            nbt.func_74768_a("charge", tNewCharge);
        }
        return amount;
    }

    @Override
    public double getCharge(ItemStack arg0) {
        return this.discharge(arg0, 2.147483647E9, Integer.MAX_VALUE, true, false, true);
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(itemStack).func_74775_l("EUEnergy");
        int max = nbt.func_74762_e("maxCharge");
        return this.getCharge(itemStack) + "/" + max + " EU";
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        ElectricItem.manager.chargeFromArmor(itemStack, entity);
        double transfer = this.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, true);
        if (transfer == amount) {
            this.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
            ElectricItem.manager.chargeFromArmor(itemStack, entity);
            return true;
        }
        return false;
    }

    @Override
    public boolean handles(ItemStack arg0) {
        NBTTagCompound nbt;
        return arg0 != null && arg0.func_77973_b() instanceof IModifyable && (nbt = StackUtil.getOrCreateNbtData(arg0)).func_74764_b("EUEnergy");
    }
}

