/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import com.google.common.base.Objects;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayHashList<E>
extends AbstractCollection<E>
implements Cloneable {
    private transient Object[] elementData;
    protected transient int size;
    protected transient int mask;
    protected transient Entry[] hashTable;
    protected transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    protected static int hash(Object object) {
        int n = object == null ? 0 : object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int roundUpToPowerOf2(int n) {
        return n >= 0x40000000 ? 0x40000000 : (n > 2 ? Integer.highestOneBit(n - 1 << 1) : 2);
    }

    public ArrayHashList() {
        this.elementData = new Object[10];
        this.hashTable = new Entry[8];
        this.mask = 7;
    }

    public ArrayHashList(int n) {
        this.elementData = new Object[n];
        n = ArrayHashList.roundUpToPowerOf2(n) >> 1;
        this.hashTable = new Entry[n];
        this.mask = n - 1;
    }

    public ArrayHashList(Collection<E> collection) {
        int n = collection.size();
        this.elementData = new Object[n];
        n = ArrayHashList.roundUpToPowerOf2(n) >> 1;
        this.hashTable = new Entry[n];
        this.mask = n - 1;
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        int n = ArrayHashList.hash(e);
        if (this.seek(e, n) != null) {
            return false;
        }
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        this.insert(new Entry(e, n));
        this.rehashIfNecessary();
        return true;
    }

    public E get(int n) {
        this.checkElementIndex(n);
        return this.index(n);
    }

    public int indexOf(Object object) {
        Entry entry = this.seek(object, ArrayHashList.hash(object));
        if (entry == null) {
            return -1;
        }
        Object object2 = entry.key;
        Object[] objectArray = this.elementData;
        int n = this.size;
        while (n-- > 0 && objectArray[n] != object2) {
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        return this.seek(object, ArrayHashList.hash(object)) != null;
    }

    public E remove(int n) {
        this.checkElementIndex(n);
        E e = this.index(n);
        this.delete(this.seek(e, ArrayHashList.hash(e)));
        this.fastRemove(n);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        Entry entry = this.seek(object, ArrayHashList.hash(object));
        if (entry == null) {
            return false;
        }
        Object object2 = entry.key;
        Object[] objectArray = this.elementData;
        int n = this.size;
        while (n-- > 0) {
            if (objectArray[n] != object2) continue;
            this.fastRemove(n);
            break;
        }
        this.delete(entry);
        return true;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        int n;
        ++this.modCount;
        for (n = 0; n < this.size; ++n) {
            this.elementData[n] = null;
        }
        n = this.hashTable.length;
        while (n-- > 0) {
            this.hashTable[n] = null;
        }
        this.size = 0;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        if (n > 0) {
            this.ensureCapacityInternal(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        ++this.modCount;
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = ArrayHashList.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    E index(int n) {
        return (E)this.elementData[n];
    }

    protected Entry seek(Object object, int n) {
        Entry entry = this.hashTable[n & this.mask];
        while (entry != null) {
            if (n == entry.hash && Objects.equal((Object)object, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInBucket;
        }
        return null;
    }

    protected void insert(Entry entry) {
        int n = entry.hash & this.mask;
        entry.nextInBucket = this.hashTable[n];
        this.hashTable[n] = entry;
    }

    protected void delete(Entry entry) {
        block3: {
            int n = entry.hash & this.mask;
            Entry entry2 = null;
            Entry entry3 = this.hashTable[n];
            if (entry3 != entry) {
                while (true) {
                    if (entry3 == entry) {
                        entry2.nextInBucket = entry.nextInBucket;
                        break block3;
                    }
                    entry2 = entry3;
                    entry3 = entry3.nextInBucket;
                }
            }
            this.hashTable[n] = entry3.nextInBucket;
        }
    }

    protected void rehashIfNecessary() {
        Entry[] entryArray = this.hashTable;
        if (this.size > entryArray.length * 2 && entryArray.length < 0x40000000) {
            int n = entryArray.length * 2;
            int n2 = n - 1;
            this.hashTable = new Entry[n];
            Entry[] entryArray2 = this.hashTable;
            this.mask = n2;
            int n3 = entryArray.length;
            while (n3-- > 0) {
                Entry entry = entryArray[n3];
                while (entry != null) {
                    Entry entry2 = entry.nextInBucket;
                    int n4 = entry.hash & n2;
                    entry.nextInBucket = entryArray2[n4];
                    entryArray2[n4] = entry;
                    entry = entry2;
                }
            }
        }
    }

    public ArrayHashList<E> clone() {
        return new ArrayHashList<E>(this);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    protected boolean isElementIndex(int n) {
        return n >= 0 && n < this.size;
    }

    protected boolean isPositionIndex(int n) {
        return n >= 0 && n <= this.size;
    }

    protected String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    protected void checkElementIndex(int n) {
        if (!this.isElementIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    protected void checkPositionIndex(int n) {
        if (!this.isPositionIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = ArrayHashList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayHashList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int n = this.cursor;
            if (n >= ArrayHashList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayHashList.this.elementData;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = n + 1;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayHashList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayHashList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ArrayHashList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static final class Entry {
        protected final Object key;
        protected final int hash;
        protected Entry nextInBucket;

        protected Entry(Object object, int n) {
            this.key = object;
            this.hash = n;
        }
    }
}

