/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.nbt.NBTTagSmartByteArray;
import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.BlockPool;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.core.SideOffset;

public class TreeHarvestManager
implements IHarvestManager {
    private BlockPool _blocks;
    private boolean _isDone;
    private Map<String, Boolean> _settings;
    private HarvestMode _harvestMode;
    private Area _area;
    private World _world;

    public TreeHarvestManager(NBTTagCompound nBTTagCompound, Map<String, Boolean> map) {
        this.readFromNBT(nBTTagCompound);
        this._settings = map;
    }

    public TreeHarvestManager(World world, Area area, HarvestMode harvestMode, Map<String, Boolean> map) {
        this.reset(world, area, harvestMode, map);
        this._isDone = true;
    }

    @Override
    public BlockPosition getNextBlock() {
        BlockPool.BlockNode blockNode = this._blocks.shift();
        this.searchForTreeBlocks(blockNode);
        BlockPosition blockPosition = new BlockPosition(blockNode.x, blockNode.y, blockNode.z);
        blockNode.free();
        return blockPosition;
    }

    @Override
    public void moveNext() {
        if (this._blocks.size() == 0) {
            this._isDone = true;
        }
    }

    private void searchForTreeBlocks(BlockPool.BlockNode blockNode) {
        Map<Block, IFactoryHarvestable> map = MFRRegistry.getHarvestables();
        HarvestType harvestType = this.getType(blockNode, map);
        if (harvestType == null || harvestType == HarvestType.TreeFruit) {
            return;
        }
        for (SideOffset sideOffset : !this._harvestMode.isInverted ? SideOffset.ADJACENT_CUBE : SideOffset.ADJACENT_CUBE_INVERTED) {
            BlockPool.BlockNode blockNode2 = BlockPool.getNext(blockNode.x + sideOffset.offsetX, blockNode.y + sideOffset.offsetY, blockNode.z + sideOffset.offsetZ);
            this.addIfValid(this.getType(blockNode2, map), blockNode2);
        }
    }

    private void addIfValid(HarvestType harvestType, BlockPool.BlockNode blockNode) {
        if (harvestType != null) {
            if (harvestType == HarvestType.TreeFruit || harvestType == HarvestType.TreeLeaf) {
                this._blocks.unshift(blockNode);
                return;
            }
            if (harvestType == HarvestType.Tree || harvestType == HarvestType.TreeFlipped) {
                this._blocks.push(blockNode);
                return;
            }
        }
        blockNode.free();
    }

    private HarvestType getType(BlockPool.BlockNode blockNode, Map<Block, IFactoryHarvestable> map) {
        IFactoryHarvestable iFactoryHarvestable;
        Area area = this._area;
        if (blockNode.x < area.xMin || blockNode.x > area.xMax || blockNode.y < area.yMin || blockNode.y > area.yMax || blockNode.z < area.zMin || blockNode.z > area.zMax || !this._world.func_72899_e(blockNode.x, blockNode.y, blockNode.z)) {
            return null;
        }
        Block block = this._world.func_147439_a(blockNode.x, blockNode.y, blockNode.z);
        if (map.containsKey(block) && (iFactoryHarvestable = map.get(block)).canBeHarvested(this._world, this._settings, blockNode.x, blockNode.y, blockNode.z)) {
            return iFactoryHarvestable.getHarvestType();
        }
        return null;
    }

    @Override
    public void reset(World world, Area area, HarvestMode harvestMode, Map<String, Boolean> map) {
        this.setWorld(world);
        this._harvestMode = harvestMode;
        this._area = area;
        this.free();
        this._isDone = false;
        this._blocks = new BlockPool();
        BlockPosition blockPosition = area.getOrigin();
        this._blocks.push(BlockPool.getNext(blockPosition.x, blockPosition.y, blockPosition.z));
        this._settings = map;
    }

    @Override
    public void setWorld(World world) {
        this._world = world;
    }

    @Override
    public boolean getIsDone() {
        return this._isDone;
    }

    @Override
    public BlockPosition getOrigin() {
        return this._area.getOrigin();
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("done", this._isDone);
        nBTTagCompound2.func_74768_a("mode", this._harvestMode.ordinal());
        BlockPosition blockPosition = this.getOrigin();
        nBTTagCompound2.func_74783_a("area", new int[]{blockPosition.x - this._area.xMin, blockPosition.y - this._area.yMin, this._area.yMax - blockPosition.y});
        nBTTagCompound2.func_74783_a("origin", new int[]{blockPosition.x, blockPosition.y, blockPosition.z});
        NBTTagSmartByteArray nBTTagSmartByteArray = new NBTTagSmartByteArray(this._blocks.size() * 3 * 3);
        BlockPool.BlockNode blockNode = this._blocks.poke();
        nBTTagSmartByteArray.addVarInt(this._blocks.size());
        while (blockNode != null) {
            nBTTagSmartByteArray.addVarInt(blockNode.x).addVarInt(blockNode.y).addVarInt(blockNode.z);
            blockNode = blockNode.next;
        }
        nBTTagCompound2.func_74782_a("curPos", (NBTBase)nBTTagSmartByteArray);
        nBTTagCompound.func_74782_a("harvestManager", (NBTBase)nBTTagCompound2);
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.free();
        this._blocks = new BlockPool();
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("harvestManager");
        this._isDone = nBTTagCompound2.func_74767_n("done");
        this._harvestMode = HarvestMode.values()[nBTTagCompound2.func_74762_e("mode")];
        int[] nArray = nBTTagCompound2.func_74759_k("area");
        int[] nArray2 = nBTTagCompound2.func_74759_k("origin");
        if (nArray == null | nArray2 == null || nArray2.length < 3 | nArray.length < 3) {
            this._area = new Area(new BlockPosition(0, -1, 0), 0, 0, 0);
            this._isDone = true;
            return;
        }
        this._area = new Area(new BlockPosition(nArray2[0], nArray2[1], nArray2[2]), nArray[0], nArray[1], nArray[2]);
        NBTBase nBTBase = nBTTagCompound2.func_74781_a("curPos");
        if (nBTBase.func_74732_a() == 7) {
            PacketCoFHBase packetCoFHBase = new PacketCoFHBase(((NBTTagByteArray)nBTBase).func_150292_c()){

                public void handlePacket(EntityPlayer entityPlayer, boolean bl) {
                }
            };
            int n = packetCoFHBase.getVarInt();
            while (n-- > 0) {
                this._blocks.push(BlockPool.getNext(packetCoFHBase.getVarInt(), packetCoFHBase.getVarInt(), packetCoFHBase.getVarInt()));
            }
        } else {
            NBTTagList nBTTagList = (NBTTagList)nBTBase;
            if (nBTTagList.func_150303_d() == 11) {
                int n = nBTTagList.func_74745_c();
                for (int i = 0; i < n; ++i) {
                    int[] nArray3 = nBTTagList.func_150306_c(i);
                    this._blocks.push(BlockPool.getNext(nArray3[0], nArray3[1], nArray3[2]));
                }
            } else {
                int n = nBTTagList.func_74745_c();
                for (int i = 0; i < n; ++i) {
                    NBTTagCompound nBTTagCompound3 = nBTTagList.func_150305_b(i);
                    this._blocks.push(BlockPool.getNext(nBTTagCompound3.func_74762_e("x"), nBTTagCompound3.func_74762_e("y"), nBTTagCompound3.func_74762_e("z")));
                }
            }
        }
        if (this._blocks.size() == 0) {
            this._isDone = true;
        }
    }

    @Override
    public void free() {
        if (this._blocks != null) {
            while (this._blocks.poke() != null) {
                this._blocks.shift().free();
            }
        }
        this._isDone = true;
    }
}

