/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.client;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonManaged;
import cofh.lib.gui.element.ElementListBox;
import cofh.lib.gui.element.ElementSlider;
import cofh.lib.gui.element.listbox.IListBoxElement;
import cofh.lib.gui.element.listbox.SliderHorizontal;
import cofh.lib.gui.element.listbox.SliderVertical;
import cofh.lib.util.position.BlockPosition;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedClient;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.circuits.Noop;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.client.font.PrcFontRenderer;
import powercrystals.minefactoryreloaded.gui.control.ButtonLogicBufferSelect;
import powercrystals.minefactoryreloaded.gui.control.ButtonLogicPinSelect;
import powercrystals.minefactoryreloaded.gui.control.ListBoxElementCircuit;
import powercrystals.minefactoryreloaded.gui.control.LogicButtonType;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

public class GuiRedNetLogic
extends GuiBase {
    private static final int pinOffset = 13;
    private TileEntityRedNetLogic _logic;
    private int _selectedCircuit;
    private ElementListBox _circuitList;
    private ElementSlider _circuitScrollV;
    private ElementSlider _circuitScrollH;
    private ButtonLogicBufferSelect[] _inputIOBufferButtons = new ButtonLogicBufferSelect[16];
    private ButtonLogicBufferSelect[] _outputIOBufferButtons = new ButtonLogicBufferSelect[16];
    private ButtonLogicPinSelect[] _inputIOPinButtons = new ButtonLogicPinSelect[16];
    private ButtonLogicPinSelect[] _outputIOPinButtons = new ButtonLogicPinSelect[16];
    private ElementButtonManaged _nextCircuit;
    private ElementButtonManaged _prevCircuit;
    private ElementButtonManaged _reinit;
    private ElementButtonManaged _reinitConfirm;
    private boolean _listNeedsUpdated = true;
    private int _reinitCountdown;
    private FontRenderer uFontRenderer;
    private FontRenderer rFontRenderer;

    public GuiRedNetLogic(Container container, TileEntityRedNetLogic tileEntityRedNetLogic) {
        super(container, new ResourceLocation("minefactoryreloaded:textures/gui/rednetlogic.png"));
        ((GuiContainer)this).field_146999_f = 384;
        ((GuiContainer)this).field_147000_g = 231;
        this.drawInventory = false;
        this.drawTitle = false;
        this._logic = tileEntityRedNetLogic;
        this.name = tileEntityRedNetLogic.getBlockName();
    }

    public FontRenderer getFontRenderer() {
        return this.rFontRenderer;
    }

    public void func_73866_w_() {
        this.uFontRenderer = new FontRenderer(((GuiScreen)this).field_146297_k.field_71474_y, new ResourceLocation("textures/font/ascii.png"), ((GuiScreen)this).field_146297_k.field_71446_o, true);
        this.uFontRenderer.func_110549_a(((GuiScreen)this).field_146297_k.func_110442_L());
        this.rFontRenderer = new PrcFontRenderer(((GuiScreen)this).field_146297_k.field_71474_y, ((GuiScreen)this).field_146297_k.field_71446_o, false);
        this.rFontRenderer.func_110549_a(((GuiScreen)this).field_146297_k.func_110442_L());
        super.func_73866_w_();
        LinkedList<IRedNetLogicCircuit> linkedList = new LinkedList<IRedNetLogicCircuit>(MFRRegistry.getRedNetLogicCircuits());
        Collections.sort(linkedList, new CircuitComparator());
        boolean bl = false;
        for (IRedNetLogicCircuit object : linkedList) {
            if (!MFRUtil.containsForcedUnicode(MFRUtil.localize(object.getUnlocalizedName()))) continue;
            bl = true;
            break;
        }
        final FontRenderer fontRenderer = bl ? this.uFontRenderer : ((GuiScreen)this).field_146289_q;
        this._circuitList = new ElementListBox(this, 88, 17, 131, 196){

            protected void onSelectionChanged(int n, IListBoxElement iListBoxElement) {
            }

            public FontRenderer getFontRenderer() {
                return fontRenderer;
            }

            protected void onElementClicked(IListBoxElement iListBoxElement) {
                Packets.sendToServer((short)7, GuiRedNetLogic.this._logic, GuiRedNetLogic.this._selectedCircuit, iListBoxElement.getValue().getClass().getName());
            }

            protected void onScrollV(int n) {
                GuiRedNetLogic.this._circuitScrollV.setValue(n);
            }

            protected void onScrollH(int n) {
                GuiRedNetLogic.this._circuitScrollH.setValue(n);
            }
        };
        for (IRedNetLogicCircuit iRedNetLogicCircuit : linkedList) {
            this._circuitList.add((IListBoxElement)new ListBoxElementCircuit(this._circuitList, iRedNetLogicCircuit));
        }
        this.addElement((ElementBase)this._circuitList);
        this._circuitScrollV = new SliderVertical(this, 220, 17, 10, 196, this._circuitList.getLastScrollPosition()){

            public void onValueChanged(int n) {
                GuiRedNetLogic.this._circuitList.scrollToV(n);
            }
        };
        this.addElement((ElementBase)this._circuitScrollV);
        final int n = this._circuitList.getLastScrollPositionH();
        int n2 = (n + 14) / 15;
        int n3 = 142;
        this._circuitScrollH = new SliderHorizontal(this, 88, 214, n3, 10, n2){

            public void onValueChanged(int n2) {
                n2 = n2 >= ((ElementSlider)this)._valueMax ? n : n2 * 15;
                GuiRedNetLogic.this._circuitList.scrollToH(n2);
            }
        };
        this.addElement((ElementBase)this._circuitScrollH);
        this._prevCircuit = new ElementButtonManaged(this, 340, 76, 30, 30, "Prev"){

            public void onClick() {
                GuiRedNetLogic.this._selectedCircuit--;
                if (GuiRedNetLogic.this._selectedCircuit < 0) {
                    GuiRedNetLogic.this._selectedCircuit = GuiRedNetLogic.this._logic.getCircuitCount() - 1;
                }
                MineFactoryReloadedClient.prcPages.put(new BlockPosition((TileEntity)GuiRedNetLogic.this._logic), GuiRedNetLogic.this._selectedCircuit);
                GuiRedNetLogic.this.requestCircuit();
                GuiRedNetLogic.this._listNeedsUpdated = true;
            }
        };
        this._nextCircuit = new ElementButtonManaged(this, 340, 16, 30, 30, "Next"){

            public void onClick() {
                GuiRedNetLogic.this._selectedCircuit++;
                if (GuiRedNetLogic.this._selectedCircuit >= GuiRedNetLogic.this._logic.getCircuitCount()) {
                    GuiRedNetLogic.this._selectedCircuit = 0;
                }
                MineFactoryReloadedClient.prcPages.put(new BlockPosition((TileEntity)GuiRedNetLogic.this._logic), GuiRedNetLogic.this._selectedCircuit);
                GuiRedNetLogic.this.requestCircuit();
                GuiRedNetLogic.this._listNeedsUpdated = true;
            }
        };
        this.addElement((ElementBase)this._prevCircuit);
        this.addElement((ElementBase)this._nextCircuit);
        this._reinit = new ElementButtonManaged(this, 318, 205, 60, 20, "Reinitialize"){

            public void onClick() {
                GuiRedNetLogic.this._reinitCountdown = 55;
            }
        };
        this._reinitConfirm = new ElementButtonManaged(this, 318, 205, 60, 20, "Confirm"){

            public boolean isEnabled() {
                return super.isEnabled() && GuiRedNetLogic.this._reinitCountdown < 25;
            }

            public void onClick() {
                Packets.sendToServer((short)9, GuiRedNetLogic.this._logic, Minecraft.func_71410_x().field_71439_g.func_145782_y());
                GuiRedNetLogic.this._reinitCountdown = 0;
                GuiRedNetLogic.this._listNeedsUpdated = true;
            }
        };
        this.addElement((ElementBase)this._reinit);
        this.addElement((ElementBase)this._reinitConfirm);
        this._reinitConfirm.setVisible(false);
        int n4 = this._logic.func_145831_w().func_72805_g(this._logic.field_145851_c, this._logic.field_145848_d, this._logic.field_145849_e);
        for (int n5 = 0; n5 < this._inputIOPinButtons.length; ++n5) {
            this._inputIOBufferButtons[n5] = new ButtonLogicBufferSelect(this, 25, 16 + n5 * 13, n5, LogicButtonType.Input, n4);
            this._inputIOPinButtons[n5] = new ButtonLogicPinSelect(this, 54, 16 + n5 * 13, n5, LogicButtonType.Input);
            this._outputIOBufferButtons[n5] = new ButtonLogicBufferSelect(this, 254, 16 + n5 * 13, n5, LogicButtonType.Output, n4);
            this._outputIOPinButtons[n5] = new ButtonLogicPinSelect(this, 283, 16 + n5 * 13, n5, LogicButtonType.Output);
            this.addElement(this._inputIOBufferButtons[n5].setVisible(false));
            this.addElement(this._outputIOBufferButtons[n5].setVisible(false));
            this.addElement(this._inputIOPinButtons[n5].setVisible(false));
            this.addElement(this._outputIOPinButtons[n5].setVisible(false));
        }
        Integer n5 = MineFactoryReloadedClient.prcPages.get(new BlockPosition((TileEntity)this._logic));
        if (n5 != null && n5 < this._logic.getCircuitCount()) {
            this._selectedCircuit = n5;
        }
        this.requestCircuit();
    }

    public void updateElementInformation() {
        IRedNetLogicCircuit iRedNetLogicCircuit = this._logic.getLastCircuit(this._selectedCircuit);
        if (iRedNetLogicCircuit != null && iRedNetLogicCircuit != this._logic.getCircuit(this._selectedCircuit)) {
            int n;
            if (this._listNeedsUpdated) {
                for (n = 0; n < this._circuitList.getElementCount(); ++n) {
                    if (((IRedNetLogicCircuit)this._circuitList.getElement(n).getValue()).getClass() != this._logic.getCircuit(this._selectedCircuit).getClass()) continue;
                    this._circuitList.setSelectedIndex(n);
                    this._circuitScrollV.setValue(Math.min(n, this._circuitList.getLastScrollPosition()));
                    break;
                }
                this._listNeedsUpdated = false;
            }
            for (n = 0; n < this._inputIOPinButtons.length; ++n) {
                if (n < this._logic.getCircuit(this._selectedCircuit).getInputCount()) {
                    this._inputIOPinButtons[n].setVisible(true);
                    this._inputIOBufferButtons[n].setVisible(true);
                    this._inputIOPinButtons[n].setPin(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).pin);
                    this._inputIOPinButtons[n].setBuffer(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    this._inputIOBufferButtons[n].setBuffer(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    continue;
                }
                this._inputIOBufferButtons[n].setVisible(false);
                this._inputIOPinButtons[n].setVisible(false);
            }
            for (n = 0; n < this._outputIOPinButtons.length; ++n) {
                if (n < this._logic.getCircuit(this._selectedCircuit).getOutputCount()) {
                    this._outputIOBufferButtons[n].setVisible(true);
                    this._outputIOPinButtons[n].setVisible(true);
                    this._outputIOPinButtons[n].setPin(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).pin);
                    this._outputIOPinButtons[n].setBuffer(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    this._outputIOBufferButtons[n].setBuffer(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    continue;
                }
                this._outputIOBufferButtons[n].setVisible(false);
                this._outputIOPinButtons[n].setVisible(false);
            }
        }
        if (this._reinitCountdown > 0) {
            --this._reinitCountdown;
        }
        this._reinit.setVisible(this._reinitCountdown == 0);
        this._reinitConfirm.setVisible(this._reinitCountdown > 0);
    }

    protected void func_146979_b(int n, int n2) {
        int n3;
        super.func_146979_b(n, n2);
        String string = this.name;
        if (string == null) {
            string = MFRUtil.localize("tile.mfr.rednet.logic");
        }
        FontRenderer fontRenderer = MFRUtil.containsForcedUnicode(string) ? this.uFontRenderer : ((GuiScreen)this).field_146289_q;
        fontRenderer.func_78276_b(string, 8, 5, 0x404040);
        String string2 = String.valueOf(this._logic.getCircuitCount());
        int n4 = 370 - (string2.length() == 1 ? ((GuiScreen)this).field_146289_q.func_78263_a('0') : 0);
        string2 = this._selectedCircuit + 1 + "/" + string2;
        ((GuiScreen)this).field_146289_q.func_78276_b(string2, n4 - ((GuiScreen)this).field_146289_q.func_78256_a(string2), 58, 0x404040);
        for (n3 = 0; n3 < this._inputIOPinButtons.length; ++n3) {
            if (n3 >= this._logic.getCircuit(this._selectedCircuit).getInputCount()) continue;
            this.rFontRenderer.func_78276_b(this._logic.getCircuit(this._selectedCircuit).getInputPinLabel(n3), 5, 20 + n3 * 13, 0x404040);
        }
        for (n3 = 0; n3 < this._outputIOPinButtons.length; ++n3) {
            if (n3 >= this._logic.getCircuit(this._selectedCircuit).getOutputCount()) continue;
            this.rFontRenderer.func_78276_b(this._logic.getCircuit(this._selectedCircuit).getOutputPinLabel(n3), 234, 20 + n3 * 13, 0x404040);
        }
    }

    protected void func_146976_a(float f, int n, int n2) {
        this.mouseX = n - ((GuiContainer)this).field_147003_i;
        this.mouseY = n2 - ((GuiContainer)this).field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.drawLargeTexturedModalRect(((GuiContainer)this).field_147003_i, ((GuiContainer)this).field_147009_r, 0, 0, ((GuiContainer)this).field_146999_f, ((GuiContainer)this).field_147000_g);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((GuiContainer)this).field_147003_i, (float)((GuiContainer)this).field_147009_r, (float)0.0f);
        this.drawElements(f, false);
        this.drawTabs(f, false);
        GL11.glPopMatrix();
    }

    public void drawLargeTexturedModalRect(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.0026041667f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n6), (double)((Gui)this).field_73735_i, (double)((float)(n3 + 0) * f), (double)((float)(n4 + n6) * f2));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + n6), (double)((Gui)this).field_73735_i, (double)((float)(n3 + n5) * f), (double)((float)(n4 + n6) * f2));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)((float)(n3 + n5) * f), (double)((float)(n4 + 0) * f2));
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)((float)(n3 + 0) * f), (double)((float)(n4 + 0) * f2));
        tessellator.func_78381_a();
    }

    public TileEntityRedNetLogic.PinMapping getInputPin(int n) {
        return this._logic.getInputPinMapping(this._selectedCircuit, n);
    }

    public TileEntityRedNetLogic.PinMapping getOutputPin(int n) {
        return this._logic.getOutputPinMapping(this._selectedCircuit, n);
    }

    private void requestCircuit() {
        Packets.sendToServer((short)6, this._logic, this._selectedCircuit);
    }

    public void setInputPinMapping(int n, int n2, int n3) {
        Packets.sendToServer((short)8, this._logic, (byte)0, this._selectedCircuit, n, n2, n3);
    }

    public void setOutputPinMapping(int n, int n2, int n3) {
        Packets.sendToServer((short)8, this._logic, (byte)1, this._selectedCircuit, n, n2, n3);
    }

    public int getVariableCount() {
        return this._logic.getVariableBufferSize();
    }

    private class CircuitComparator
    implements Comparator<IRedNetLogicCircuit> {
        private CircuitComparator() {
        }

        @Override
        public int compare(IRedNetLogicCircuit iRedNetLogicCircuit, IRedNetLogicCircuit iRedNetLogicCircuit2) {
            boolean bl = iRedNetLogicCircuit instanceof Noop;
            boolean bl2 = iRedNetLogicCircuit2 instanceof Noop;
            if (bl != bl2) {
                return bl ? -1 : 1;
            }
            return MFRUtil.localize(iRedNetLogicCircuit.getUnlocalizedName()).compareTo(MFRUtil.localize(iRedNetLogicCircuit2.getUnlocalizedName()));
        }
    }
}

