/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item.gun.ammo;

import cofh.lib.util.position.BlockPosition;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.item.gun.ammo.ItemNeedlegunAmmoStandard;

public class ItemNeedlegunAmmoBlock
extends ItemNeedlegunAmmoStandard {
    protected Block _block;
    protected int _blockMeta;

    public ItemNeedlegunAmmoBlock(Block block, int n, float f) {
        super(2, f, 4);
        if (block == null) {
            throw new IllegalArgumentException("Null block");
        }
        this._block = block;
        this._blockMeta = n;
    }

    public ItemNeedlegunAmmoBlock(Block block, int n) {
        this(block, n, 1.5f);
    }

    @Override
    public void onHitBlock(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, double d) {
        BlockPosition blockPosition = new BlockPosition(n, n2, n3, ForgeDirection.getOrientation((int)n4));
        blockPosition.moveForwards(1);
        this.placeBlockAt(world, blockPosition.x, blockPosition.y, blockPosition.z, d);
    }

    protected Vec3 calculatePlacement(Entity entity) {
        AxisAlignedBB axisAlignedBB = entity.field_70121_D;
        int n = MathHelper.func_76128_c((double)(axisAlignedBB.field_72340_a + 0.001));
        int n2 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72339_c + 0.001));
        int n3 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72336_d - 0.001));
        int n4 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72334_f - 0.001));
        return Vec3.func_72443_a((double)((n + n3) / 2), (double)(axisAlignedBB.field_72338_b + 0.25), (double)((n2 + n4) / 2));
    }

    @Override
    public boolean onHitEntity(ItemStack itemStack, EntityPlayer entityPlayer, Entity entity, double d) {
        super.onHitEntity(itemStack, entityPlayer, entity, d);
        Vec3 vec3 = this.calculatePlacement(entity);
        this.placeBlockAt(entity.field_70170_p, (int)vec3.field_72450_a, (int)vec3.field_72448_b, (int)vec3.field_72449_c, d);
        return true;
    }

    @Override
    public float getSpread(ItemStack itemStack) {
        return 1.5f;
    }

    protected void placeBlockAt(World world, int n, int n2, int n3, double d) {
        Block block = world.func_147439_a(n, n2, n3);
        if (!world.field_72995_K && (block == null || block.isAir((IBlockAccess)world, n, n2, n3) || block.isReplaceable((IBlockAccess)world, n, n2, n3))) {
            world.func_147465_d(n, n2, n3, this._block, this._blockMeta, 3);
        }
    }
}

