/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.PaintingUtil;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemLock;
import jds.bibliocraft.items.ItemPaintingCanvas;
import jds.bibliocraft.tileentities.TileEntityPainting;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPainting
extends BlockContainer {
    public int angle;
    public String customTexture = "none";

    public BlockPainting() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(BlockLoader.biblioTab);
        this.func_149711_c(2.5f);
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting painting = (TileEntityPainting)tile;
            ItemStack playerhand = player.func_70694_bm();
            String playername = player.getDisplayName();
            boolean islocked = false;
            String lockeename = "";
            if (painting != null) {
                islocked = painting.isLocked();
                lockeename = painting.getLockee();
            }
            if (playerhand != null && !world.field_72995_K && playerhand.func_77973_b() instanceof ItemLock && painting != null) {
                if (islocked) {
                    if (playername.contains(lockeename)) {
                        painting.setLocked(false);
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.unlocked")));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
                    }
                } else {
                    painting.setLocked(true);
                    painting.setLockee(playername);
                    player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.locked")));
                }
                return true;
            }
            if (!islocked || playername.contains(lockeename)) {
                if (!world.field_72995_K) {
                    if (playerhand != null) {
                        if (playerhand.func_77973_b() instanceof ItemPaintingCanvas) {
                            int stacksize = painting.addPainting(playerhand);
                            if (stacksize == 0) {
                                painting.resetPaintingData();
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                                return true;
                            }
                            if (stacksize > 0) {
                                painting.resetPaintingData();
                                playerhand.field_77994_a = stacksize;
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerhand);
                                return true;
                            }
                        }
                        if (playerhand.func_77973_b() instanceof ItemDrill) {
                            return false;
                        }
                    }
                    if (player.func_70093_af() && painting.hasPainting()) {
                        this.dropPainting(world, i, j, k);
                        painting.addPainting(null);
                        return true;
                    }
                    player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
                    return true;
                }
                if (playerhand != null) {
                    if (playerhand.func_77973_b() instanceof ItemDrill) {
                        return false;
                    }
                    if (playerhand.func_77973_b() instanceof ItemPaintingCanvas) {
                        String name;
                        int paintingNum;
                        NBTTagCompound paintingTags = playerhand.func_77978_p();
                        if (paintingTags == null || paintingTags.func_74764_b("paintingType")) {
                            // empty if block
                        }
                        if (paintingTags.func_74762_e("paintingType") == 2 && PaintingUtil.customArtNames != null && (paintingNum = this.getCustomPaintingNum(name = paintingTags.func_74779_i("paintingTitle"))) >= 0) {
                            int resx = PaintingUtil.customArtWidths[paintingNum];
                            int resy = PaintingUtil.customArtHeights[paintingNum];
                            int aspectX = 1;
                            int aspectY = 1;
                            if (resx <= resy) {
                                aspectX = this.roundNum((float)resx * 1.0f / (float)resx * 1.0f);
                                aspectY = this.roundNum((float)resy * 1.0f / (float)resx * 1.0f);
                            } else {
                                aspectX = this.roundNum((float)resx * 1.0f / (float)resy * 1.0f);
                                aspectY = this.roundNum((float)resy * 1.0f / (float)resy * 1.0f);
                            }
                            ByteBuf buffer = Unpooled.buffer();
                            buffer.writeInt(i);
                            buffer.writeInt(j);
                            buffer.writeInt(k);
                            buffer.writeInt(aspectX);
                            buffer.writeInt(aspectY);
                            BiblioCraft.ch_BiblioPaintingC.sendToServer(new FMLProxyPacket(buffer, "BiblioPaintingC"));
                        }
                    }
                }
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
            }
        }
        return true;
    }

    private int getCustomPaintingNum(String paintingName) {
        for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
            if (!PaintingUtil.customArtNames[i].contentEquals(paintingName)) continue;
            return i;
        }
        return -1;
    }

    private int roundNum(float num) {
        int roundDown = (int)num;
        float roundTest = num - (float)roundDown;
        if (roundTest >= 0.5f || roundDown == 0) {
            return roundDown + 1;
        }
        return roundDown;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_spruce");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 6; ++x) {
            subItems.add(new ItemStack(par1, 1, x));
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity te = blockAccess.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPainting) {
            TileEntityPainting tile = (TileEntityPainting)te;
            int angleGet = tile.getAngle();
            switch (angleGet) {
                case 0: {
                    this.func_149676_a(0.92f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.0f, 0.0f, 0.92f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.08f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.08f);
                    break;
                }
                default: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
                }
            }
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.paintingRenderID;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        this.angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++this.angle;
        this.angle %= 4;
        TileEntityPainting tile = (TileEntityPainting)world.func_147438_o(i, j, k);
        tile.setAngle(this.angle);
        tile.setFrameStyle(this.frameType());
        NBTTagCompound tags = itemStack.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            tile.setCustomTex(tags.func_74779_i("renderTexture"));
        }
        this.onBlockPlacedExtras(world, i, j, k, tile, this.angle, this.frameType(), true);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting furniture = (TileEntityPainting)tile;
            this.customTexture = furniture.getCustomTexString();
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ItemStack newStack = new ItemStack(item, 1, this.func_149692_a(metadata));
            if (metadata == 6 && !this.customTexture.contentEquals("none") && !this.customTexture.contentEquals("")) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74778_a("renderTexture", this.customTexture);
                newStack.func_77982_d(tags);
            }
            ret.add(newStack);
        }
        return ret;
    }

    public int frameType() {
        return 0;
    }

    public void onBlockPlacedExtras(World world, int i, int j, int k, TileEntityPainting tile, int angle, int frameType, boolean recurse) {
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        this.disconnectFrame(world, i, j, k);
        this.dropItems(world, i, j, k);
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    private void disconnectFrame(World world, int i, int j, int k) {
        if (!world.field_72995_K) {
            TileEntityPainting tile;
            TileEntityPainting pright;
            TileEntityPainting pleft;
            TileEntityPainting pdown;
            TileEntityPainting pup;
            TileEntity tup = world.func_147438_o(i, j + 1, k);
            TileEntity tdown = world.func_147438_o(i, j - 1, k);
            TileEntity tleft = null;
            TileEntity tright = null;
            switch (this.angle) {
                case 0: {
                    tleft = world.func_147438_o(i, j, k - 1);
                    tright = world.func_147438_o(i, j, k + 1);
                    break;
                }
                case 1: {
                    tleft = world.func_147438_o(i + 1, j, k);
                    tright = world.func_147438_o(i - 1, j, k);
                    break;
                }
                case 2: {
                    tleft = world.func_147438_o(i, j, k + 1);
                    tright = world.func_147438_o(i, j, k - 1);
                    break;
                }
                case 3: {
                    tleft = world.func_147438_o(i - 1, j, k);
                    tright = world.func_147438_o(i + 1, j, k);
                }
            }
            if (tup != null && tup instanceof TileEntityPainting && this.angle == (pup = (TileEntityPainting)tup).getAngle()) {
                pup.setConnectBottom(false);
            }
            if (tdown != null && tdown instanceof TileEntityPainting && this.angle == (pdown = (TileEntityPainting)tdown).getAngle()) {
                pdown.setConnectTop(false);
            }
            if (tleft != null && tleft instanceof TileEntityPainting && this.angle == (pleft = (TileEntityPainting)tleft).getAngle()) {
                pleft.setConnectRight(false);
            }
            if (tright != null && tright instanceof TileEntityPainting && this.angle == (pright = (TileEntityPainting)tright).getAngle()) {
                pright.setConnectLeft(false);
            }
            if ((tile = (TileEntityPainting)world.func_147438_o(i, j, k)) != null) {
                tile.setConnectBottom(false);
                tile.setConnectLeft(false);
                tile.setConnectRight(false);
                tile.setConnectTop(false);
                if (tile.getAngle() == 0 || tile.getAngle() == 2) {
                    world.func_147459_d(i, j + 1, k - 1, BlockLoader.paintingBorderless);
                    world.func_147460_e(i, j + 1, k + 1, BlockLoader.paintingBorderless);
                    world.func_147460_e(i, j - 1, k - 1, BlockLoader.paintingBorderless);
                    world.func_147460_e(i, j - 1, k + 1, BlockLoader.paintingBorderless);
                } else {
                    world.func_147459_d(i + 1, j + 1, k, BlockLoader.paintingBorderless);
                    world.func_147460_e(i - 1, j + 1, k, BlockLoader.paintingBorderless);
                    world.func_147460_e(i + 1, j - 1, k, BlockLoader.paintingBorderless);
                    world.func_147460_e(i - 1, j - 1, k, BlockLoader.paintingBorderless);
                }
            }
        }
    }

    private void dropItems(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == null || item.field_77994_a <= 0) continue;
            float ri = rando.nextFloat() * 0.8f + 0.1f;
            float rj = rando.nextFloat() * 0.8f + 0.1f;
            float rk = rando.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + ri), (double)((float)j + rj), (double)((float)k + rk), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rando.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rando.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rando.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    private void dropPainting(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        ItemStack item = inventory.func_70301_a(0);
        if (item != null && item.field_77994_a > 0) {
            EntityItem entityItem = new EntityItem(world, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return new TileEntityPainting();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting te = (TileEntityPainting)tile;
            int angle = te.getAngle();
            switch (axis) {
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        String customTexture;
        TileEntityPainting tile;
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        BlockPainting block = item instanceof ItemBlock && !this.func_149648_K() ? Block.func_149634_a((Item)item) : this;
        ItemStack stack = new ItemStack(item, 1, block.func_149643_k(world, x, y, z));
        TileEntity wtile = world.func_147438_o(x, y, z);
        if (!(wtile == null || !(wtile instanceof TileEntityPainting) || (tile = (TileEntityPainting)wtile).func_145832_p() != 6 || (customTexture = tile.getCustomTexString()).equals("none") && customTexture.equals(""))) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("renderTexture", customTexture);
            stack.func_77982_d(tags);
        }
        return stack;
    }
}

