/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityTier1Rocket
extends EntityTieredRocket {
    public EntityTier1Rocket(World par1World) {
        super(par1World);
        this.func_70105_a(1.2f, 3.5f);
        this.field_70129_M = 1.5f;
    }

    public EntityTier1Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        this.func_70105_a(1.2f, 3.5f);
        this.field_70129_M = 1.5f;
    }

    @Override
    public float getRotateOffset() {
        return -1.5f;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(GCItems.rocketTier1, 1, this.rocketType.getIndex());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (!this.landing) {
                double d = this.timeSinceLaunch / 150.0f;
                d = this.field_70170_p.field_73011_w instanceof WorldProviderSpace && !((WorldProviderSpace)this.field_70170_p.field_73011_w).hasAtmosphere() ? Math.min(d * 1.2, 1.6) : Math.min(d, 1.0);
                if (d != 0.0) {
                    this.field_70181_x = -d * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    @Override
    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, false);
        if (playerBase != null) {
            GCPlayerStats stats = GCPlayerStats.get(player);
            stats.rocketStacks = this.cargoItems == null || this.cargoItems.length == 0 ? new ItemStack[2] : this.cargoItems;
            stats.rocketType = this.rocketType.getIndex();
            stats.rocketItem = GCItems.rocketTier1;
            stats.fuelLevel = this.fuelTank.getFluidAmount();
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            EntityLivingBase riddenByEntity;
            double x1 = 2.0 * Math.cos((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
            double z1 = 2.0 * Math.sin((double)this.field_70177_z * Math.PI / 180.0) * Math.sin((double)this.field_70125_A * Math.PI / 180.0);
            double y1 = 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
            if (this.landing && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.y;
                modifier = Math.min(Math.max(modifier, 120.0), 300.0);
                x1 *= modifier / 100.0;
                y1 *= modifier / 100.0;
                z1 *= modifier / 100.0;
            }
            double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - this.field_70181_x;
            double x2 = this.field_70165_t + x1 - this.field_70159_w;
            double z2 = this.field_70161_v + z1 - this.field_70179_y;
            EntityLivingBase entityLivingBase = riddenByEntity = this.field_70153_n instanceof EntityLivingBase ? (EntityLivingBase)this.field_70153_n : null;
            if (this.getLaunched()) {
                Vector3 motionVec = new Vector3(x1, y1, z1);
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y, z2), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y, z2), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y, z2), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y, z2 + 0.4), motionVec, new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y, z2 - 0.4), motionVec, new Object[]{riddenByEntity});
            } else {
                GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.7, y1 - 1.0, z1 + 0.7), new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.7, y1 - 1.0, z1 + 0.7), new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.7, y1 - 1.0, z1 - 0.7), new Object[]{riddenByEntity});
                GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.7, y1 - 1.0, z1 - 0.7), new Object[]{riddenByEntity});
            }
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return !this.field_70128_L && par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    @Override
    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    @Override
    public int getPreLaunchWait() {
        return 400;
    }

    @Override
    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(GCItems.rocketTier1, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad;
    }

    @Override
    public int getRocketTier() {
        return 1;
    }

    @Override
    public int getFuelTankCapacity() {
        return 1000;
    }

    @Override
    public float getCameraZoom() {
        return 15.0f;
    }

    @Override
    public boolean defaultThirdPerson() {
        return true;
    }

    @Override
    public double getOnPadYOffset() {
        return 1.5;
    }
}

