/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ThreadFindSeal {
    public AtomicBoolean sealedFinal = new AtomicBoolean();
    public static AtomicBoolean anylooping = new AtomicBoolean();
    public AtomicBoolean looping = new AtomicBoolean();
    private World world;
    private BlockVec3 head;
    private boolean sealed;
    private List<TileEntityOxygenSealer> sealers;
    private intBucket[] buckets = new intBucket[256];
    private int checkedSize = 0;
    private int checkCount;
    private HashMap<BlockVec3, TileEntityOxygenSealer> sealersAround;
    private List<BlockVec3> currentLayer;
    private List<BlockVec3> airToReplace;
    private List<BlockVec3> breatheableToReplace;
    private List<BlockVec3> airToReplaceBright;
    private List<BlockVec3> breatheableToReplaceBright;
    private List<BlockVec3> ambientThermalTracked;
    private List<TileEntityOxygenSealer> otherSealers;
    private List<BlockVec3> torchesToUpdate;
    private boolean foundAmbientThermal;
    public List<BlockVec3> leakTrace;

    public ThreadFindSeal(TileEntityOxygenSealer sealer) {
        this(sealer.func_145831_w(), new BlockVec3(sealer).translate(0, 1, 0), sealer.getFindSealChecks(), new ArrayList<TileEntityOxygenSealer>(Arrays.asList(sealer)));
    }

    public ThreadFindSeal(World world, BlockVec3 head, int checkCount, List<TileEntityOxygenSealer> sealers) {
        this.world = world;
        this.head = head;
        this.checkCount = checkCount;
        this.sealers = sealers;
        this.foundAmbientThermal = false;
        this.checkedInit();
        this.torchesToUpdate = new LinkedList<BlockVec3>();
        this.sealersAround = TileEntityOxygenSealer.getSealersAround(world, head.x, head.y, head.z, 0x100000);
        if (!sealers.isEmpty()) {
            Block headBlock;
            if (checkCount > 0 && (headBlock = head.getBlockID(this.world)) != null && !headBlock.isAir((IBlockAccess)world, head.x, head.y, head.z)) {
                this.canBlockPassAirCheck(headBlock, this.head, 1);
                this.checkCount = checkCount;
            }
            this.looping.set(true);
            for (TileEntityOxygenSealer eachSealer : sealers) {
                eachSealer.threadSeal = this;
            }
            this.check();
        } else {
            this.check();
        }
    }

    public void check() {
        long time1 = System.nanoTime();
        this.sealed = true;
        TileEntity tile = this.head.getTileEntityOnSide(this.world, ForgeDirection.DOWN);
        this.foundAmbientThermal = tile instanceof TileEntityOxygenSealer && ((TileEntityOxygenSealer)tile).thermalControlEnabled();
        this.checkedAdd(this.head.clone());
        this.currentLayer = new LinkedList<BlockVec3>();
        this.airToReplace = new LinkedList<BlockVec3>();
        this.airToReplaceBright = new LinkedList<BlockVec3>();
        this.ambientThermalTracked = new LinkedList<BlockVec3>();
        if (this.checkCount > 0) {
            this.currentLayer.add(this.head);
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                Block b = this.head.getBlockID_noChunkLoad(this.world);
                if (Blocks.field_150350_a == b) {
                    this.airToReplace.add(this.head.clone());
                } else if (b == GCBlocks.brightAir) {
                    this.airToReplaceBright.add(this.head.clone());
                }
                this.doLayerNearMapEdge();
            } else {
                Block headblock = this.head.getBlockIDsafe_noChunkLoad(this.world);
                if (Blocks.field_150350_a == headblock) {
                    this.airToReplace.add(this.head.clone());
                } else if (headblock == GCBlocks.brightAir) {
                    this.airToReplaceBright.add(this.head.clone());
                }
                this.doLayer();
            }
        } else {
            this.sealed = false;
        }
        long time2 = System.nanoTime();
        if (this.sealers.isEmpty()) {
            this.sealed = false;
        }
        if (this.sealed) {
            this.makeSealGood(this.foundAmbientThermal);
            this.leakTrace = null;
        } else {
            int checkedSave = this.checkedSize;
            this.checkedClear();
            this.breatheableToReplace = new LinkedList<BlockVec3>();
            this.breatheableToReplaceBright = new LinkedList<BlockVec3>();
            this.otherSealers = new LinkedList<TileEntityOxygenSealer>();
            this.currentLayer.clear();
            this.currentLayer.add(this.head);
            this.torchesToUpdate.clear();
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                this.unsealNearMapEdge();
            } else {
                this.unseal();
            }
            if (!this.otherSealers.isEmpty()) {
                List<TileEntityOxygenSealer> sealersSave = this.sealers;
                List<BlockVec3> torchesSave = this.torchesToUpdate;
                ArrayList<TileEntityOxygenSealer> sealersDone = new ArrayList<TileEntityOxygenSealer>();
                sealersDone.addAll(this.sealers);
                for (TileEntityOxygenSealer otherSealer : this.otherSealers) {
                    if (sealersDone.contains(otherSealer) || otherSealer.getFindSealChecks() <= 0) continue;
                    BlockVec3 newhead = new BlockVec3(otherSealer).translate(0, 1, 0);
                    this.sealed = true;
                    this.checkCount = otherSealer.getFindSealChecks();
                    this.sealers = new LinkedList<TileEntityOxygenSealer>();
                    this.sealers.add(otherSealer);
                    if (otherSealer.thermalControlEnabled()) {
                        this.foundAmbientThermal = true;
                    }
                    this.checkedClear();
                    this.checkedAdd(newhead);
                    this.currentLayer.clear();
                    this.airToReplace.clear();
                    this.airToReplaceBright.clear();
                    this.torchesToUpdate = new LinkedList<BlockVec3>();
                    this.currentLayer.add(newhead.clone());
                    if (newhead.x < -29990000 || newhead.z < -29990000 || newhead.x >= 29990000 || newhead.z >= 29990000) {
                        this.doLayerNearMapEdge();
                    } else {
                        this.doLayer();
                    }
                    if (this.sealed) {
                        TileEntityOxygenSealer oldHead;
                        if (ConfigManagerCore.enableDebug) {
                            GCLog.info("Oxygen Sealer replacing head at x" + this.head.x + " y" + (this.head.y - 1) + " z" + this.head.z);
                        }
                        if (!sealersSave.isEmpty() && !this.sealers.contains(oldHead = (TileEntityOxygenSealer)sealersSave.get(0))) {
                            this.sealers.add(oldHead);
                            if (oldHead.thermalControlEnabled()) {
                                this.foundAmbientThermal = true;
                            }
                        }
                        this.head = newhead.clone();
                        otherSealer.threadSeal = this;
                        otherSealer.stopSealThreadCooldown = 75 + TileEntityOxygenSealer.countEntities;
                        checkedSave += this.checkedSize;
                        break;
                    }
                    sealersDone.addAll(this.sealers);
                    checkedSave += this.checkedSize;
                }
                if (!this.sealed) {
                    this.sealers = sealersSave;
                    this.torchesToUpdate = torchesSave;
                } else {
                    this.makeSealGood(this.foundAmbientThermal);
                }
            }
            this.checkedSize = checkedSave;
            if (!this.sealed) {
                if (this.head.getBlockID(this.world) == GCBlocks.breatheableAir) {
                    this.breatheableToReplace.add(this.head);
                }
                if (this.head.getBlockID(this.world) == GCBlocks.brightBreatheableAir) {
                    this.breatheableToReplaceBright.add(this.head);
                }
                this.makeSealBad();
            } else {
                this.leakTrace = null;
            }
        }
        TileEntityOxygenSealer headSealer = this.sealersAround.get(this.head.clone().translate(0, -1, 0));
        if (headSealer != null) {
            headSealer.stopSealThreadCooldown = 75 + TileEntityOxygenSealer.countEntities;
        }
        for (TileEntityOxygenSealer sealer : this.sealers) {
            if (sealer == headSealer || headSealer == null) continue;
            sealer.threadSeal = this;
            sealer.stopSealThreadCooldown = headSealer.stopSealThreadCooldown + 51;
        }
        this.sealedFinal.set(this.sealed);
        this.looping.set(false);
        if (ConfigManagerCore.enableDebug) {
            long time3 = System.nanoTime();
            float total = (float)(time3 - time1) / 1000000.0f;
            float looping = (float)(time2 - time1) / 1000000.0f;
            float replacing = (float)(time3 - time2) / 1000000.0f;
            GCLog.info("Oxygen Sealer Check Completed at x" + this.head.x + " y" + this.head.y + " z" + this.head.z);
            GCLog.info("   Sealed: " + this.sealed + "  ~  " + this.sealers.size() + " sealers  ~  " + (this.checkedSize - 1) + " blocks");
            GCLog.info("   Total Time taken: " + String.format("%.2f", Float.valueOf(total)) + "ms  ~  " + String.format("%.2f", Float.valueOf(looping)) + " + " + String.format("%.2f", Float.valueOf(replacing)) + "");
        }
    }

    private void makeSealGood(boolean ambientThermal) {
        if (!(this.airToReplace.isEmpty() && this.airToReplaceBright.isEmpty() && this.ambientThermalTracked.isEmpty())) {
            LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
            Block breatheableAirID = GCBlocks.breatheableAir;
            int metadata = 0;
            if (ambientThermal) {
                metadata = 1;
            }
            for (BlockVec3 checkedVec : this.airToReplace) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), breatheableAirID, metadata, 2));
            }
            for (BlockVec3 checkedVec : this.airToReplaceBright) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), GCBlocks.brightBreatheableAir, metadata, 2));
            }
            for (BlockVec3 checkedVec : this.ambientThermalTracked) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), checkedVec.getBlock((IBlockAccess)this.world), metadata, 3));
            }
            TickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
        }
        if (!this.torchesToUpdate.isEmpty()) {
            TickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
        }
    }

    private void makeSealBad() {
        if (!this.breatheableToReplace.isEmpty() || !this.breatheableToReplaceBright.isEmpty()) {
            LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
            for (BlockVec3 checkedVec : this.breatheableToReplace) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), Blocks.field_150350_a, 0, 2));
            }
            for (BlockVec3 checkedVec : this.breatheableToReplaceBright) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), GCBlocks.brightAir, 0, 2));
            }
            TickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
        }
        if (!this.torchesToUpdate.isEmpty()) {
            TickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
        }
    }

    private void unseal() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        BlockFire fireBlock = Blocks.field_150480_ab;
        Block airBlock = Blocks.field_150350_a;
        Block airBlockBright = GCBlocks.brightAir;
        List<BlockVec3> toReplaceLocal = this.breatheableToReplace;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        World world = this.world;
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                int bits = vec.sideDoneBits;
                do {
                    if ((bits & 1 << side) != 0 || this.checkedContains(vec, side)) continue;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    Block id = sideVec.getBlockIDsafe_noChunkLoad(world);
                    if (id == breatheableAirID) {
                        toReplaceLocal.add(sideVec);
                        nextLayer.add(sideVec);
                        this.checkedAdd(sideVec);
                        continue;
                    }
                    if (id == breatheableAirIDBright) {
                        this.breatheableToReplaceBright.add(sideVec);
                        nextLayer.add(sideVec);
                        this.checkedAdd(sideVec);
                        continue;
                    }
                    if (id == fireBlock) {
                        toReplaceLocal.add(sideVec);
                        nextLayer.add(sideVec);
                        this.checkedAdd(sideVec);
                        continue;
                    }
                    if (id == oxygenSealerID) {
                        TileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                        if (sealer != null && !this.sealers.contains(sealer)) {
                            if (side != 0) continue;
                            this.otherSealers.add(sealer);
                            this.checkedAdd(sideVec);
                            continue;
                        }
                        this.checkedAdd(sideVec);
                        continue;
                    }
                    if (id != null && id != airBlock && id != airBlockBright) {
                        if (!this.canBlockPassAirCheck(id, sideVec, side)) continue;
                        nextLayer.add(sideVec);
                        continue;
                    }
                    if (id == null) continue;
                    this.checkedAdd(sideVec);
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void unsealNearMapEdge() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        BlockFire fireBlock = Blocks.field_150480_ab;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int bits = vec.sideDoneBits;
                int side = 0;
                do {
                    if ((bits & 1 << side) == 1) continue;
                    if (!this.checkedContains(vec, side)) {
                        BlockVec3 sideVec = vec.newVecSide(side);
                        Block id = sideVec.getBlockID_noChunkLoad(this.world);
                        if (id == breatheableAirID) {
                            this.breatheableToReplace.add(sideVec);
                            nextLayer.add(sideVec);
                            this.checkedAdd(sideVec);
                        } else if (id == breatheableAirIDBright) {
                            this.breatheableToReplaceBright.add(sideVec);
                            nextLayer.add(sideVec);
                            this.checkedAdd(sideVec);
                        } else if (id == fireBlock) {
                            nextLayer.add(sideVec);
                            this.breatheableToReplace.add(sideVec);
                            this.checkedAdd(sideVec);
                        } else if (id == oxygenSealerID) {
                            TileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                            if (sealer != null && !this.sealers.contains(sealer)) {
                                if (side == 0) {
                                    this.otherSealers.add(sealer);
                                    this.checkedAdd(sideVec);
                                }
                            } else {
                                this.checkedAdd(sideVec);
                            }
                        } else if (id != null && Blocks.field_150350_a != id && id != GCBlocks.brightAir) {
                            if (this.canBlockPassAirCheck(id, sideVec, side)) {
                                nextLayer.add(sideVec);
                            }
                        } else if (id != null) {
                            this.checkedAdd(sideVec);
                        }
                    }
                    ++side;
                } while (side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void doLayer() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block airID = Blocks.field_150350_a;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block airIDBright = GCBlocks.brightAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        World world = this.world;
        while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                int bits = vec.sideDoneBits;
                do {
                    Block id;
                    if ((bits & 1 << side) != 0 || this.checkedContains(vec, side)) continue;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    if (this.checkCount > 0) {
                        --this.checkCount;
                        id = sideVec.getBlockIDsafe_noChunkLoad(world);
                        if (id == breatheableAirID) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.ambientThermalTracked.add(sideVec);
                            continue;
                        }
                        if (id == airID) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == breatheableAirIDBright) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.ambientThermalTracked.add(sideVec);
                            continue;
                        }
                        if (id == airIDBright) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.airToReplaceBright.add(sideVec);
                            continue;
                        }
                        if (id == null) {
                            this.checkCount = 0;
                            this.sealed = false;
                            return;
                        }
                        if (id == oxygenSealerID) {
                            TileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                            if (sealer != null && !this.sealers.contains(sealer)) {
                                if (side != 0) continue;
                                this.checkedAdd(sideVec);
                                this.sealers.add(sealer);
                                if (sealer.thermalControlEnabled()) {
                                    this.foundAmbientThermal = true;
                                }
                                this.checkCount += sealer.getFindSealChecks();
                                continue;
                            }
                            this.checkedAdd(sideVec);
                            continue;
                        }
                        if (!this.canBlockPassAirCheck(id, sideVec, side)) continue;
                        nextLayer.add(sideVec);
                        continue;
                    }
                    id = sideVec.getBlockIDsafe_noChunkLoad(this.world);
                    if (id != null && id != airID && id != breatheableAirID && id != airIDBright && id != breatheableAirIDBright && !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    this.sealed = false;
                    if (this.sealers.size() > 0) {
                        vec.sideDoneBits = side << 6;
                        this.traceLeak(vec);
                    }
                    return;
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void doLayerNearMapEdge() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block airID = Blocks.field_150350_a;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block airIDBright = GCBlocks.brightAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                int bits = vec.sideDoneBits;
                do {
                    Block id;
                    if ((bits & 1 << side) != 0 || this.checkedContains(vec, side)) continue;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    if (this.checkCount > 0) {
                        --this.checkCount;
                        id = sideVec.getBlockID_noChunkLoad(this.world);
                        if (id == breatheableAirID) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.ambientThermalTracked.add(sideVec);
                            continue;
                        }
                        if (id == airID) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == breatheableAirIDBright) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.ambientThermalTracked.add(sideVec);
                            continue;
                        }
                        if (id == airIDBright) {
                            this.checkedAdd(sideVec);
                            nextLayer.add(sideVec);
                            this.airToReplaceBright.add(sideVec);
                            continue;
                        }
                        if (id == null) {
                            this.checkCount = 0;
                            this.sealed = false;
                            return;
                        }
                        if (id == oxygenSealerID) {
                            TileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                            if (sealer != null && !this.sealers.contains(sealer)) {
                                if (side != 0) continue;
                                this.checkedAdd(sideVec);
                                this.sealers.add(sealer);
                                if (sealer.thermalControlEnabled()) {
                                    this.foundAmbientThermal = true;
                                }
                                this.checkCount += sealer.getFindSealChecks();
                                continue;
                            }
                            this.checkedAdd(sideVec);
                            continue;
                        }
                        if (!this.canBlockPassAirCheck(id, sideVec, side)) continue;
                        nextLayer.add(sideVec);
                        continue;
                    }
                    id = sideVec.getBlockID_noChunkLoad(this.world);
                    if (id != null && id != airID && id != breatheableAirID && id != airIDBright && id != breatheableAirIDBright && !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    this.sealed = false;
                    if (this.sealers.size() > 0) {
                        vec.sideDoneBits = side << 6;
                        this.traceLeak(vec);
                    }
                    return;
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void checkedAdd(BlockVec3 vec) {
        int dx = this.head.x - vec.x;
        int dz = this.head.z - vec.z;
        if (dx < -8191 || dx > 8192) {
            return;
        }
        if (dz < -8191 || dz > 8192) {
            return;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        bucket.add(vec.y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) + ((vec.sideDoneBits & 0x1C0) << 18) << 4));
    }

    private boolean checkedContains(BlockVec3 vec) {
        int dx = this.head.x - vec.x;
        int dz = this.head.z - vec.z;
        if (dx < -8191 || dx > 8192) {
            return true;
        }
        if (dz < -8191 || dz > 8192) {
            return true;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        return bucket.contains(vec.y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private boolean checkedContains(BlockVec3 vec, int side) {
        int y = vec.y;
        int dx = this.head.x - vec.x;
        int dz = this.head.z - vec.z;
        switch (side) {
            case 0: {
                if (--y >= 0) break;
                return false;
            }
            case 1: {
                if (++y <= 255) break;
                return false;
            }
            case 2: {
                ++dz;
                break;
            }
            case 3: {
                --dz;
                break;
            }
            case 4: {
                ++dx;
                break;
            }
            case 5: {
                --dx;
            }
        }
        if (dx < -8191 || dx > 8192) {
            return true;
        }
        if (dz < -8191 || dz > 8192) {
            return true;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        return bucket.contains(y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private BlockVec3 checkedContainsTrace(int x, int y, int z) {
        int dx = this.head.x - x;
        int dz = this.head.z - z;
        if (dx < -8191 || dx > 8192) {
            return null;
        }
        if (dz < -8191 || dz > 8192) {
            return null;
        }
        intBucket bucket = this.buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        int side = bucket.getMSB4shifted(y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
        if (side >= 0) {
            BlockVec3 vec = new BlockVec3(x, y, z);
            vec.sideDoneBits = side;
            return vec;
        }
        return null;
    }

    private void checkedInit() {
        for (int i = 0; i < 256; ++i) {
            this.buckets[i] = new intBucket();
        }
    }

    private void checkedClear() {
        for (int i = 0; i < 256; ++i) {
            this.buckets[i].clear();
        }
        this.checkedSize = 0;
    }

    public List<BlockVec3> checkedAll() {
        LinkedList<BlockVec3> list = new LinkedList<BlockVec3>();
        for (int i = 0; i < 256; ++i) {
            if (this.buckets[i].size() == 0) continue;
            int ddx = i >> 4;
            int ddz = i & 0xF;
            int[] ints = this.buckets[i].contents();
            for (int j = 0; j < this.buckets[i].size(); ++j) {
                int k = ints[j];
                int y = k & 0xFF;
                int dx = ((k >>= 4) & 0x3FF0) + ddx;
                int dz = (k >> 10 & 0x3FF0) + ddz;
                if (dx > 8192) {
                    dx -= 16384;
                }
                if (dz > 8192) {
                    dz -= 16384;
                }
                list.add(new BlockVec3(this.head.x + dx, y, this.head.z + dz));
            }
        }
        return list;
    }

    private void traceLeak(BlockVec3 tracer) {
        GCLog.debug("Leak tracing test length = " + this.checkedSize);
        ArrayList<BlockVec3> route = new ArrayList<BlockVec3>();
        BlockVec3 start = this.head.clone().translate(0, 1, 0);
        int x = tracer.x;
        int y = tracer.y;
        int z = tracer.z;
        for (int count = 0; !tracer.equals(start) && count < 90; ++count) {
            route.add(tracer);
            switch (tracer.sideDoneBits >> 6) {
                case 1: {
                    --y;
                    break;
                }
                case 0: {
                    ++y;
                    break;
                }
                case 3: {
                    --z;
                    break;
                }
                case 2: {
                    ++z;
                    break;
                }
                case 5: {
                    --x;
                    break;
                }
                case 4: {
                    ++x;
                }
            }
            tracer = this.checkedContainsTrace(x, y, z);
            if (tracer != null) continue;
            return;
        }
        this.leakTrace = new ArrayList<BlockVec3>();
        this.leakTrace.add(start);
        for (int j = route.size() - 1; j >= 0; --j) {
            this.leakTrace.add((BlockVec3)route.get(j));
        }
    }

    private boolean canBlockPassAirCheck(Block block, BlockVec3 vec, int side) {
        ArrayList<Integer> metaList;
        if (block instanceof IPartialSealableBlock) {
            IPartialSealableBlock blockPartial = (IPartialSealableBlock)block;
            if (blockPartial.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side))) {
                --this.checkCount;
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                if (i == side || !blockPartial.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)i))) continue;
                vec.setSideDone(i ^ 1);
            }
            this.checkedAdd(vec);
            return true;
        }
        if (block instanceof BlockLeavesBase) {
            this.checkedAdd(vec);
            return true;
        }
        if (block.func_149662_c()) {
            this.checkedAdd(vec);
            return block instanceof BlockGravel || block.func_149688_o() == Material.field_151580_n || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            this.checkedAdd(vec);
            return false;
        }
        if (OxygenPressureProtocol.nonPermeableBlocks.containsKey(block) && ((metaList = OxygenPressureProtocol.nonPermeableBlocks.get(block)).contains(-1) || metaList.contains(vec.getBlockMetadata((IBlockAccess)this.world)))) {
            this.checkedAdd(vec);
            return false;
        }
        if (block instanceof BlockUnlitTorch) {
            this.torchesToUpdate.add(vec);
            this.checkedAdd(vec);
            return true;
        }
        if (block instanceof BlockSlab) {
            boolean isTopSlab;
            boolean bl = isTopSlab = (vec.getBlockMetadata((IBlockAccess)this.world) & 8) == 8;
            if (side == 0 && isTopSlab || side == 1 && !isTopSlab) {
                --this.checkCount;
                return false;
            }
            vec.setSideDone(isTopSlab ? 1 : 0);
            this.checkedAdd(vec);
            return true;
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            if (side == 1) {
                --this.checkCount;
                return false;
            }
            vec.setSideDone(0);
            this.checkedAdd(vec);
            return true;
        }
        if (block instanceof BlockPistonBase) {
            BlockPistonBase piston = (BlockPistonBase)block;
            int meta = vec.getBlockMetadata((IBlockAccess)this.world);
            if (BlockPistonBase.func_150075_c((int)meta)) {
                int facing = BlockPistonBase.func_150076_b((int)meta);
                if (side == facing) {
                    --this.checkCount;
                    return false;
                }
                vec.setSideDone(facing ^ 1);
                this.checkedAdd(vec);
                return true;
            }
            this.checkedAdd(vec);
            return false;
        }
        if (block.isSideSolid((IBlockAccess)this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1)))) {
            if (block.func_149688_o().func_76230_c() && block.func_149686_d()) {
                this.checkedAdd(vec);
                return false;
            }
            --this.checkCount;
            return false;
        }
        if (block.func_149688_o() == Material.field_151579_a) {
            this.checkedAdd(vec);
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == (side ^ 1) || !block.isSideSolid((IBlockAccess)this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)i))) continue;
            vec.setSideDone(i);
        }
        this.checkedAdd(vec);
        return true;
    }

    public class intBucket {
        private int maxSize = 64;
        private int size = 0;
        private int[] table = new int[this.maxSize];

        public void add(int i) {
            if (this.contains(i)) {
                return;
            }
            if (this.size >= this.maxSize) {
                int[] newTable = new int[this.maxSize + this.maxSize];
                System.arraycopy(this.table, 0, newTable, 0, this.maxSize);
                this.table = newTable;
                this.maxSize += this.maxSize;
            }
            this.table[this.size] = i;
            ++this.size;
            ThreadFindSeal.this.checkedSize++;
        }

        public boolean contains(int test) {
            for (int i = this.size - 1; i >= 0; --i) {
                if ((this.table[i] & 0xFFFFFFF) != test) continue;
                return true;
            }
            return false;
        }

        public int getMSB4shifted(int test) {
            for (int i = this.size - 1; i >= 0; --i) {
                if ((this.table[i] & 0xFFFFFFF) != test) continue;
                return (this.table[i] & 0xF0000000) >> 22;
            }
            return -1;
        }

        public void clear() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public int[] contents() {
            return this.table;
        }
    }

    public class ThreadedFindSeal
    extends Thread {
        public ThreadedFindSeal() {
            super("GC Sealer Roomfinder Thread");
            anylooping.set(true);
            if (this.isAlive()) {
                this.interrupt();
            }
            this.start();
        }

        @Override
        public void run() {
            ThreadFindSeal.this.check();
            anylooping.set(false);
        }
    }
}

